/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom.flatten;

import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.flatten.TrivialJsCodeGenerator;
import org.eclipse.wst.jsdt.internal.esprima.EsprimaParser;
import org.junit.Assert;
import org.junit.Test;

public class JsCodeGeneratorTest {
    @Test
    public void testLiteralStringExpression1() {
        this.test("\"\"");
    }

    @Test
    public void testLiteralStringExpression2() {
        this.test("\"\"", "('')");
    }

    @Test
    public void testLiteralStringExpression3() {
        this.test("\"a\"", "('a')");
    }

    @Test
    public void testLiteralStringExpression4() {
        this.test("\"\\\"\"");
    }

    @Test
    public void testLiteralStringExpression5() {
        this.test("\"a\"", "('a')");
    }

    @Test
    public void testLiteralStringExpression6() {
        this.test("\"'\"", "('\\'')");
    }

    @Test
    public void testLiteralStringExpression7() {
        this.test("\"a\"");
    }

    @Test
    public void testLiteralStringExpression8() {
        this.test("'\"'");
    }

    @Test
    public void testLiteralStringExpression9() {
        this.test("\"\\0\\b\\n\\r\\t\\v\\f\\\\\\\"'\\u2028\\u2029\u65e5\u672c\"");
    }

    @Test
    public void testLiteralBooleanExpression() {
        this.test("true");
        this.test("false");
    }

    @Test
    public void testLiteralNullExpression() {
        this.test("null");
        this.test("null", "nul\\u006c");
    }

    @Test
    public void testLiteralRegExpExpression() {
        this.test("/a/");
        this.test("/a/i");
        this.test("/a/ig");
        this.test("/a\\s/ig");
        this.test("/a\\r/ig");
        this.test("/a\\r/ instanceof 3");
        this.test("/a\\r/g instanceof 3");
    }

    @Test
    public void testExpressionStatement1() {
        this.test("a");
        this.test("~{a:3}");
        this.test("a:~{a:3}");
        this.test("~function(){}");
        this.test("~function(){}()");
        this.test("function name(){}");
    }

    @Test
    public void testExpressionStatement2() {
        this.test("({a:3}+1)");
        this.test("({a:3})");
        this.test("do({a:3});while(1)");
    }

    @Test
    public void testBlockStatement() {
        this.test("{}");
        this.test("{{}}");
        this.test("{a:{}}");
        this.test("{a;b}", "{a\nb\n}");
    }

    @Test
    public void testSequence() {
        this.test("a,b,c,d");
    }

    @Test
    public void testSpreadElement() {
        this.test("[...a]");
        this.test("[...a,...b]");
        this.test("[...a,b,...c]");
        this.test("[...a=b]");
        this.test("[...(a,b)]");
        this.test("f(...a)");
    }

    @Test
    public void testVariableDeclarationStatement1() {
        this.test("var a=0");
    }

    @Test
    public void testVariableDeclarationStatement2() {
        this.test("var a=0,b=0");
    }

    @Test
    public void testVariableDeclarationStatement3() {
        this.test("var a=(0,0)");
    }

    @Test
    public void testVariableDeclarationStatement4() {
        this.test("var a=(0,0,0)");
        this.test("var a");
        this.test("var a,b");
        this.test("var a=\"\"in{}");
    }

    @Test
    public void testEquality1() {
        this.test("a==b");
        this.test("a!=b");
        this.test("a==b");
        this.test("a!=b");
        this.test("a==b==c");
    }

    @Test
    public void testEquality2() {
        this.test("a==(b==c)");
    }

    @Test
    public void testLogicalAnd() {
        this.test("a&&b");
    }

    @Test
    public void testLogicalOr() {
        this.test("a||b");
    }

    @Test
    public void testBitwiseOr() {
        this.test("a|b");
    }

    @Test
    public void testBitwiseAnd() {
        this.test("a&b");
    }

    @Test
    public void testBitwiseXor1() {
        this.test("a^b");
    }

    @Test
    public void testBitwiseXor2() {
        this.test("a^b&b");
    }

    @Test
    public void testBitwiseXor3() {
        this.test("(a^b)&b");
    }

    @Test
    public void testAdditive1() {
        this.test("a+b");
        this.test("a-b");
        this.test("a+b<<b");
    }

    @Test
    public void testAdditive2() {
        this.test("a+(b+b)");
    }

    @Test
    public void testAdditive3() {
        this.test("a+(b<<b)");
    }

    @Test
    public void testAdditive4() {
        this.test("(a<<b)+(c>>d)");
    }

    @Test
    public void testAdditive5() {
        this.test("a*b+c/d", "(a*b)+(c/d)");
    }

    @Test
    public void testAdditive6() {
        this.test("(a+b)*(c-d)");
    }

    @Test
    public void testMultiplicative1() {
        this.test("a*b");
        this.test("a/b");
        this.test("a%b");
        this.test("a%b%c");
        this.test("a+b%c");
        this.test("!a*b");
    }

    @Test
    public void testMultiplicative2() {
        this.test("a%(b%c)");
    }

    @Test
    public void testMultiplicative3() {
        this.test("(a+b)%c");
    }

    @Test
    public void testMultiplicative4() {
        this.test("a*(b+c)");
    }

    @Test
    public void testPostfix() {
        this.test("a++");
        this.test("a--");
    }

    @Test
    public void testPrefix() {
        this.test("+a");
        this.test("-a");
        this.test("!a");
        this.test("~a");
        this.test("typeof a");
        this.test("void a");
        this.test("delete a");
        this.test("++a");
        this.test("--a");
        this.test("+ ++a");
        this.test("- --a");
        this.test("a+ +a");
        this.test("a-a");
        this.test("typeof-a");
        this.test("!!a");
        this.test("!!(a+a)");
    }

    @Test
    public void testPrimary() {
        this.test("0");
        this.test("1");
        this.test("2");
        this.test("(\"a\")", "('a')");
        this.test("(\"'\")", "('\\'')");
        this.test(";\"a\"");
        this.test(";'\"'");
        this.test("/a/");
        this.test("/a/i");
        this.test("/a/ig");
        this.test("/a\\s/ig");
        this.test("/a\\r/ig");
        this.test("/a\\r/ instanceof 3");
        this.test("/a\\r/g instanceof 3");
        this.test("3/ /a/g");
        this.test("true");
        this.test("false");
        this.test("null");
        this.test("null", "nul\\u006c");
        this.test("(function(){})");
    }

    @Test
    public void testRelational() {
        this.test("a<b");
        this.test("a<=b");
        this.test("a>b");
        this.test("a>=b");
        this.test("a instanceof b");
        this.test("a in b");
        this.test("a==b<b");
        this.test("(a==b)<b");
        this.test("for((b in b);;);");
        this.test("for((b in b);b in b;b in b);");
        this.test("for(var a=(b in b);b in b;b in b);");
        this.test("for(var a=(b in b),c=(b in b);b in b;b in b);");
        this.test("for(b in c in d);");
    }

    @Test
    public void testShift() {
        this.test("a<<b");
        this.test("a>>b");
        this.test("a>>>b");
        this.test("a<<b<<c");
        this.test("a<<(b<<c)");
        this.test("a<<b<c");
        this.test("a<<b<c");
        this.test("a<<(b<c)");
    }

    @Test
    public void testAssignment() {
        this.test("a=b");
    }

    @Test
    public void testCompoundAssignment1() {
        this.test("a+=b");
        this.test("a*=b");
        this.test("a%=b");
        this.test("a<<=b");
        this.test("a>>=b");
        this.test("a>>>=b");
    }

    @Test
    public void testCompoundAssignment2() {
        this.test("a/=b");
        this.test("a|=b");
        this.test("a^=b");
        this.test("a,b=c");
        this.test("a=b,c");
        this.test("a>>>=b");
        this.test("a,b^=c");
        this.test("a^=b,c");
        this.test("a.b=0");
        this.test("a[b]=0");
    }

    @Test
    public void testCompoundAssignment3() {
        this.test("a=(b,c)");
        this.test("a^=(b,c)");
    }

    @Test
    public void testCodeGenDirectives1() {
        this.test("\"use strict\"");
    }

    @Test
    public void testCodeGenDirectives2() {
        this.test("\"use strict\"", "\"use\\u0020strict\"");
    }

    @Test
    public void testArrayExpression1() {
        this.test("[]");
    }

    @Test
    public void testArrayExpression2() {
        this.test("[a]");
    }

    @Test
    public void testArrayExpression3() {
        this.test("[a]", "[a,]");
    }

    @Test
    public void testArrayExpression4() {
        this.test("[a,b,c]", "[a,b,c,]");
    }

    @Test
    public void testArrayExpression5() {
        this.test("[a]", "[a,,]");
    }

    @Test
    public void testArrayExpression6() {
        this.test("[a]", "[a,,,]");
    }

    @Test
    public void testArrayExpression7() {
        this.test("[[a]]");
    }

    @Test
    public void testArrayExpression8() {
        this.test("[(a,a)]");
    }

    @Test
    public void testArrayExpression9() {
        this.test("[]", "[,]");
    }

    @Test
    public void testArrayExpression10() {
        this.test("[,];", "[,,]");
    }

    @Test
    public void testArrayExpression11() {
        this.test("[,,]", "[,,,]");
    }

    @Test
    public void testArrayBinding1() {
        this.test("[]=0");
    }

    @Test
    public void testArrayBinding2() {
        this.test("[...a]=0");
    }

    @Test
    public void testArrayBinding3() {
        this.test("[a,...a]=0");
    }

    @Test
    public void testArrayBinding4() {
        this.test("[a,a=0,...a]=0");
    }

    @Test
    public void testArrayBinding5() {
        this.test("[,]=0;", "[,,]=0");
    }

    @Test
    public void testArrayBinding6() {
        this.test("[,...a]=0");
    }

    @Test
    public void testBindingPropertyIdentifier() {
        this.test("{a=0}=0", "({a=0}=0)");
    }

    @Test
    public void testBindingPropertyProperty() {
        this.test("({a : b}=0)");
    }

    @Test
    public void testBindingWithDefault1() {
        this.test("[a=0]=0");
    }

    @Test
    public void testBindingWithDefault2() {
        this.test("({a:b=0}=0)");
    }

    @Test
    public void testDoWhileStatement1() {
        this.test("do;while(1)");
    }

    @Test
    public void testDoWhileStatement2() {
        this.test("do{}while(1)");
    }

    @Test
    public void testDoWhileStatement3() {
        this.test("do debugger;while(1)");
    }

    @Test
    public void testDoWhileStatement4() {
        this.test("do if(3){}while(1)");
    }

    @Test
    public void testDoWhileStatement5() {
        this.test("do 3;while(1)", "do(3);while(1)");
    }

    @Test
    public void testWhileStatement1() {
        this.test("while(0);");
    }

    @Test
    public void testWhileStatement2() {
        this.test("while(0)while(0);");
    }

    @Test
    public void testWithStatement1() {
        this.test("with(0);");
    }

    @Test
    public void testWithStatement2() {
        this.test("with(0)with(0);");
    }

    @Test
    public void testWithStatement3() {
        this.test("with(null);");
    }

    @Test
    public void testForStatement1() {
        this.test("for(var i=(1 in[]);;);");
    }

    @Test
    public void testForStatement2() {
        this.test("for(var i=(1 in[]),b,c=(1 in[]);;);");
    }

    @Test
    public void testForStatement3() {
        this.test("for((1 in[]);;);");
    }

    @Test
    public void testForStatement4() {
        this.test("for(1*(1 in[]);;);");
    }

    @Test
    public void testForStatement5() {
        this.test("for(1*(1+1 in[]);;);");
    }

    @Test
    public void testForStatement6() {
        this.test("for(1*(1+1 in[]);;);");
    }

    @Test
    public void testForStatement7() {
        this.test("for(1*(1+(1 in[]));;);");
    }

    @Test
    public void testForInStatement1() {
        this.test("for(var a in 1);");
    }

    @Test
    public void testForInStatement2() {
        this.test("for((let)in 1);");
    }

    @Test
    public void testForInStatement3() {
        this.test("for(a in 1);");
    }

    @Test
    public void testForOfStatement1() {
        this.test("for(a of b);");
    }

    @Test
    public void testForOfStatement2() {
        this.test("for([a]of[b]);");
    }

    @Test
    public void testForOfStatement3() {
        this.test("for(let[a]of[b]);");
    }

    @Test
    public void testBreakStatement() {
        this.test("while(1)break", "while(1)break");
        this.test("while(1){break;break}", "while(1){break;break;}");
        this.test("a:while(1){break;break a}", "a:while(1){break;break a;}");
        this.test("switch(1){case 1:break}", "switch(1){case 1:break;}");
    }

    @Test
    public void testContinueStatement() {
        this.test("while(1)continue", "while(1)continue");
        this.test("while(1){continue;continue}", "while(1){continue;continue;}");
        this.test("a:while(1){continue;continue a}", "a:while(1){continue;continue a;}");
    }

    @Test
    public void testReturnStatement() {
        this.test("function a(){return}");
        this.test("function a(){return 0}");
        this.test("function a(){return function a(){return 0}}");
    }

    @Test
    public void testIfStatement1() {
        this.test("if(a);");
    }

    @Test
    public void testIfStatement2() {
        this.test("if(a)b");
    }

    @Test
    public void testIfStatement3() {
        this.test("if(a)if(a)b");
    }

    @Test
    public void testIfStatement4() {
        this.test("if(a){}");
    }

    @Test
    public void testIfStatement5() {
        this.test("if(a);else;");
    }

    @Test
    public void testIfStatement6() {
        this.test("if(a);else{}");
    }

    @Test
    public void testIfStatement7() {
        this.test("if(a){}else{}");
    }

    @Test
    public void testIfStatement8() {
        this.test("if(a)if(a){}else{}else{}");
    }

    @Test
    public void testConditional1() {
        this.test("a?b:c");
        this.test("a?b?c:d:e");
        this.test("a?b:c?d:e");
        this.test("a?b?c:d:e?f:g");
        this.test("a?b=c:d");
        this.test("a?b=c:d=e");
        this.test("a||b?c=d:e=f");
        this.test("a?b||c:d");
        this.test("a?b:c||d");
    }

    @Test
    public void testConditional2() {
        this.test("(a?b:c)?d:e");
    }

    @Test
    public void testConditional3() {
        this.test("(a,b)?(c,d):(e,f)");
    }

    @Test
    public void testConditional4() {
        this.test("(a=b)?c:d");
    }

    @Test
    public void testConditional5() {
        this.test("a||(b?c:d)");
    }

    @Test
    public void testSwitchStatement() {
        this.test("switch(0){}");
        this.test("switch(0){default:}");
        this.test("switch(0){case 0:default:}");
        this.test("switch(0){case 0:a;default:c:b}");
    }

    @Test
    public void testLabeledStatement1() {
        this.test("a:;");
    }

    @Test
    public void testLabeledStatement2() {
        this.test("a:b:;");
    }

    @Test
    public void testFunctionDeclaration1() {
        this.test("function f(){}");
    }

    @Test
    public void testFunctionDeclaration2() {
        this.test("function* f(){}");
    }

    @Test
    public void testFunctionDeclaration3() {
        this.test("function f(a){}");
    }

    @Test
    public void testFunctionDeclaration4() {
        this.test("function f(a,b){}");
    }

    @Test
    public void testFunctionDeclaration5() {
        this.test("function f(a,b,...rest){}");
    }

    @Test
    public void testFunctionExpression1() {
        this.test("function (){}", "(function(){})");
    }

    @Test
    public void testFunctionExpression2() {
        this.test("function f(){}", "(function f(){})");
    }

    @Test
    public void testFunctionExpression3() {
        this.test("function* (){}", "(function*(){})");
    }

    @Test
    public void testFunctionExpression4() {
        this.test("function* f(){}", "(function*f(){})");
    }

    @Test
    public void testSwitchStatement1() {
        this.test("switch(0){}");
    }

    @Test
    public void testSwitchStatement2() {
        this.test("switch(0){default:}");
    }

    @Test
    public void testSwitchStatement3() {
        this.test("switch(0){case 0:default:}");
    }

    @Test
    public void testSwitchStatement4() {
        this.test("switch(0){case 0:a;default:c:b}");
    }

    @Test
    public void testThrowStatement1() {
        this.test("throw 0");
    }

    @Test
    public void testThrowStatement2() {
        this.test("throw(1<1)+1");
    }

    @Test
    public void testTryStatement1() {
        this.test("try{}catch(a){}");
    }

    @Test
    public void testTryStatement2() {
        this.test("try{}catch(a){}finally{}");
    }

    @Test
    public void testTryStatement3() {
        this.test("try{}finally{}");
    }

    @Test
    public void testClassDeclaration1() {
        this.test("class A{get[[]](){}[1.54321](){}}");
    }

    @Test
    public void testClassDeclaration2() {
        this.test("class A{}");
    }

    @Test
    public void testClassDeclaration3() {
        this.test("class A extends B{}");
    }

    @Test
    public void testClassElement1() {
        this.test("(class{a(){}})");
    }

    @Test
    public void testClassElement2() {
        this.test("(class{*a(){}})");
    }

    @Test
    public void testClassElement3() {
        this.test("(class{static a(){}})");
    }

    @Test
    public void testClassElement4() {
        this.test("(class{static*a(){}})");
    }

    @Test
    public void testClassElement5() {
        this.test("(class{constructor(){}})");
    }

    @Test
    public void testObjectExpression1() {
        this.test("{}", "({})");
    }

    @Test
    public void testObjectExpression2() {
        this.test("{a:1}", "({a:1,})");
    }

    @Test
    public void testObjectExpression3() {
        this.test("{}.a--", "({}.a--)");
    }

    @Test
    public void testObjectExpression4() {
        this.test("{1:1}", "({1.0:1})");
    }

    @Test
    public void testObjectExpression5() {
        this.test("{a:b}", "({a:b})");
    }

    @Test
    public void testObjectExpression6() {
        this.test("{get a(){;}}", "({get a(){;}})");
    }

    @Test
    public void testObjectExpression7() {
        this.test("{set a(param){;}}", "({set a(param){;}})");
    }

    @Test
    public void testObjectExpression8() {
        this.test("{get a(){;},set a(param){;},b:1}", "({get a(){;},set a(param){;},b:1})");
    }

    @Test
    public void testObjectExpression9() {
        this.test("{a:(a,b)}", "({a:(a,b)})");
    }

    @Test
    public void testObjectExpression10() {
        this.test("{a}", "({a})");
    }

    @Test
    public void testYieldExpression1() {
        this.test("function*f(){yield}");
    }

    @Test
    public void testYieldExpression2() {
        this.test("function*f(){yield a}");
    }

    @Test
    public void testYieldExpression3() {
        this.test("function*f(){yield 0}");
    }

    @Test
    public void testYieldExpression4() {
        this.test("function*f(){yield{}}");
    }

    @Test
    public void testYieldExpression5() {
        this.test("function*f(){yield a+b}");
    }

    @Test
    public void testYieldExpression6() {
        this.test("function*f(){yield a=b}");
    }

    @Test
    public void testYieldExpression7() {
        this.test("function*f(){yield(a,b)}");
    }

    @Test
    public void testYieldExpression8() {
        this.test("function*f(){f(yield,yield)}");
    }

    @Test
    public void testYieldExpression9() {
        this.test("function*f(){f(yield a,yield b)}");
    }

    @Test
    public void testYieldExpression10() {
        this.test("function*f(){yield yield yield}");
    }

    @Test
    public void testArrowExpression1() {
        this.test("a=>a");
    }

    @Test
    public void testArrowExpression2() {
        this.test("()=>a");
    }

    @Test
    public void testArrowExpression3() {
        this.test("a=>a", "(a)=>a");
    }

    @Test
    public void testArrowExpression4() {
        this.test("(...a)=>a");
    }

    @Test
    public void testArrowExpression5() {
        this.test("(a,...b)=>a");
    }

    @Test
    public void testArrowExpression6() {
        this.test("(a=0)=>a");
    }

    @Test
    public void testArrowExpression7() {
        this.test("(a,b)=>a");
    }

    @Test
    public void testArrowExpression8() {
        this.test("({a})=>a");
    }

    @Test
    public void testArrowExpression9() {
        this.test("({a=0})=>a");
    }

    @Test
    public void testArrowExpression10() {
        this.test("([a])=>a");
    }

    @Test
    public void testArrowExpression11() {
        this.test("a=>({})");
    }

    @Test
    public void testArrowExpression12() {
        this.test("a=>{}");
    }

    @Test
    public void testArrowExpression13() {
        this.test("a=>{({})}");
    }

    @Test
    public void testArrowExpression14() {
        this.test("a=>{0;return}");
    }

    @Test
    public void testArrowExpression15() {
        this.test("()=>function(){}");
    }

    @Test
    public void testArrowExpression16() {
        this.test("()=>class{}");
    }

    @Test
    public void testArrowExpression17() {
        this.test("()=>(1,2)");
    }

    @Test
    public void testArrowExpression18() {
        this.test("(()=>0)()");
    }

    @Test
    public void testTemplateExpression1() {
        this.test("``");
        this.test("````");
        this.test("a``");
        this.test("a.b``");
        this.test("a[b]``");
        this.test("a()[b]``");
        this.test("a()``");
    }

    @Test
    public void testTemplateExpression2() {
        this.test("(a+b)``");
    }

    @Test
    public void testTemplateExpression3() {
        this.test("function(){}``", "(function(){})``");
    }

    @Test
    public void testTemplateExpression4() {
        this.test("class{}``", "(class{})``");
    }

    @Test
    public void testTemplateExpression5() {
        this.test("{}``", "({})``");
    }

    @Test
    public void testTemplateExpression6() {
        this.test("`a`");
    }

    @Test
    public void testTemplateExpression7() {
        this.test("a`a`");
    }

    @Test
    public void testTemplateExpression8() {
        this.test("`a${b}c`");
    }

    @Test
    public void testTemplateExpression9() {
        this.test("`${a}`");
    }

    @Test
    public void testTemplateExpression10() {
        this.test("`${a}${b}`");
    }

    @Test
    public void testTemplateExpression11() {
        this.test("` ${a} ${b} `");
    }

    @Test
    public void testTemplateExpression12() {
        this.test("` ${a} ${b} `", "` ${ a } ${ b } `");
    }

    @Test
    public void testTemplateExpression13() {
        this.test("`a\\${b}c`");
    }

    @Test
    public void testTemplateExpression14() {
        this.test("``.a");
    }

    @Test
    public void testTemplateExpression15() {
        this.test("``()");
    }

    @Test
    public void testTemplateExpression16() {
        this.test("new``");
    }

    @Test
    public void testTemplateExpression17() {
        this.test("new``", "new ``()");
    }

    @Test
    public void testTemplateExpression18() {
        this.test("new``(a)", "new ``(a)");
    }

    @Test
    public void testTemplateExpression19() {
        this.test("aTag`this blog lives ${cheer} at ${host}`");
    }

    @Test
    public void testSuper1() {
        this.test("class A extends B{constructor(){super()}}");
    }

    @Test
    public void testSuper2() {
        this.test("({m(){super.m()}})");
    }

    @Test
    public void testNewCallMember() {
        this.test("new a");
        this.test("new a(a)");
        this.test("new a(a,b)");
        this.test("new this.a");
        this.test("a()");
        this.test("a(a)");
        this.test("a(a,b)");
        this.test("a.a");
        this.test("a[a]");
        this.test("new a", "new a()");
        this.test("new a(a)");
        this.test("(new a).a", "new a().a");
        this.test("new a(a).v");
        this.test("new(a(a).v)");
        this.test("(new a)()");
        this.test("(new new a(a).a.a).a", "(new (new a(a).a).a).a");
        this.test("new((new a)().a)", "new((new a)()).a");
        this.test("new a.a");
        this.test("new(a().a)");
        this.test("(new a``).a");
    }

    @Test
    public void testNewTargetExpression() {
        this.test("function f(){new.target}");
        this.test("function f(){new.target}", "function f() { new . target }");
    }

    @Test
    public void testExport() {
        this.test("export var a");
        this.test("export var a;0");
        this.test("export var a=0");
        this.test("export var a,b");
        this.test("export var a=0,b=0");
        this.test("export const a=0");
        this.test("export let a");
        this.test("export function f(){}");
        this.test("export function f(){}0");
        this.test("export class A{}");
        this.test("export class A{}0");
    }

    @Test
    public void testExportAllFrom() {
        this.test("export*from\"m\"");
        this.test("export*from\"m\";0");
    }

    @Test
    public void testExportDefault() {
        this.test("export default function(){}");
        this.test("export default function(){}0");
        this.test("export default 0");
        this.test("export default 0;0");
        this.test("export default function f(){}");
        this.test("export default function*f(){}");
        this.test("export default class A{}");
        this.test("export default(class{})");
        this.test("export default(function(){})");
        this.test("export default{}");
    }

    @Test
    public void testExportFrom() {
        this.test("export{}from\"m\"");
        this.test("export{}from\"m\";0");
        this.test("let a;export{a}from\"m\"");
        this.test("let a,b;export{a,b}from\"m\"");
        this.test("export{}");
        this.test("let a;export{a}");
        this.test("let a,b;export{a,b}");
    }

    @Test
    public void testExportSpecifier() {
        this.test("let a;export{a}");
        this.test("let a,b;export{a as b}");
        this.test("let a,b;export{a,b}");
        this.test("let a,b,c;export{a,b as c}");
        this.test("let a,b,c;export{a as b,c}");
        this.test("let a,b,c,d;export{a as b,c as d}");
    }

    @Test
    public void testImport1() {
        this.test("import\"m\"");
    }

    @Test
    public void testImport2() {
        this.test("import\"m\";0");
    }

    @Test
    public void testImport3() {
        this.test("import a from\"m\"");
    }

    @Test
    public void testImport4() {
        this.test("import{a}from\"m\"");
    }

    @Test
    public void testImport5() {
        this.test("import{a,b}from\"m\"");
    }

    @Test
    public void testImport6() {
        this.test("import a,{b}from\"m\"");
    }

    @Test
    public void testImport7() {
        this.test("import a,{b,c}from\"m\"");
    }

    @Test
    public void testImport8() {
        this.test("import a,{b,c}from\"m\";0");
    }

    @Test
    public void testImport9() {
        this.test("import\"m\"", "import {} from \"m\"");
    }

    @Test
    public void testImport10() {
        this.test("import a from\"m\"", "import a,{}from \"m\"");
    }

    @Test
    public void testImportNamespace1() {
        this.test("import*as a from\"m\"");
    }

    @Test
    public void testImportNamespace2() {
        this.test("import*as a from\"m\";0");
    }

    @Test
    public void testImportNamespace3() {
        this.test("import a,*as b from\"m\"");
    }

    @Test
    public void testImportSpecifier1() {
        this.test("import{a}from\"m\"");
    }

    @Test
    public void testImportSpecifier2() {
        this.test("import{a}from\"m\";0");
    }

    @Test
    public void testImportSpecifier3() {
        this.test("import{a as b}from\"m\"");
    }

    @Test
    public void testImportSpecifier4() {
        this.test("import{a,b}from\"m\"");
    }

    @Test
    public void testImportSpecifier5() {
        this.test("import{a,b as c}from\"m\"");
    }

    @Test
    public void testImportSpecifier6() {
        this.test("import{a as b,c}from\"m\"");
    }

    @Test
    public void testImportSpecifier7() {
        this.test("import{a as b,c as d}from\"m\"");
    }

    private void test(String source) {
        this.test(source, source);
    }

    public void test(String expected, String source) {
        String result = TrivialJsCodeGenerator.generate((ASTNode)this.parse(source));
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private JavaScriptUnit parse(String content) {
        return EsprimaParser.newParser().setSource(content).parse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readResource(String resource) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(resource);
            try {
                String string;
                block14: {
                    Scanner s = new Scanner(inputStream, "UTF-8");
                    try {
                        s.useDelimiter("\\A");
                        string = s.next();
                        return string;
                    }
                    finally {
                        if (s == null) break block14;
                        s.close();
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

