/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlAttributeMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlAttributeMappingTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    private ICompilationUnit createTypeWithXmlAttribute() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAttribute"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute");
            }
        });
    }

    private ICompilationUnit createTypeWithXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPath");
            }
        });
    }

    public void testModifyXmlPath() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAttributeMapping mapping = (ELJavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAttributeMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlPath());
        mapping.addXmlPath();
        ELJavaXmlAttributeMappingTests.assertEquals((int)1, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)mapping.getXmlPath());
        mapping.removeXmlPath();
        ELJavaXmlAttributeMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlPath());
    }

    public void testUpdateXmlPath() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAttributeMapping mapping = (ELJavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAttributeMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlPath());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlAttributeMappingTests.assertEquals((int)1, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)mapping.getXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlAttributeMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath")));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlPath());
    }

    public void testDefault() throws Exception {
        this.createTypeWithXmlPath();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        JavaResourceAttribute resourceAttribute = persistentAttribute.getJavaResourceAttribute();
        XmlPathAnnotation xmlPathAnnotation = (XmlPathAnnotation)resourceAttribute.getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)xmlPathAnnotation);
        ELJavaXmlAttributeMappingTests.assertFalse((persistentAttribute.getMapping().getKey() == "xml-attribute" ? 1 : 0) != 0);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "./element[@name=\"foo\"]/element[1]/text()");
            }
        });
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlAttributeMappingTests.assertFalse((persistentAttribute.getMapping().getKey() == "xml-attribute" ? 1 : 0) != 0);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath", "element/@attribute");
            }
        });
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlAttributeMappingTests.assertTrue((persistentAttribute.getMapping().getKey() == "xml-attribute" ? 1 : 0) != 0);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlPath");
            }
        });
        ELJavaXmlAttributeMappingTests.assertNull((Object)xmlPathAnnotation.getValue());
        ELJavaXmlAttributeMappingTests.assertFalse((persistentAttribute.getMapping().getKey() == "xml-attribute" ? 1 : 0) != 0);
    }

    public void testModifyXmlKey() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAttributeMapping mapping = (ELJavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlKey());
        mapping.addXmlKey();
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)mapping.getXmlKey());
        mapping.removeXmlKey();
        ELJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlKey());
    }

    public void testUpdateXmlKey() throws Exception {
        this.createTypeWithXmlAttribute();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlAttributeMapping mapping = (ELJavaXmlAttributeMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlKey());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlKey");
            }
        });
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNotNull((Object)mapping.getXmlKey());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlAttributeMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlKey");
            }
        });
        ELJavaXmlAttributeMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlKey"));
        ELJavaXmlAttributeMappingTests.assertNull((Object)mapping.getXmlKey());
    }
}

