/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmQueryHintTests
extends ContextModelTestCase {
    public OrmQueryHintTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmQueryHint ormQueryHint = ormEntity.getQueryContainer().addNamedQuery(0).addHint(0);
        XmlQueryHint queryHintResource = (XmlQueryHint)((XmlNamedQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedQueries().get(0)).getHints().get(0);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getName());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getName());
        queryHintResource.setName("newName");
        OrmQueryHintTests.assertEquals((String)"newName", (String)ormQueryHint.getName());
        OrmQueryHintTests.assertEquals((String)"newName", (String)queryHintResource.getName());
        queryHintResource.setName(null);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getName());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmQueryHint ormQueryHint = ormEntity.getQueryContainer().addNamedQuery(0).addHint(0);
        XmlQueryHint queryHintResource = (XmlQueryHint)((XmlNamedQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedQueries().get(0)).getHints().get(0);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getName());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getName());
        ormQueryHint.setName("newName");
        OrmQueryHintTests.assertEquals((String)"newName", (String)ormQueryHint.getName());
        OrmQueryHintTests.assertEquals((String)"newName", (String)queryHintResource.getName());
        ormQueryHint.setName(null);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getName());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getName());
    }

    public void testUpdateValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmQueryHint ormQueryHint = ormEntity.getQueryContainer().addNamedQuery(0).addHint(0);
        XmlQueryHint queryHintResource = (XmlQueryHint)((XmlNamedQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedQueries().get(0)).getHints().get(0);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getValue());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getValue());
        queryHintResource.setValue("newName");
        OrmQueryHintTests.assertEquals((String)"newName", (String)ormQueryHint.getValue());
        OrmQueryHintTests.assertEquals((String)"newName", (String)queryHintResource.getValue());
        queryHintResource.setValue(null);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getValue());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getValue());
    }

    public void testModifyValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmQueryHint ormQueryHint = ormEntity.getQueryContainer().addNamedQuery(0).addHint(0);
        XmlQueryHint queryHintResource = (XmlQueryHint)((XmlNamedQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedQueries().get(0)).getHints().get(0);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getValue());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getValue());
        ormQueryHint.setValue("newName");
        OrmQueryHintTests.assertEquals((String)"newName", (String)ormQueryHint.getValue());
        OrmQueryHintTests.assertEquals((String)"newName", (String)queryHintResource.getValue());
        ormQueryHint.setValue(null);
        OrmQueryHintTests.assertNull((Object)ormQueryHint.getValue());
        OrmQueryHintTests.assertNull((Object)queryHintResource.getValue());
    }
}

