/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public abstract class AbstractPairMatcherTest
extends junit.framework.TestCase {
    private static String DEFAULT_PARTITION = "__dftl_partition_content_type";

    protected abstract ICharacterPairMatcher createMatcher(String var1);

    protected abstract String getDocumentPartitioning();

    public AbstractPairMatcherTest(String name) {
        super(name);
    }

    public AbstractPairMatcherTest() {
    }

    public void testTestCaseReader() {
        this.performReaderTest("#( )%", 3, 0, "( )");
        this.performReaderTest("%( )#", 0, 3, "( )");
        this.performReaderTest("( )%", 3, -1, "( )");
        this.performReaderTest("#%", 0, 0, "");
    }

    public void testSimpleMatchSameMatcher() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "#(   )%");
        this.performMatch(matcher, "#[   ]%");
        this.performMatch(matcher, "#{   }%");
        this.performMatch(matcher, "(%   )#");
        this.performMatch(matcher, "[%   ]#");
        this.performMatch(matcher, "{%   }#");
        matcher.dispose();
    }

    public void testSimpleMatchDifferentMatchers() throws BadLocationException {
        this.performMatch("()[]{}", "#(   )%");
        this.performMatch("()[]{}", "#[   ]%");
        this.performMatch("()[]{}", "#{   }%");
        this.performMatch("()[]{}", "(%   )#");
        this.performMatch("()[]{}", "[%   ]#");
        this.performMatch("()[]{}", "{%   }#");
    }

    public void testCloseMatches() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "#()%");
        this.performMatch(matcher, "(%)#");
        this.performMatch(matcher, "#(())%");
        this.performMatch(matcher, "(%())#");
        this.performMatch(matcher, "((%)#)");
        this.performMatch(matcher, "(#()%)");
        matcher.dispose();
    }

    public void testIncompleteMatch() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(% ");
        this.performMatch(matcher, "%(  )");
        this.performMatch(matcher, "( % )");
        this.performMatch(matcher, "(  %)");
        this.performMatch(matcher, "%");
        matcher.dispose();
    }

    public void testPartitioned() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(% |a a| )#");
        this.performMatch(matcher, "#( |a a| )%");
        this.performMatch(matcher, "|b #( )% b|");
        this.performMatch(matcher, "( |b )% b|");
        this.performMatch(matcher, "(% |b ) b|");
        this.performMatch(matcher, "|a ( a| )%");
        this.performMatch(matcher, "|a (% a| )");
        this.performMatch(matcher, "|c #( c| ) ( |c )% c|");
        this.performMatch(matcher, "|c (% c| ) ( |c )# c|");
        this.performMatch(matcher, "(% |a ) a| |b ) b| |c ) c| )#");
        matcher.dispose();
    }

    public void testTightPartitioned() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, "(|b)%b|");
        this.performMatch(matcher, "(%|b)b|");
        this.performMatch(matcher, "|a(a|)%");
        this.performMatch(matcher, "|a(%a|)");
        this.performMatch(matcher, "|c#(c|)(|c)%c|");
        this.performMatch(matcher, "|c(%c|)(|c)#c|");
        this.performMatch(matcher, "(%|a)a||b)b||c)c|)#");
        matcher.dispose();
    }

    public void testNesting() {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        this.performMatch(matcher, " ( #( ( ( ) ) ( ) )% ) ");
        this.performMatch(matcher, " ( (% ( ( ) ) ( ) )# ) ");
        this.performMatch(matcher, " ( #( { ( ) } [ ] )% ) ");
        this.performMatch(matcher, " ( (% { ( ) } [ ] )# ) ");
        this.performMatch(matcher, " ( ( #{ ( ) }% [ ] ) ) ");
        this.performMatch(matcher, " ( ( {% ( ) }# [ ] ) ) ");
        this.performMatch(matcher, "a(b#(c(d(e)f)g(h)i)%j)k");
        this.performMatch(matcher, "a(b(%c(d(e)f)g(h)i)#j)k");
        this.performMatch(matcher, "a(b#(c{d(e)f}g[h]i)%j)k");
        this.performMatch(matcher, "a(b(%c{d(e)f}g[h]i)#j)k");
        this.performMatch(matcher, "a(b(c#{d(e)f}%g[h]i)j)k");
        this.performMatch(matcher, "a(b(c{%d(e)f}#g[h]i)j)k");
        matcher.dispose();
    }

    public void testBoundaries() throws BadLocationException {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}");
        StringDocument doc = new StringDocument("abcdefghijkl");
        AbstractPairMatcherTest.assertNull((Object)matcher.match(null, 0));
        AbstractPairMatcherTest.assertNull((Object)matcher.match((IDocument)doc, -1));
        AbstractPairMatcherTest.assertNull((Object)matcher.match((IDocument)doc, doc.getLength() + 1));
        matcher.dispose();
    }

    public void testBug156426() {
        ICharacterPairMatcher matcher = this.createMatcher("()[]{}<>");
        this.performMatch(matcher, " #( a < b )% ");
        this.performMatch(matcher, " (% a < b )# ");
        this.performMatch(matcher, " #( a > b )% ");
        this.performMatch(matcher, " (% a > b )# ");
        matcher.dispose();
    }

    private void performReaderTest(String testString, int expectedPos, int expectedMatch, String expectedString) {
        TestCase t0 = this.createTestCase(testString);
        AbstractPairMatcherTest.assertEquals((int)expectedPos, (int)t0.fPos);
        AbstractPairMatcherTest.assertEquals((int)expectedMatch, (int)t0.fMatch);
        AbstractPairMatcherTest.assertEquals((String)expectedString, (String)t0.fString);
    }

    protected void performMatch(ICharacterPairMatcher matcher, String testCase) {
        TestCase test = this.createTestCase(testCase);
        matcher.clear();
        IRegion region = matcher.match(test.getDocument(), test.fPos);
        if (test.fMatch == -1) {
            if (region != null) {
                System.out.println(region.getOffset());
            }
            AbstractPairMatcherTest.assertNull((Object)region);
        } else {
            AbstractPairMatcherTest.assertNotNull((Object)region);
            boolean isForward = test.fPos > test.fMatch;
            AbstractPairMatcherTest.assertEquals((boolean)isForward, (matcher.getAnchor() == 0 ? 1 : 0) != 0);
            int offset = isForward ? test.getOffset() : test.getOffset() - 1;
            int length = isForward ? test.getLength() : test.getLength() + 1;
            AbstractPairMatcherTest.assertEquals((int)length, (int)region.getLength());
            AbstractPairMatcherTest.assertEquals((int)offset, (int)region.getOffset());
        }
    }

    private void performMatch(String delims, String testCase) {
        ICharacterPairMatcher matcher = this.createMatcher(delims);
        this.performMatch(matcher, testCase);
        matcher.dispose();
    }

    public TestCase createTestCase(String str) {
        int pos = str.indexOf("%");
        AbstractPairMatcherTest.assertFalse((pos == -1 ? 1 : 0) != 0);
        int match = str.indexOf("#");
        if (match != -1 && match < pos) {
            --pos;
        }
        if (pos < match) {
            --match;
        }
        String stripped = str.replaceAll("%", "").replaceAll("#", "");
        return new TestCase(stripped, pos, match);
    }

    private static IDocumentPartitioner createPartitioner() {
        RuleBasedPartitionScanner scan = new RuleBasedPartitionScanner();
        ArrayList<SingleLineRule> rules = new ArrayList<SingleLineRule>();
        rules.add(new SingleLineRule("|a", "a|", (IToken)new Token((Object)"a")));
        rules.add(new SingleLineRule("|b", "b|", (IToken)new Token((Object)"b")));
        rules.add(new SingleLineRule("|c", "c|", (IToken)new Token((Object)"c")));
        scan.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
        scan.setDefaultReturnToken((IToken)new Token((Object)DEFAULT_PARTITION));
        return new FastPartitioner((IPartitionTokenScanner)scan, new String[]{DEFAULT_PARTITION, "a", "b", "c"});
    }

    private class StringDocument
    extends Document {
        public StringDocument(String str) {
            this.setTextStore(new StringTextStore(str));
            this.set(str);
            IDocumentPartitioner part = AbstractPairMatcherTest.createPartitioner();
            this.setDocumentPartitioner(AbstractPairMatcherTest.this.getDocumentPartitioning(), part);
            part.connect((IDocument)this);
        }
    }

    private static class StringTextStore
    implements ITextStore {
        private String fString;

        public StringTextStore(String str) {
            this.fString = str;
        }

        public char get(int offset) {
            return this.fString.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.fString.substring(offset, offset + length);
        }

        public int getLength() {
            return this.fString.length();
        }

        public void replace(int offset, int length, String text) {
            throw new UnsupportedOperationException();
        }

        public void set(String text) {
            this.fString = text;
        }
    }

    private class TestCase {
        public final String fString;
        public final int fPos;
        public final int fMatch;

        public TestCase(String string, int pos, int match) {
            this.fString = string;
            this.fPos = pos;
            this.fMatch = match;
        }

        public IDocument getDocument() {
            return new StringDocument(this.fString);
        }

        public int getLength() {
            return Math.abs(this.fPos - this.fMatch);
        }

        public int getOffset() {
            if (this.fPos > this.fMatch) {
                return this.fMatch;
            }
            return this.fPos;
        }
    }
}

