/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.text.StructuredAutoEditStrategy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class StructuredAutoEditStrategyJSP
extends StructuredAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.supportsSmartInsert(document)) {
            return;
        }
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null && command.text != null) {
                IDOMNode node;
                this.smartInsertForEndTag(command, document, model);
                this.smartRemoveEndTag(command, document, model);
                if (command.text.equals("%") && this.isPreferenceEnabled("typingCompleteScriptlets") && (node = (IDOMNode)model.getIndexedRegion(command.offset)) != null && this.prefixedWith(document, command.offset, "<") && !node.getSource().endsWith("%>")) {
                    command.text = String.valueOf(command.text) + " %>";
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 1;
                    command.doit = false;
                }
                if (command.text.equals("{") && this.isPreferenceEnabled("typingCompleteElBraces") && (node = (IDOMNode)model.getIndexedRegion(command.offset)) != null && (this.prefixedWith(document, command.offset, "$") || this.prefixedWith(document, command.offset, "#")) && !node.getSource().endsWith("}")) {
                    command.text = String.valueOf(command.text) + " }";
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 1;
                    command.doit = false;
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private boolean isPreferenceEnabled(String key) {
        return key != null && JSPUIPlugin.getDefault().getPreferenceStore().getBoolean(key);
    }

    private boolean prefixedWith(IDocument document, int offset, String string) {
        try {
            return document.getLength() >= string.length() && document.get(offset - string.length(), string.length()).equals(string);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
    }

    private boolean isCommentNode(IDOMNode node) {
        return node != null && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }

    private boolean isDocumentNode(IDOMNode node) {
        return node != null && node.getNodeType() == 9;
    }

    private void smartInsertForEndTag(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            if (command.text.equals("/") && document.getLength() >= 1 && document.get(command.offset - 1, 1).equals("<") && HTMLUIPlugin.getDefault().getPreferenceStore().getBoolean("completeEndTags")) {
                IDOMNode parentNode = (IDOMNode)((IDOMNode)model.getIndexedRegion(command.offset - 1)).getParentNode();
                if (this.isCommentNode(parentNode)) {
                    while (parentNode != null && this.isCommentNode(parentNode)) {
                        parentNode = (IDOMNode)parentNode.getParentNode();
                    }
                }
                if (!this.isDocumentNode(parentNode)) {
                    StringBuffer toAdd;
                    IStructuredDocumentRegion endTagStructuredDocumentRegion = parentNode.getEndStructuredDocumentRegion();
                    IDOMNode ancestor = parentNode;
                    boolean smartInsertForEnd = false;
                    if (endTagStructuredDocumentRegion != null) {
                        while ((ancestor = (IDOMNode)ancestor.getParentNode()) != null) {
                            if (ancestor.getEndStructuredDocumentRegion() != null || !parentNode.getNodeName().equals(ancestor.getNodeName())) continue;
                            smartInsertForEnd = true;
                            break;
                        }
                    }
                    if ((endTagStructuredDocumentRegion == null || smartInsertForEnd) && (toAdd = new StringBuffer(parentNode.getNodeName())).length() > 0) {
                        toAdd.append(">");
                        String suffix = toAdd.toString();
                        if (document.getLength() < command.offset + suffix.length() || !suffix.equals(document.get(command.offset, suffix.length()))) {
                            command.text = String.valueOf(command.text) + suffix;
                        }
                    }
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private void smartRemoveEndTag(DocumentCommand command, IDocument document, IStructuredModel model) {
        try {
            IStructuredDocumentRegion region;
            IDOMNode node;
            if ("/".equals(command.text) && ">".equals(document.get(command.offset, 1)) && command.length == 0 && HTMLUIPlugin.getDefault().getPreferenceStore().getBoolean("removeEndTags") && (node = (IDOMNode)model.getIndexedRegion(command.offset)) != null && !node.hasChildNodes() && (region = node.getFirstStructuredDocumentRegion()).getFirstRegion().getType() == "XML_TAG_OPEN" && command.offset <= region.getEnd()) {
                ITextRegion prevTextRegion = region.getRegionAtCharacterOffset(command.offset - 1);
                boolean inUnclosedAttValueRegion = false;
                if (prevTextRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    String prevText = region.getText(prevTextRegion);
                    boolean bl = inUnclosedAttValueRegion = prevText.startsWith("'") && (prevText.length() == 1 || !prevText.endsWith("'")) || prevText.startsWith("\"") && (prevText.length() == 1 || !prevText.endsWith("\""));
                    if (!inUnclosedAttValueRegion) {
                        boolean bl2 = inUnclosedAttValueRegion = prevTextRegion == region.getRegionAtCharacterOffset(command.offset);
                    }
                }
                if (!inUnclosedAttValueRegion && (region = node.getEndStructuredDocumentRegion()) != null && region.isEnded()) {
                    document.replace(region.getStartOffset(), region.getLength(), "");
                }
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }
}

