/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPModelProcessor;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;

public class TestStartupHandler
extends TestCase {
    private IFile _testJSP1;
    private WebProjectTestEnvironment _projectTestEnvironment;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this._projectTestEnvironment = new WebProjectTestEnvironment("TestStartupHandler_" + this.getName());
        this._projectTestEnvironment.createProject(false);
        JDTTestEnvironment jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)this._projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        IResource res = this._projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._testJSP1 = (IFile)res;
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(this._projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLaunchEditor() throws Exception {
        IWorkbenchPage curPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)curPage, (IFile)this._testJSP1);
        TestStartupHandler.assertNotNull((Object)editor);
        IEditorPart foundEditor = ResourceUtil.findEditor((IWorkbenchPage)curPage, (IFile)this._testJSP1);
        TestStartupHandler.assertEquals((Object)editor, (Object)foundEditor);
        JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
        TestStartupHandler.assertNotNull((Object)processor);
        TestStartupHandler.assertFalse((boolean)processor.isDisposed());
        curPage.closeEditor(foundEditor, false);
        TestStartupHandler.assertFalse((boolean)processor.isDisposed());
        JSPModelProcessor notDuplicate = JSPModelProcessor.get((IFile)this._testJSP1);
        TestStartupHandler.assertEquals((Object)processor, (Object)notDuplicate);
    }

    public void testBug196760() throws Exception {
        IWorkbenchPage curPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)curPage, (IFile)this._testJSP1);
        TestStartupHandler.assertNotNull((Object)editor);
        IEditorPart foundEditor = ResourceUtil.findEditor((IWorkbenchPage)curPage, (IFile)this._testJSP1);
        TestStartupHandler.assertEquals((Object)editor, (Object)foundEditor);
        JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
        TestStartupHandler.assertNotNull((Object)processor);
        TestStartupHandler.assertFalse((boolean)processor.isDisposed());
        CloseResourceAction action = new CloseResourceAction((IShellProvider)PlatformUI.getWorkbench().getActiveWorkbenchWindow()){

            public void superRun() {
                super.run();
                int numTries = 0;
                while (TestStartupHandler.this._projectTestEnvironment.getTestProject().isOpen()) {
                    try {
                        ++numTries;
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (numTries <= 20) continue;
                    throw new RuntimeException("Number of tries exceeded 20");
                }
            }

            public void run() {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        this.superRun();
                    }
                });
            }
        };
        action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this._projectTestEnvironment.getTestProject()));
        action.run();
        TestStartupHandler.assertFalse((boolean)this._projectTestEnvironment.getTestProject().isOpen());
        TestStartupHandler.assertTrue((boolean)processor.isDisposed());
    }
}

