/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.query.internal.taglib;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.query.internal.IPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainEntityPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.TaglibDomainEntityQuerySpec;

public class TaglibDomainEntityIdRegexPredicateMatcher
implements ITaglibDomainEntityPredicateMatcher {
    private static final int LEVEL_UNSET = 0;
    private static final int LEVEL_MODEL = 1;
    private static final int LEVEL_TAG = 2;
    private static final int LEVEL_TAGATTR = 3;
    private final Pattern _modelKey;
    private final Pattern _tagKey;
    private final Pattern _tagAttrKey;
    private final int _leafLevel;
    private int _currentLevel;

    public TaglibDomainEntityIdRegexPredicateMatcher(TaglibDomainEntityQuerySpec spec) throws PatternSyntaxException {
        this._modelKey = spec.getKey().getUri() != null ? Pattern.compile(spec.getKey().getUri()) : null;
        this._tagKey = spec.getKey().getTagName() != null ? Pattern.compile(spec.getKey().getTagName()) : null;
        Pattern pattern = this._tagAttrKey = spec.getKey().getTagAttributeName() != null ? Pattern.compile(spec.getKey().getTagAttributeName()) : null;
        this._leafLevel = this._tagAttrKey != null ? 3 : (this._tagKey != null ? 2 : 1);
        this._currentLevel = 0;
    }

    public IPredicateMatcher.MATCH matches(Entity entity) {
        if (this._currentLevel == 1 && this.matches(entity, this._modelKey)) {
            return this.isFullMatch(entity);
        }
        if (this._currentLevel == 2 && this.matches(entity, this._tagKey)) {
            return this.isFullMatch(entity);
        }
        if (this._currentLevel == 3 && this.matches(entity, this._tagAttrKey)) {
            return this.isFullMatch(entity);
        }
        return IPredicateMatcher.MATCH.NOT;
    }

    private boolean matches(Entity entity, Pattern _key) {
        return _key.matcher(entity.getId()).find();
    }

    private IPredicateMatcher.MATCH isFullMatch(Entity entity) {
        if (this._currentLevel == this._leafLevel) {
            return IPredicateMatcher.MATCH.FULLY;
        }
        return IPredicateMatcher.MATCH.PARTIALLY;
    }

    public void popLevel() {
        --this._currentLevel;
    }

    public void pushLevel() {
        ++this._currentLevel;
    }

    public String getUri() {
        return this._modelKey.pattern().toString();
    }

    public void reset() {
        this._currentLevel = 0;
    }

    public int getMaxLevel() {
        return this._leafLevel;
    }

    public int getCurrentLevel() {
        return this._currentLevel;
    }
}

