/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadManagedBeanManagedPropertyTestCase
extends BaseReadTestCase {
    public ReadManagedBeanManagedPropertyTestCase(String name) {
        super(name);
    }

    public void testSingleManagedProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)this.getManagedProperty("managedBean1Property1", edit.getFacesConfig()));
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)this.getManagedProperty("managedBean1Property2", edit.getFacesConfig()));
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)this.getManagedProperty("managedBeanMapProperty", edit.getFacesConfig()));
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)this.getManagedProperty("managedBeanListProperty", edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ManagedPropertyType getManagedProperty(String property, FacesConfigType facesConfig) {
        ManagedBeanType bean = (ManagedBeanType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getManagedBean(), "managedBean1");
        ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)bean);
        return (ManagedPropertyType)FacesConfigModelUtil.findEObjectElementById((List)bean.getManagedProperty(), property);
    }

    public void testManagedBeanDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedPropertyType property = this.getManagedProperty("managedBean1Property1", edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)property.getDescription(), "managedBean1Property1_description");
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)descType);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"managed-property-description", (String)descType.getTextContent());
            DisplayNameType displayName = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)property.getDisplayName(), "managedBean1Property1_displayName");
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)displayName);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"managed-property-display-name", (String)displayName.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)property.getIcon(), "managedBean1Property1_icon");
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)iconType);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"managedBean1-property-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"managedBean1-property-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testValueManagedProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedPropertyType property = this.getManagedProperty("managedBean1Property1", edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"bean-property-name", (String)property.getPropertyName().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"bean-property-class", (String)property.getPropertyClass().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"bean-propertyValue1", (String)property.getValue().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getNullValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getMapEntries());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getListEntries());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testNullValueManagedProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedPropertyType property = this.getManagedProperty("managedBean1Property2", edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"bean-property2-name", (String)property.getPropertyName().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"bean-property2-class", (String)property.getPropertyClass().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property.getNullValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getMapEntries());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getListEntries());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testMapValueManagedProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedPropertyType property = this.getManagedProperty("managedBeanMapProperty", edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"map-bean-name", (String)property.getPropertyName().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"map-bean-class", (String)property.getPropertyClass().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property.getMapEntries());
            MapEntriesType mapEntries = property.getMapEntries();
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"propertyMapEntryKey", (String)mapEntries.getKeyClass().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"propertyMapEntryValueClass", (String)mapEntries.getValueClass().getTextContent());
            MapEntryType mapEntry = (MapEntryType)FacesConfigModelUtil.findEObjectElementById((List)mapEntries.getMapEntry(), "mapPropertyEntryWithValue");
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)mapEntry);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"propertyMapKey1", (String)mapEntry.getKey().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"propertyMapValue1", (String)mapEntry.getValue().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)mapEntry.getNullValue());
            mapEntry = (MapEntryType)FacesConfigModelUtil.findEObjectElementById((List)mapEntries.getMapEntry(), "mapPropertyEntryWithNullValue");
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)mapEntry);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"propertyMapKey2", (String)mapEntry.getKey().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)mapEntry.getNullValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)mapEntry.getValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getNullValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getListEntries());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testListValueManagedProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)edit.getFacesConfig());
            ManagedPropertyType property = this.getManagedProperty("managedBeanListProperty", edit.getFacesConfig());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"list-bean-name", (String)property.getPropertyName().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"list-bean-class", (String)property.getPropertyClass().getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNotNull((Object)property.getListEntries());
            ListEntriesType listEntries = property.getListEntries();
            ReadManagedBeanManagedPropertyTestCase.assertEquals((int)1, (int)listEntries.getValue().size());
            ReadManagedBeanManagedPropertyTestCase.assertEquals((int)1, (int)listEntries.getNullValue().size());
            ValueType valueType = (ValueType)listEntries.getValue().get(0);
            ReadManagedBeanManagedPropertyTestCase.assertEquals((String)"managedBeanListPropertyValue", (String)valueType.getTextContent());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getNullValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getValue());
            ReadManagedBeanManagedPropertyTestCase.assertNull((Object)property.getMapEntries());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

