/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.tests.CommonTestsPlugin;

public class ModuleCoreNatureAPITest
extends TestCase {
    public static String fileSep = System.getProperty("file.separator");
    public static final String PROJECT_NAME = "TestArtifactEdit";
    public static final String WEB_MODULE_NAME = "WebModule1";
    public static final URI moduleURI = URI.createURI((String)"module:/resource/TestArtifactEdit/WebModule1");
    public static final String EDIT_MODEL_ID = "jst.web";
    private Path zipFilePath = new Path("TestData" + fileSep + "TestArtifactEdit.zip");
    private IProject project;

    protected void setUp() throws Exception {
        if (!this.getTargetProject().exists() && !this.createProject()) {
            ModuleCoreNatureAPITest.fail();
        }
        this.project = this.getTargetProject();
    }

    public IProject getTargetProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }

    public boolean createProject() {
        IPath localZipPath = this.getLocalPath();
        ProjectUnzipUtil util = new ProjectUnzipUtil(localZipPath, new String[]{PROJECT_NAME});
        return util.createProjects();
    }

    private IPath getLocalPath() {
        URL url = CommonTestsPlugin.instance.find((IPath)this.zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }

    public void testConfigure() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        try {
            nature.configure();
        }
        catch (CoreException e) {
            e.printStackTrace();
            ModuleCoreNatureAPITest.fail();
        }
    }

    public void testGetModuleCoreNature() {
        new ModuleCoreNature();
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        ModuleCoreNatureAPITest.assertNotNull((Object)nature);
    }

    public void testGetModuleStructuralModelForRead() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        nature.getModuleStructuralModelForRead((Object)this);
        ArtifactEditModel model = nature.getArtifactEditModelForRead(moduleURI, (Object)this);
        ModuleCoreNatureAPITest.assertNotNull((Object)model);
    }

    public void testGetModuleStructuralModelForWrite() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        ArtifactEditModel model = nature.getArtifactEditModelForWrite(moduleURI, (Object)this);
        ModuleCoreNatureAPITest.assertNotNull((Object)model);
    }

    public void testGetArtifactEditModelForRead() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        EditModel model = nature.getEditModelForRead(EDIT_MODEL_ID, (Object)this);
        ModuleCoreNatureAPITest.assertNotNull((Object)model);
    }

    public void testGetArtifactEditModelForWrite() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        EditModel model = nature.getEditModelForWrite(EDIT_MODEL_ID, (Object)this);
        ModuleCoreNatureAPITest.assertNotNull((Object)model);
    }

    public void testGetNatureID() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        String id = nature.getNatureID();
        ModuleCoreNatureAPITest.assertTrue((boolean)id.equals("org.eclipse.wst.common.modulecore.ModuleCoreNature"));
    }

    public void testPrimaryContributeToContext() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        EMFWorkbenchContextBase context = new EMFWorkbenchContextBase(this.project);
        try {
            nature.primaryContributeToContext(context);
        }
        catch (Exception exception) {
            ModuleCoreNatureAPITest.fail();
        }
    }

    public void testGetResourceSet() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        ResourceSet set = nature.getResourceSet();
        ModuleCoreNatureAPITest.assertNotNull((Object)set);
    }

    public void testSecondaryContributeToContext() {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        EMFWorkbenchContextBase context = new EMFWorkbenchContextBase(this.project);
        try {
            nature.secondaryContributeToContext(context);
        }
        catch (Exception exception) {
            ModuleCoreNatureAPITest.fail();
        }
    }

    public void testGetPluginID() {
        ModuleCoreNature.getModuleCoreNature((IProject)this.project);
    }

    public void testAddModuleCoreNatureIfNecessary() {
        try {
            this.project.getDescription().setNatureIds(new String[0]);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)this.project, (IProgressMonitor)new NullProgressMonitor());
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature((IProject)this.project);
        ModuleCoreNatureAPITest.assertNotNull((Object)nature);
    }

    public void testUnresolveableURIException() {
        UnresolveableURIException uriEx = new UnresolveableURIException(moduleURI);
        ModuleCoreNatureAPITest.assertNotNull((Object)((Object)uriEx));
    }
}

