/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.datamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class FacetProjectCreationDataModelProvider
extends AbstractDataModelProvider
implements IFacetProjectCreationDataModelProperties {
    public static final String REQUIRED_FACETS_COLLECTION = "FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION";
    public static final String FORCE_VERSION_COMPLIANCE = "FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE";

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IFacetDataModelProperties.FACET_PROJECT_NAME");
        names.add("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        names.add("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        names.add(REQUIRED_FACETS_COLLECTION);
        names.add(FORCE_VERSION_COMPLIANCE);
        return names;
    }

    public void init() {
        super.init();
        IDataModel projectDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ProjectCreationDataModelProviderNew());
        projectDataModel.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IProjectCreationPropertiesNew.PROJECT_NAME".equals(event.getPropertyName())) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", event.getProperty());
                }
            }
        });
        this.model.addNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM", projectDataModel);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            Iterator iterator = ((Map)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).values().iterator();
            while (iterator.hasNext()) {
                ((IDataModel)iterator.next()).setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
            }
            IDataModel projModel = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
            projModel.setProperty("IProjectCreationPropertiesNew.PROJECT_NAME", propertyValue);
        } else if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)propertyValue;
            Iterator iterator = ((Map)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP")).values().iterator();
            while (iterator.hasNext()) {
                IDataModel dm = (IDataModel)iterator.next();
                if (!dm.isProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) continue;
                dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            }
            if (runtime != null && this.getBooleanProperty(FORCE_VERSION_COMPLIANCE)) {
                Map facetDMs = (Map)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
                Iterator iterator2 = facetDMs.values().iterator();
                while (iterator2.hasNext()) {
                    IDataModel facetDataModel = (IDataModel)iterator2.next();
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)((String)facetDataModel.getProperty("IFacetDataModelProperties.FACET_ID")));
                    try {
                        IDataModel facetModel = ((IFacetProjectCreationDataModelProperties.FacetDataModelMap)facetDMs).getFacetDataModel(facet.getId());
                        IProjectFacetVersion oldVersion = (IProjectFacetVersion)facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                        IProjectFacetVersion newVersion = facet.getLatestSupportedVersion(runtime);
                        if (newVersion == null || oldVersion != null && oldVersion.getVersionString().compareTo(newVersion.getVersionString()) <= 0 && runtime.supports(oldVersion)) continue;
                        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)newVersion);
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_DM_MAP".equals(propertyName)) {
            FacetDataModelMapImpl obj = new FacetDataModelMapImpl();
            this.setProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", obj);
            return obj;
        }
        if ("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP".equals(propertyName)) {
            FacetActionMapImpl obj = new FacetActionMapImpl();
            this.setProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", obj);
            return obj;
        }
        if (REQUIRED_FACETS_COLLECTION.equals(propertyName)) {
            ArrayList c = new ArrayList();
            this.setProperty(REQUIRED_FACETS_COLLECTION, c);
            return c;
        }
        if (FORCE_VERSION_COMPLIANCE.equals(propertyName)) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IRuntime runtime = (IRuntime)this.getProperty(propertyName);
            if (runtime != null) {
                return new DataModelPropertyDescriptor((Object)runtime, runtime.getName());
            }
            return new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            Collection projectFacets = (Collection)this.getProperty(REQUIRED_FACETS_COLLECTION);
            Set runtimes = RuntimeManager.getRuntimes();
            ArrayList<IRuntime> list = new ArrayList<IRuntime>();
            Iterator it = runtimes.iterator();
            while (it.hasNext()) {
                IRuntime rt = (IRuntime)it.next();
                boolean supportsFactet = true;
                Iterator facetIt = projectFacets.iterator();
                while (facetIt.hasNext()) {
                    IProjectFacet facet = (IProjectFacet)facetIt.next();
                    if (rt.supports(facet)) continue;
                    supportsFactet = false;
                    break;
                }
                if (!supportsFactet) continue;
                list.add(rt);
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
            Iterator iterator = list.iterator();
            int i = 0;
            while (i < descriptors.length - 1) {
                IRuntime runtime = (IRuntime)iterator.next();
                descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getName());
                ++i;
            }
            if (descriptors.length > 2) {
                Arrays.sort(descriptors, 0, descriptors.length - 2, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            descriptors[descriptors.length - 1] = new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            IDataModel projModel = this.model.getNestedModel("IFacetProjectCreationDataModelProperties.NESTED_PROJECT_DM");
            return projModel.validateProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
        }
        return super.validate(propertyName);
    }

    public IDataModelOperation getDefaultOperation() {
        return new FacetProjectCreationOperation(this.model);
    }

    protected class FacetActionMapImpl
    extends HashMap
    implements IFacetProjectCreationDataModelProperties.FacetActionMap {
        private static final long serialVersionUID = 1L;
        private boolean supressNotification = false;

        protected FacetActionMapImpl() {
        }

        public void add(IFacetedProject.Action action) {
            this.put(action.getProjectFacetVersion().getProjectFacet().getId(), action);
        }

        public IFacetedProject.Action getAction(String facetID) {
            return (IFacetedProject.Action)this.get(facetID);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            try {
                this.supressNotification = true;
                super.clear();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.supressNotification = false;
            }
            FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
        }

        public Object remove(Object key) {
            Object v;
            block2: {
                try {
                    v = super.remove(key);
                    Object var2_3 = null;
                    if (this.supressNotification) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var2_4 = null;
                        if (this.supressNotification) break block3;
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                    }
                    throw throwable;
                }
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
            }
            return v;
        }

        public Object put(Object key, Object value) {
            Object object;
            block2: {
                try {
                    object = super.put(key, value);
                    Object var3_4 = null;
                    if (this.supressNotification) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var3_5 = null;
                        if (this.supressNotification) break block3;
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                    }
                    throw throwable;
                }
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
            }
            return object;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void putAll(Map m) {
            try {
                this.supressNotification = true;
                super.putAll(m);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.supressNotification = false;
            }
            FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP", 1);
        }
    }

    protected class FacetDataModelMapImpl
    extends HashMap
    implements IFacetProjectCreationDataModelProperties.FacetDataModelMap,
    IDataModelListener {
        private static final long serialVersionUID = 1L;
        private boolean supressNotification = false;

        protected FacetDataModelMapImpl() {
        }

        public void add(IDataModel facetDataModel) {
            this.put(facetDataModel.getProperty("IFacetDataModelProperties.FACET_ID"), facetDataModel);
        }

        public IDataModel getFacetDataModel(String facetID) {
            return (IDataModel)this.get(facetID);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            try {
                this.supressNotification = true;
                Iterator iterator = this.values().iterator();
                while (true) {
                    block4: {
                        if (iterator.hasNext()) break block4;
                        super.clear();
                        break;
                    }
                    ((IDataModel)iterator.next()).removeListener((IDataModelListener)this);
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.supressNotification = false;
            }
            FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
        }

        public Object put(Object key, Object value) {
            Object object;
            block3: {
                try {
                    IDataModel dm = (IDataModel)value;
                    Object lastValue = super.put(key, value);
                    if (lastValue != null) {
                        ((IDataModel)lastValue).removeListener((IDataModelListener)this);
                        ((IDataModel)lastValue).setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", null);
                    }
                    dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", FacetProjectCreationDataModelProvider.this.getDataModel().getProperty("IFacetDataModelProperties.FACET_PROJECT_NAME"));
                    dm.setProperty("FacetInstallDataModelProvider.MASTER_PROJECT_DM", (Object)FacetProjectCreationDataModelProvider.this.model);
                    dm.addListener((IDataModelListener)this);
                    object = lastValue;
                    Object var5_6 = null;
                    if (this.supressNotification) break block3;
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var5_7 = null;
                        if (this.supressNotification) break block4;
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                    }
                    throw throwable;
                }
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
            }
            return object;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void putAll(Map m) {
            try {
                this.supressNotification = true;
                super.putAll(m);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.supressNotification = false;
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.supressNotification = false;
            }
            FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
        }

        public Object remove(Object key) {
            IDataModel iDataModel;
            block2: {
                try {
                    IDataModel dm = (IDataModel)super.remove(key);
                    dm.removeListener((IDataModelListener)this);
                    iDataModel = dm;
                    Object var3_4 = null;
                    if (this.supressNotification) break block2;
                }
                catch (Throwable throwable) {
                    block3: {
                        Object var3_5 = null;
                        if (this.supressNotification) break block3;
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
                    }
                    throw throwable;
                }
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_DM_MAP", 1);
            }
            return iDataModel;
        }

        public void propertyChanged(DataModelEvent event) {
            if (event.getPropertyName().equals("IFacetDataModelProperties.FACET_PROJECT_NAME")) {
                if (this.containsValue(event.getDataModel())) {
                    FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", event.getProperty());
                } else {
                    event.getDataModel().removeListener((IDataModelListener)this);
                }
            } else if (event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
                if (this.containsValue(event.getDataModel())) {
                    if (event.getFlag() == 4) {
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
                    } else if (event.getFlag() == 3) {
                        FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 3);
                    } else {
                        FacetProjectCreationDataModelProvider.this.getDataModel().setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", event.getProperty());
                    }
                } else {
                    event.getDataModel().removeListener((IDataModelListener)this);
                }
            } else if (event.getPropertyName().equals("IFacetDataModelPropeties.FACET_VERSION")) {
                FacetProjectCreationDataModelProvider.this.getDataModel().notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
            }
        }
    }
}

