/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class ImageOverlayDescriptor
extends CompositeImageDescriptor {
    protected Image baseImage;
    protected Image extensionOverlay;
    protected Image disabledExtensionOverlay;
    protected Point imageSize;
    protected boolean isReadOnly;

    public ImageOverlayDescriptor(Image baseImage, boolean isReadOnly) {
        this.baseImage = baseImage;
        this.isReadOnly = isReadOnly;
        this.imageSize = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
        this.extensionOverlay = XSDEditorPlugin.getPlugin().getIcon("ovr16/extnsn_ovr.gif");
        this.disabledExtensionOverlay = XSDEditorPlugin.getPlugin().getIcon("ovr16/extnsndis_ovr.gif");
    }

    public Image getImage() {
        return this.createImage();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        ImageData extensionImageData = this.isReadOnly ? this.disabledExtensionOverlay.getImageData() : this.extensionOverlay.getImageData();
        this.drawImage(extensionImageData, this.imageSize.x - extensionImageData.width, 0);
    }

    protected Point getSize() {
        return this.imageSize;
    }
}

