/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.internal.core.connection.IConnectionValidator;

public final class ConnectionValidatorRegistry {
    private static ConnectionValidatorRegistry instance = new ConnectionValidatorRegistry();
    private Hashtable connectionValidatorTable = null;

    private ConnectionValidatorRegistry() {
        this.initializeDriverCollection();
    }

    public static ConnectionValidatorRegistry getInstance() {
        return instance;
    }

    public Enumeration getConnectionValidators() {
        return this.connectionValidatorTable.elements();
    }

    private void initializeDriverCollection() {
        this.connectionValidatorTable = new Hashtable();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core", "connectionValidator");
        IExtension[] extensions = extensionPoint.getExtensions();
        int extensionIndex = 0;
        while (extensionIndex < extensions.length) {
            IConfigurationElement[] configElements = extensions[extensionIndex].getConfigurationElements();
            int elementIndex = 0;
            while (elementIndex < configElements.length) {
                if (configElements[elementIndex].getName().equals("connectionValidator")) {
                    IConfigurationElement configElement = configElements[elementIndex];
                    String id = configElement.getAttribute("id");
                    IConnectionValidator connectionValidator = null;
                    try {
                        connectionValidator = (IConnectionValidator)configElement.createExecutableExtension("class");
                    }
                    catch (Exception exception) {}
                    if (connectionValidator != null) {
                        this.connectionValidatorTable.put(id, connectionValidator);
                    }
                }
                ++elementIndex;
            }
            ++extensionIndex;
        }
    }
}

