/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Client;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.IServerMonitor;
import org.eclipse.wst.server.core.internal.InstallableRuntime;
import org.eclipse.wst.server.core.internal.InstallableServer;
import org.eclipse.wst.server.core.internal.LaunchableAdapter;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleArtifactAdapter;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.PublishTask;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeLocator;
import org.eclipse.wst.server.core.internal.ServerMonitor;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class ServerPlugin
extends Plugin {
    public static final String PROJECT_PREF_FILE = ".serverPreference";
    private static final String SHUTDOWN_JOB_FAMILY = "org.eclipse.wst.server.core.family";
    protected static final DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    protected static int num = 0;
    private static List launchableAdapters;
    private static List clients;
    private static List moduleFactories;
    private static ServerPlugin singleton;
    private static List publishTasks;
    private static List monitors;
    private static List runtimeLocators;
    private static List moduleArtifactAdapters;
    private static List installableServers;
    private static List installableRuntimes;
    private static IRegistryChangeListener registryListener;
    public static BundleContext bundleContext;
    private BundleListener bundleListener;
    private static final String TEMP_DATA_FILE = "tmp-data.xml";
    protected Map tempDirHash;
    public static final String PLUGIN_ID = "org.eclipse.wst.server.core";

    public ServerPlugin() {
        singleton = this;
    }

    public static ServerPlugin getInstance() {
        return singleton;
    }

    public IPath getTempDirectory(String key) {
        if (key == null) {
            return null;
        }
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        try {
            TempDir dir = (TempDir)this.tempDirHash.get(key);
            if (dir != null) {
                dir.age = 0;
                return statePath.append(dir.path);
            }
        }
        catch (Exception exception) {}
        String path = null;
        File dir = null;
        int count = 0;
        while (dir == null || dir.exists()) {
            path = "tmp" + count;
            dir = statePath.append(path).toFile();
            ++count;
        }
        dir.mkdirs();
        TempDir d = new TempDir();
        d.path = path;
        this.tempDirHash.put(key, d);
        this.saveTempDirInfo();
        return statePath.append(path);
    }

    public void removeTempDirectory(String key) {
        if (key == null) {
            return;
        }
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        try {
            TempDir dir = (TempDir)this.tempDirHash.get(key);
            if (dir != null) {
                this.tempDirHash.remove(key);
                this.saveTempDirInfo();
                ServerPlugin.deleteDirectory(statePath.append(dir.path).toFile(), null);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not remove temp directory", e);
        }
    }

    private void loadTempDirInfo() {
        Trace.trace(Trace.FINEST, "Loading temporary directory information");
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        String filename = statePath.append(TEMP_DATA_FILE).toOSString();
        this.tempDirHash = new HashMap();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("temp-directory");
            int size = children.length;
            int i = 0;
            while (i < size) {
                String key = children[i].getString("key");
                TempDir d = new TempDir();
                d.path = children[i].getString("path");
                d.age = children[i].getInteger("age");
                ++d.age;
                this.tempDirHash.put(key, d);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load temporary directory information: " + e.getMessage());
        }
    }

    public static void log(IStatus status) {
        ServerPlugin.getInstance().getLog().log(status);
    }

    private void saveTempDirInfo() {
        IPath statePath = ServerPlugin.getInstance().getStateLocation();
        String filename = statePath.append(TEMP_DATA_FILE).toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("temp-directories");
            Iterator iterator = this.tempDirHash.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                TempDir d = (TempDir)this.tempDirHash.get(key);
                if (d.age < 5) {
                    IMemento child = memento.createChild("temp-directory");
                    child.putString("key", key);
                    child.putString("path", d.path);
                    child.putInteger("age", d.age);
                    continue;
                }
                ServerPlugin.deleteDirectory(statePath.append(d.path).toFile(), null);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save temporary directory information", e);
        }
    }

    protected void initializeDefaultPluginPreferences() {
        ServerPreferences.getInstance().setDefaults();
    }

    public void start(BundleContext context) throws Exception {
        Trace.trace(Trace.CONFIG, "----->----- Server Core plugin startup ----->-----");
        super.start(context);
        bundleContext = context;
        this.initializeDefaultPluginPreferences();
        this.loadTempDirInfo();
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                String bundleId = event.getBundle().getSymbolicName();
                if (4 == event.getType() && ResourceManager.getInstance().isActiveBundle(bundleId)) {
                    ServerPlugin.this.stopBundle(bundleId);
                }
            }
        };
        context.addBundleListener(this.bundleListener);
    }

    protected void stopBundle(String bundleId) {
        class StopJob
        extends Job {
            final /* synthetic */ ServerPlugin this$0;
            private final /* synthetic */ String val$bundleId;

            public StopJob(ServerPlugin serverPlugin, String string) {
                super("Disposing servers");
                this.this$0 = serverPlugin;
                this.val$bundleId = string;
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core.family".equals(family);
            }

            public IStatus run(IProgressMonitor monitor2) {
                ResourceManager.getInstance().shutdownBundle(this.val$bundleId);
                return Status.OK_STATUS;
            }
        }
        StopJob job = new StopJob(this, bundleId);
        job.setUser(false);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        Trace.trace(Trace.CONFIG, "-----<----- Server Core plugin shutdown -----<-----");
        super.stop(context);
        if (registryListener != null) {
            Platform.getExtensionRegistry().removeRegistryChangeListener(registryListener);
        }
        ResourceManager.shutdown();
        ServerMonitorManager.shutdown();
        try {
            Platform.getJobManager().join((Object)SHUTDOWN_JOB_FAMILY, null);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error waiting for shutdown job", e);
        }
        context.removeBundleListener(this.bundleListener);
    }

    public static String[] tokenize(String param, String delim) {
        if (param == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(param, delim);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str == null || str.length() <= 0) continue;
            list.add(str.trim());
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    protected static List getModuleTypes(IConfigurationElement[] elements) {
        ArrayList<ModuleType> list = new ArrayList<ModuleType>();
        if (elements == null) {
            return list;
        }
        int size = elements.length;
        int i = 0;
        while (i < size) {
            String[] types = ServerPlugin.tokenize(elements[i].getAttribute("types"), ",");
            String[] versions = ServerPlugin.tokenize(elements[i].getAttribute("versions"), ",");
            int sizeT = types.length;
            int sizeV = versions.length;
            int j = 0;
            while (j < sizeT) {
                int k = 0;
                while (k < sizeV) {
                    ModuleType module = new ModuleType(types[j], versions[k]);
                    list.add(module);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static String generateId() {
        String s = String.valueOf(df.format(new Date()).toString()) + num++;
        s = s.replace(' ', '_');
        s = s.replace(':', '_');
        s = s.replace('/', '_');
        s = s.replace('\\', '_');
        return s;
    }

    public static boolean supportsType(String[] ids, String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (ids == null) {
            return true;
        }
        int size = ids.length;
        int i = 0;
        while (i < size) {
            if (ids[i].endsWith("*") ? id.length() >= ids[i].length() && id.startsWith(ids[i].substring(0, ids[i].length() - 1)) : id.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void deleteDirectory(File dir, IProgressMonitor monitor) {
        try {
            if (!dir.exists() || !dir.isDirectory()) {
                return;
            }
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    current.delete();
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    ServerPlugin.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                }
                ++i;
            }
            dir.delete();
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error deleting directory " + dir.getAbsolutePath(), e);
        }
    }

    public static ILaunchableAdapter[] getLaunchableAdapters() {
        if (launchableAdapters == null) {
            ServerPlugin.loadLaunchableAdapters();
        }
        ILaunchableAdapter[] la = new ILaunchableAdapter[launchableAdapters.size()];
        launchableAdapters.toArray(la);
        return la;
    }

    public static IClient[] getClients() {
        if (clients == null) {
            ServerPlugin.loadClients();
        }
        IClient[] c = new IClient[clients.size()];
        clients.toArray(c);
        return c;
    }

    private static synchronized void loadLaunchableAdapters() {
        if (launchableAdapters != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .launchableAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "launchableAdapters");
        int size = cf.length;
        ArrayList<LaunchableAdapter> list = new ArrayList<LaunchableAdapter>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new LaunchableAdapter(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded launchableAdapter: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load launchableAdapter: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        launchableAdapters = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .launchableAdapters extension point -<-");
    }

    private static synchronized void loadClients() {
        if (clients != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .clients extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "clients");
        int size = cf.length;
        ArrayList<Client> list = new ArrayList<Client>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new Client(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded clients: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load clients: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                Client a = (Client)list.get(i);
                Client b = (Client)list.get(j);
                if (a.getPriority() < b.getPriority()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        clients = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .clients extension point -<-");
    }

    public static IPublishTask[] getPublishTasks() {
        if (publishTasks == null) {
            ServerPlugin.loadPublishTasks();
        }
        IPublishTask[] st = new IPublishTask[publishTasks.size()];
        publishTasks.toArray(st);
        return st;
    }

    private static synchronized void loadPublishTasks() {
        if (publishTasks != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .publishTasks extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "publishTasks");
        int size = cf.length;
        ArrayList<PublishTask> list = new ArrayList<PublishTask>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new PublishTask(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded publishTask: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load publishTask: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        publishTasks = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .publishTasks extension point -<-");
    }

    public static ModuleFactory[] getModuleFactories() {
        if (moduleFactories == null) {
            ServerPlugin.loadModuleFactories();
        }
        ModuleFactory[] mf = new ModuleFactory[moduleFactories.size()];
        moduleFactories.toArray(mf);
        return mf;
    }

    public static ModuleFactory findModuleFactory(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (moduleFactories == null) {
            ServerPlugin.loadModuleFactories();
        }
        Iterator iterator = moduleFactories.iterator();
        while (iterator.hasNext()) {
            ModuleFactory factory = (ModuleFactory)iterator.next();
            if (!id.equals(factory.getId())) continue;
            return factory;
        }
        return null;
    }

    private static synchronized void loadModuleFactories() {
        if (moduleFactories != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .moduleFactories extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "moduleFactories");
        int size = cf.length;
        ArrayList<ModuleFactory> list = new ArrayList<ModuleFactory>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ModuleFactory(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded moduleFactories: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load moduleFactories: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                ModuleFactory a = (ModuleFactory)list.get(i);
                ModuleFactory b = (ModuleFactory)list.get(j);
                if (a.getOrder() > b.getOrder()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        moduleFactories = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .moduleFactories extension point -<-");
    }

    public static IServerMonitor[] getServerMonitors() {
        if (monitors == null) {
            ServerPlugin.loadServerMonitors();
        }
        IServerMonitor[] sm = new IServerMonitor[monitors.size()];
        monitors.toArray(sm);
        return sm;
    }

    private static synchronized void loadServerMonitors() {
        if (monitors != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .serverMonitors extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "internalServerMonitors");
        int size = cf.length;
        ArrayList<ServerMonitor> list = new ArrayList<ServerMonitor>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ServerMonitor(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded serverMonitor: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load serverMonitor: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        monitors = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .serverMonitors extension point -<-");
    }

    public static IRuntimeLocator[] getRuntimeLocators() {
        if (runtimeLocators == null) {
            ServerPlugin.loadRuntimeLocators();
        }
        IRuntimeLocator[] rl = new IRuntimeLocator[runtimeLocators.size()];
        runtimeLocators.toArray(rl);
        return rl;
    }

    private static synchronized void loadRuntimeLocators() {
        if (runtimeLocators != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .runtimeLocators extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "runtimeLocators");
        int size = cf.length;
        ArrayList<RuntimeLocator> list = new ArrayList<RuntimeLocator>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeLocator(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded runtimeLocator: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeLocator: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeLocators = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .runtimeLocators extension point -<-");
    }

    protected static ModuleArtifactAdapter[] getModuleArtifactAdapters() {
        if (moduleArtifactAdapters == null) {
            ServerPlugin.loadModuleArtifactAdapters();
        }
        ModuleArtifactAdapter[] moa = new ModuleArtifactAdapter[moduleArtifactAdapters.size()];
        moduleArtifactAdapters.toArray(moa);
        return moa;
    }

    private static synchronized void loadModuleArtifactAdapters() {
        if (moduleArtifactAdapters != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .moduleArtifactAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "moduleArtifactAdapters");
        int size = cf.length;
        ArrayList<ModuleArtifactAdapter> list = new ArrayList<ModuleArtifactAdapter>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new ModuleArtifactAdapter(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded moduleArtifactAdapter: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load moduleArtifactAdapter: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        size = list.size();
        i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                ModuleArtifactAdapter a = (ModuleArtifactAdapter)list.get(i);
                ModuleArtifactAdapter b = (ModuleArtifactAdapter)list.get(j);
                if (a.getPriority() < b.getPriority()) {
                    list.set(i, b);
                    list.set(j, a);
                }
                ++j;
            }
            ++i;
        }
        moduleArtifactAdapters = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .moduleArtifactAdapters extension point -<-");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasModuleArtifact(Object obj) {
        Trace.trace(Trace.FINEST, "ServerPlugin.hasModuleArtifact() " + obj);
        ModuleArtifactAdapter[] adapters = ServerPlugin.getModuleArtifactAdapters();
        if (adapters != null) {
            int size = adapters.length;
            int i = 0;
            while (i < size) {
                try {
                    if (adapters[i].isEnabled(obj)) {
                        Trace.trace(Trace.FINER, "ServerPlugin.hasModuleArtifact() - " + adapters[i].getId());
                        if (!adapters[i].isDelegateLoaded()) {
                            Trace.trace(Trace.FINER, "Enabled");
                            return true;
                        }
                        long time = System.currentTimeMillis();
                        IModuleArtifact ma = adapters[i].getModuleArtifact(obj);
                        Trace.trace(Trace.FINER, "Deep enabled time: " + (System.currentTimeMillis() - time));
                        if (ma != null) {
                            Trace.trace(Trace.FINER, "Deep enabled");
                            return true;
                        }
                        Trace.trace(Trace.FINER, "Not enabled");
                    }
                }
                catch (CoreException ce) {
                    Trace.trace(Trace.WARNING, "Could not use moduleArtifactAdapter", ce);
                }
                ++i;
            }
        }
        return false;
    }

    public static IModuleArtifact getModuleArtifact(Object obj) {
        Trace.trace(Trace.FINEST, "ServerPlugin.getModuleArtifact() " + obj);
        ModuleArtifactAdapter[] adapters = ServerPlugin.getModuleArtifactAdapters();
        if (adapters != null) {
            int size = adapters.length;
            int i = 0;
            while (i < size) {
                try {
                    IModuleArtifact ma;
                    if (adapters[i].isEnabled(obj) && (ma = adapters[i].getModuleArtifact(obj)) != null) {
                        return ma;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not use moduleArtifactAdapter " + adapters[i], e);
                }
                ++i;
            }
        }
        return null;
    }

    public static IModuleArtifact loadModuleArtifact(Object obj) {
        Trace.trace(Trace.FINEST, "ServerPlugin.loadModuleArtifact() " + obj);
        ModuleArtifactAdapter[] adapters = ServerPlugin.getModuleArtifactAdapters();
        if (adapters != null) {
            int size = adapters.length;
            int i = 0;
            while (i < size) {
                try {
                    IModuleArtifact ma;
                    if (adapters[i].isEnabled(obj) && (ma = adapters[i].getModuleArtifact(obj)) != null) {
                        return ma;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.WARNING, "Could not use moduleArtifactAdapter " + adapters[i], e);
                }
                ++i;
            }
        }
        return null;
    }

    public static IInstallableServer[] getInstallableServers() {
        if (installableServers == null) {
            ServerPlugin.loadInstallableServers();
        }
        ArrayList<IInstallableServer> availableServers = new ArrayList<IInstallableServer>();
        Iterator iterator = installableServers.iterator();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        int size = runtimeTypes.length;
        while (iterator.hasNext()) {
            IInstallableServer server = (IInstallableServer)iterator.next();
            boolean found = false;
            int i = 0;
            while (i < size) {
                if (server.getId().equals(runtimeTypes[i].getId())) {
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            availableServers.add(server);
        }
        IInstallableServer[] is = new IInstallableServer[availableServers.size()];
        availableServers.toArray(is);
        return is;
    }

    public static IInstallableRuntime[] getInstallableRuntimes() {
        ServerPlugin.loadInstallableRuntimes();
        IInstallableRuntime[] ir = new IInstallableRuntime[installableRuntimes.size()];
        installableRuntimes.toArray(ir);
        return ir;
    }

    public static IInstallableRuntime findInstallableRuntime(String runtimeTypeId) {
        if (runtimeTypeId == null) {
            throw new IllegalArgumentException();
        }
        ServerPlugin.loadInstallableRuntimes();
        Iterator iterator = installableRuntimes.iterator();
        IRuntimeType[] runtimeTypes = ServerCore.getRuntimeTypes();
        int size = runtimeTypes.length;
        while (iterator.hasNext()) {
            IInstallableRuntime runtime = (IInstallableRuntime)iterator.next();
            int i = 0;
            while (i < size) {
                if (runtime.getId().equals(runtimeTypeId)) {
                    return runtime;
                }
                ++i;
            }
        }
        return null;
    }

    private static synchronized void loadInstallableServers() {
        if (installableServers != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .installableServers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "installableServers");
        int size = cf.length;
        ArrayList<InstallableServer> list = new ArrayList<InstallableServer>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new InstallableServer(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded installableServer: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load installableServer: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        installableServers = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .installableServers extension point -<-");
    }

    private static synchronized void loadInstallableRuntimes() {
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .installableRuntimes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "installableRuntimes");
        int size = cf.length;
        ArrayList<InstallableRuntime> list = new ArrayList<InstallableRuntime>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new InstallableRuntime(cf[i]));
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded installableRuntime: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load installableRuntime: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        installableRuntimes = list;
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .installableRuntimes extension point -<-");
    }

    public static void setRegistryListener(IRegistryChangeListener listener) {
        registryListener = listener;
    }

    public static ProjectProperties getProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return new ProjectProperties(project);
    }

    class TempDir {
        String path;
        int age;

        TempDir() {
        }
    }
}

