/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class ValidationUtility {
    public static String[] listValidatorClasses(IResource resource, int severity) {
        IMarker[] markers = TaskListUtility.getValidationTasks(resource, severity);
        if (markers == null || markers.length == 0) {
            return new String[0];
        }
        HashSet<Object> tempSet = new HashSet<Object>();
        int i = 0;
        while (i < markers.length) {
            block6: {
                IMarker marker = markers[i];
                try {
                    Object owner = marker.getAttribute("owner");
                    if (owner != null && owner instanceof String) {
                        tempSet.add(owner);
                    }
                }
                catch (CoreException exc) {
                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                    if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                    LogEntry entry = ValidationPlugin.getLogEntry();
                    entry.setSourceID("ValidationUtility.listValidatorClasses(" + resource.getName() + ", " + severity);
                    entry.setTargetException((Throwable)exc);
                    logger.write(Level.SEVERE, (Object)entry);
                }
            }
            ++i;
        }
        if (tempSet.size() > 0) {
            String[] result = new String[tempSet.size()];
            tempSet.toArray(result);
            tempSet.clear();
            return result;
        }
        return new String[0];
    }

    public boolean isEnabled(IProject project, String validatorClassName) {
        return ValidationUtility.isEnabled(project, new String[]{validatorClassName});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEnabled(IProject project, String[] validatorClassNames) {
        if (validatorClassNames == null) return false;
        if (validatorClassNames.length == 0) {
            return false;
        }
        try {
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            int i = 0;
            while (true) {
                if (i >= validatorClassNames.length) {
                    return true;
                }
                if (!prjp.isEnabled(validatorClassNames[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (InvocationTargetException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (!logger.isLoggingLevel(Level.SEVERE)) return false;
            LogEntry entry = ValidationPlugin.getLogEntry();
            entry.setSourceID("ValidationUtility::isEnabled(" + project.getName() + ", String[])");
            entry.setTargetException((Throwable)exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc.getTargetException() == null) return false;
            entry.setTargetException((Throwable)exc);
            logger.write(Level.SEVERE, (Object)entry);
            return false;
        }
    }
}

