/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.debug;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerRulerAction;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorActionBuilder;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.IPopupMenuContributor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredResourceMarkerAnnotationModel;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.debug.EditBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ManageBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointAction;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IExtendedStorageEditorInput;

public class DebugTextEditor
extends TextEditor {
    String[] fShowInTargetIds = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private IShowInTargetList fShowInTargetListAdapter = new ShowInTargetLister();
    IDocumentProvider fStorageInputDocumentProvider = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void createActions() {
        super.createActions();
        BreakpointRulerAction action = new ToggleBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler()){

            protected String getContentType(IDocument document) {
                ILocationProvider provider;
                IEditorInput iEditorInput = DebugTextEditor.this.getEditorInput();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((provider = (ILocationProvider)iEditorInput.getAdapter((Class)clazz)) != null) {
                    IPath location = provider.getPath((Object)DebugTextEditor.this.getEditorInput());
                    return DebugTextEditor.this.detectContentType(location).getId();
                }
                if (DebugTextEditor.this.getEditorInput() instanceof IPathEditorInput) {
                    IPath location = ((IPathEditorInput)DebugTextEditor.this.getEditorInput()).getPath();
                    return DebugTextEditor.this.detectContentType(location).getId();
                }
                return "org.eclipse.core.runtime.text";
            }
        };
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)action);
        action = new ManageBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)action);
        action = new EditBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)action);
    }

    protected String[] createShowInTargetIds() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("showintarget", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!allIds.contains("org.eclipse.ui.views.ResourceNavigator")) {
            allIds.add("org.eclipse.ui.views.ResourceNavigator");
        }
        return allIds.toArray(new String[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IContentType detectContentType(IPath location) {
        IContentType type;
        block17: {
            File file;
            block15: {
                block16: {
                    type = null;
                    IFile resource = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                    if (resource == null) break block16;
                    if (resource.getType() == 1 && resource.isAccessible()) {
                        IContentDescription d = null;
                        try {
                            d = resource.getContentDescription();
                            if (d != null) {
                                type = d.getContentType();
                            }
                        }
                        catch (CoreException coreException) {}
                        if (type == null) {
                            type = Platform.getContentTypeManager().findContentTypeFor(resource.getName());
                        }
                    }
                    break block17;
                }
                file = FileBuffers.getSystemFileAtLocation((IPath)location);
                if (file == null) break block17;
                FileInputStream input = null;
                try {
                    try {
                        input = new FileInputStream(file);
                        type = Platform.getContentTypeManager().findContentTypeFor((InputStream)input, location.toOSString());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (input == null) throw throwable;
                    try {
                        ((InputStream)input).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var6_9 = null;
                    if (input == null) break block15;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)input).close();
            }
            if (type == null) {
                type = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            }
        }
        if (type != null) return type;
        return Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IEditorActionBarContributor c = this.getEditorSite().getActionBarContributor();
        if (c instanceof IPopupMenuContributor) {
            ((IPopupMenuContributor)c).contributeToPopupMenu(menu);
        } else {
            ExtendedEditorActionBuilder builder = new ExtendedEditorActionBuilder();
            IExtendedContributor pmc = builder.readActionExtensions(this.getConfigurationPoints());
            if (pmc != null) {
                pmc.setActiveEditor((IEditorPart)this);
                pmc.contributeToPopupMenu(menu);
            }
        }
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.fShowInTargetListAdapter;
        }
        return super.getAdapter(required);
    }

    protected String[] getConfigurationPoints() {
        String string = this.getInputContentType(this.getEditorInput());
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.sse.ui.internal.debug.DebugTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)this, string, ".source", clazz);
    }

    IContentType[] getEditorInputContentTypes(IEditorInput input) {
        IContentType[] types = null;
        IFile resource = null;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (input.getAdapter((Class)clazz) != null) {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IFile)input.getAdapter((Class)clazz2);
        } else {
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (input.getAdapter((Class)clazz3) != null) {
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)input.getAdapter((Class)clazz4);
            }
        }
        if (resource.getType() == 1 && resource.isAccessible()) {
            IContentDescription d = null;
            try {
                d = resource.getContentDescription();
                if (d != null) {
                    types = new IContentType[]{d.getContentType()};
                }
            }
            catch (CoreException coreException) {}
        }
        if (types == null) {
            types = Platform.getContentTypeManager().findContentTypesFor(input.getName());
        }
        return types;
    }

    private String getInputContentType(IEditorInput editorInput) {
        IContentType[] types = this.getEditorInputContentTypes(editorInput);
        if (types != null) {
            return types[0].getId();
        }
        return null;
    }

    private boolean isDebuggingAvailable() {
        boolean debuggingAvailable = false;
        IContentType[] types = this.getEditorInputContentTypes(this.getEditorInput());
        int i = 0;
        while (!debuggingAvailable && i < types.length) {
            debuggingAvailable = debuggingAvailable || BreakpointProviderBuilder.getInstance().isAvailable(types[i].getId(), BreakpointRulerAction.getFileExtension(this.getEditorInput()));
            ++i;
        }
        return debuggingAvailable;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        if (this.isDebuggingAvailable()) {
            menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
            menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.manage"));
            menu.add(this.getAction("org.eclipse.wst.sse.ui.breakpoints.edit"));
            menu.add((IContributionItem)new Separator());
        } else {
            Logger.log(1, String.valueOf(((Object)((Object)this)).getClass().getName()) + " could not enable debugging actions");
        }
        super.rulerContextMenuAboutToShow(menu);
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            if (this.fStorageInputDocumentProvider == null) {
                this.fStorageInputDocumentProvider = new StorageInputDocumentProvider();
            }
            this.setDocumentProvider(this.fStorageInputDocumentProvider);
        } else {
            super.setDocumentProvider(input);
        }
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        if (this.isDebuggingAvailable()) {
            this.setAction("RulerDoubleClick", this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
        } else {
            this.setAction("RulerDoubleClick", (IAction)new MarkerRulerAction(SSEUIMessages.getResourceBundle(), "Editor.ManageBookmarks.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler(), "org.eclipse.core.resources.bookmark", true));
        }
        this.fShowInTargetIds = this.createShowInTargetIds();
    }

    private class ShowInTargetLister
    implements IShowInTargetList {
        private ShowInTargetLister() {
        }

        public String[] getShowInTargetIds() {
            return DebugTextEditor.this.fShowInTargetIds;
        }
    }

    class StorageInputDocumentProvider
    extends StorageDocumentProvider
    implements IElementStateListener {
        StorageInputDocumentProvider() {
        }

        protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
            StructuredResourceMarkerAnnotationModel model = null;
            IStorageEditorInput storageInput = (IStorageEditorInput)element;
            String ext = BreakpointRulerAction.getFileExtension((IEditorInput)storageInput);
            IContentType[] types = DebugTextEditor.this.getEditorInputContentTypes((IEditorInput)storageInput);
            IResource res = null;
            int i = 0;
            while (res == null && i < types.length) {
                res = BreakpointProviderBuilder.getInstance().getResource((IEditorInput)storageInput, types[i].getId(), ext);
                ++i;
            }
            String id = storageInput.getName();
            if (storageInput.getStorage() != null) {
                IPath fullPath = storageInput.getStorage().getFullPath();
                id = fullPath != null ? fullPath.toString() : storageInput.getName();
            }
            model = res != null ? new StructuredResourceMarkerAnnotationModel(res, id) : new StructuredResourceMarkerAnnotationModel((IResource)ResourcesPlugin.getWorkspace().getRoot(), id);
            return model;
        }

        protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
            if (element instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)element).addElementStateListener(this);
            }
            return super.createElementInfo(element);
        }

        protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
            if (element instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)element).removeElementStateListener(this);
            }
            super.disposeElementInfo(element, info);
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            new FileDocumentProvider().saveDocument(monitor, element, document, overwrite);
        }

        public void elementContentAboutToBeReplaced(Object element) {
            this.fireElementContentAboutToBeReplaced(element);
        }

        public void elementContentReplaced(Object element) {
            this.fireElementContentReplaced(element);
        }

        public void elementDeleted(Object element) {
            this.fireElementDeleted(element);
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            this.fireElementDirtyStateChanged(element, isDirty);
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            this.fireElementMoved(originalElement, movedElement);
        }
    }
}

