/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Hashtable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.HTMLCoreMessages;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.validate.ErrorInfo;
import org.eclipse.wst.html.core.internal.validate.ErrorState;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;

class MessageFactory
implements ErrorState {
    private static final String MSG_NO_ERROR = HTMLCoreMessages.No_error__UI_;
    private static final String MSG_UNDEFINED_ATTR_ERROR = HTMLCoreMessages.Undefined_attribute_name___ERROR_;
    private static final String MSG_UNDEFINED_VALUE_ERROR = HTMLCoreMessages.Undefined_attribute_value__ERROR_;
    private static final String MSG_DUPLICATE_ATTR_ERROR = HTMLCoreMessages.Multiple_values_specified__ERROR_;
    private static final String MSG_MISMATCHED_ATTR_ERROR = HTMLCoreMessages.Attribute_name___0___uses__ERROR_;
    private static final String MSG_INVALID_ATTR_ERROR = HTMLCoreMessages.Invalid_attribute_name___0_ERROR_;
    private static final String MSG_ATTR_NO_VALUE_ERROR = HTMLCoreMessages.Invalid_attribute___0____ERROR_;
    private static final String MSG_INVALID_CONTENT_ERROR = HTMLCoreMessages.Invalid_location_of_tag____ERROR_;
    private static final String MSG_DUPLICATE_TAG_ERROR = HTMLCoreMessages.Duplicate_tag___0____ERROR_;
    private static final String MSG_MISSING_START_TAG_ERROR = HTMLCoreMessages.No_start_tag____0_____ERROR_;
    private static final String MSG_MISSING_END_TAG_ERROR = HTMLCoreMessages.No_end_tag_____0_____ERROR_;
    private static final String MSG_UNNECESSARY_END_TAG_ERROR = HTMLCoreMessages.End_tag_____0____not_neede_ERROR_;
    private static final String MSG_UNDEFINED_TAG_ERROR = HTMLCoreMessages.Unknown_tag___0____ERROR_;
    private static final String MSG_MISMATCHED_TAG_ERROR = HTMLCoreMessages.Tag_name___0___uses_wrong__ERROR_;
    private static final String MSG_INVALID_TAG_ERROR = HTMLCoreMessages.Invalid_tag_name___0____ERROR_;
    private static final String MSG_INVALID_DIRECTIVE_ERROR = HTMLCoreMessages.Invalid_JSP_directive___0__ERROR_;
    private static final String MSG_INVALID_TEXT_ERROR = HTMLCoreMessages.Invalid_text_string___0____ERROR_;
    private static final String MSG_INVALID_CHAR_ERROR = HTMLCoreMessages.Invalid_character_used_in__ERROR_;
    private static final String MSG_UNKNOWN_ERROR = HTMLCoreMessages.Unknown_error__ERROR_;
    private static final String MSG_UNCLOSED_START_TAG_ERROR = HTMLCoreMessages.Start_tag____0____not_clos_ERROR_;
    private static final String MSG_UNCLOSED_END_TAG_ERROR = HTMLCoreMessages.End_tag_____0____not_close_ERROR_;
    private static final String MSG_MISMATCHED_ATTR_VALUE_ERROR = HTMLCoreMessages.Attribute_value___0___uses_ERROR_;
    private static final String MSG_UNCLOSED_COMMENT_ERROR = HTMLCoreMessages.Comment_not_closed__ERROR_;
    private static final String MSG_UNCLOSED_DOCTYPE_ERROR = HTMLCoreMessages.DOCTYPE_declaration_not_cl_ERROR_;
    private static final String MSG_UNCLOSED_PI_ERROR = HTMLCoreMessages.Processing_instruction_not_ERROR_;
    private static final String MSG_UNCLOSED_CDATA_SECTION_ERROR = HTMLCoreMessages.CDATA_section_not_closed__ERROR_;
    private static final String MSG_INVALID_EMPTY_ELEMENT_TAG = HTMLCoreMessages._ERROR_Tag___0___should_be_an_empty_element_tag_1;
    private static final String MSG_UNCLOSED_ATTR_VALUE_ERROR = HTMLCoreMessages._ERROR_Attribute_value___0___not_closed__1;
    private static ErrorTable[] errTables = new ErrorTable[8];
    private static IScopeContext[] scopeContexts = new IScopeContext[]{new InstanceScope(), new DefaultScope()};

    static {
        int i = 0;
        while (i < 8) {
            MessageFactory.errTables[i] = new ErrorTable();
            ++i;
        }
        ErrorTable attrTable = errTables[0];
        attrTable.put(0, MSG_NO_ERROR, 0);
        attrTable.put(11, MSG_UNDEFINED_ATTR_ERROR, 2);
        attrTable.put(12, MSG_UNDEFINED_VALUE_ERROR, 2);
        attrTable.put(103, MSG_MISMATCHED_ATTR_ERROR, 2);
        attrTable.put(101, MSG_INVALID_ATTR_ERROR, 2);
        attrTable.put(108, MSG_ATTR_NO_VALUE_ERROR, 2);
        attrTable.put(1002, MSG_DUPLICATE_ATTR_ERROR, 2);
        attrTable.put(13, MSG_MISMATCHED_ATTR_VALUE_ERROR, 1);
        attrTable.put(113, MSG_UNCLOSED_ATTR_VALUE_ERROR, 2);
        ErrorTable elemTable = errTables[1];
        elemTable.put(0, MSG_NO_ERROR, 0);
        elemTable.put(11, MSG_UNDEFINED_TAG_ERROR, 2);
        elemTable.put(101, MSG_INVALID_TAG_ERROR, 1);
        elemTable.put(103, MSG_MISMATCHED_TAG_ERROR, 2);
        elemTable.put(104, MSG_MISMATCHED_TAG_ERROR, 1);
        elemTable.put(105, MSG_MISSING_START_TAG_ERROR, 1, "elemMissingStart");
        elemTable.put(106, MSG_MISSING_END_TAG_ERROR, 2, "elemMissingEnd");
        elemTable.put(107, MSG_UNNECESSARY_END_TAG_ERROR, 2);
        elemTable.put(109, MSG_INVALID_DIRECTIVE_ERROR, 1);
        elemTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
        elemTable.put(1002, MSG_DUPLICATE_TAG_ERROR, 2);
        elemTable.put(1003, MSG_INVALID_CONTENT_ERROR, 2);
        elemTable.put(110, MSG_UNCLOSED_START_TAG_ERROR, 1);
        elemTable.put(111, MSG_UNCLOSED_END_TAG_ERROR, 1);
        elemTable.put(112, MSG_INVALID_EMPTY_ELEMENT_TAG, 2);
        ErrorTable docTable = errTables[2];
        docTable.put(0, MSG_NO_ERROR, 0);
        docTable.put(1002, MSG_DUPLICATE_TAG_ERROR, 1);
        docTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
        docTable.put(110, MSG_UNCLOSED_DOCTYPE_ERROR, 1);
        ErrorTable textTable = errTables[3];
        textTable.put(0, MSG_NO_ERROR, 0);
        textTable.put(1001, MSG_INVALID_TEXT_ERROR, 2);
        textTable.put(102, MSG_INVALID_CHAR_ERROR, 2);
        ErrorTable commTable = errTables[4];
        commTable.put(0, MSG_NO_ERROR, 0);
        commTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
        commTable.put(110, MSG_UNCLOSED_COMMENT_ERROR, 1);
        ErrorTable cdatTable = errTables[5];
        cdatTable.put(0, MSG_NO_ERROR, 0);
        cdatTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
        cdatTable.put(110, MSG_UNCLOSED_CDATA_SECTION_ERROR, 1);
        ErrorTable piTable = errTables[6];
        piTable.put(0, MSG_NO_ERROR, 0);
        piTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
        piTable.put(110, MSG_UNCLOSED_PI_ERROR, 1);
        ErrorTable erTable = errTables[7];
        erTable.put(0, MSG_NO_ERROR, 0);
        erTable.put(11, MSG_UNDEFINED_TAG_ERROR, 2);
        erTable.put(1001, MSG_INVALID_CONTENT_ERROR, 2);
    }

    MessageFactory() {
    }

    public static ValidationMessage createMessage(ErrorInfo info) {
        String errorMsg = MessageFactory.getErrorMessage(info);
        int errorSeverity = MessageFactory.getErrorSeverity(info);
        return new ValidationMessage(errorMsg, info.getOffset(), info.getLength(), errorSeverity);
    }

    private static String getErrorMessage(ErrorInfo info) {
        ErrorTable tab = MessageFactory.getErrorTable(info.getTargetType());
        if (tab == null) {
            return MSG_UNKNOWN_ERROR;
        }
        String template = tab.getMessage(info.getState());
        Object[] arguments = new Object[]{info.getHint()};
        String s = null;
        try {
            s = NLS.bind((String)template, (Object[])arguments);
        }
        catch (IllegalArgumentException e) {
            Logger.logException(e);
            s = String.valueOf(template) + ":" + arguments.toString();
        }
        return s;
    }

    private static int getErrorSeverity(ErrorInfo info) {
        ErrorTable tab = MessageFactory.getErrorTable(info.getTargetType());
        if (tab == null) {
            return 0;
        }
        return tab.getSeverity(info.getState());
    }

    private static ErrorTable getErrorTable(short nodetype) {
        ErrorTable tab = null;
        switch (nodetype) {
            case 2: {
                tab = errTables[0];
                break;
            }
            case 1: {
                tab = errTables[1];
                break;
            }
            case 10: {
                tab = errTables[2];
                break;
            }
            case 3: {
                tab = errTables[3];
                break;
            }
            case 8: {
                tab = errTables[4];
                break;
            }
            case 4: {
                tab = errTables[5];
                break;
            }
            case 7: {
                tab = errTables[6];
                break;
            }
            case 5: {
                tab = errTables[7];
                break;
            }
            default: {
                return null;
            }
        }
        return tab;
    }

    private static String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    private static class ErrorTable {
        private Hashtable map = new Hashtable();

        public void put(int state, String msg, int severity) {
            Packet packet = new Packet(msg, severity);
            this.map.put(new Integer(state), packet);
        }

        public void put(int state, String msg, int severity, String preferenceName) {
            Packet packet = new Packet(msg, severity, preferenceName);
            this.map.put(new Integer(state), packet);
        }

        public String getMessage(int state) {
            return this.getPacket(state).getMessage();
        }

        public int getSeverity(int state) {
            Packet packet = this.getPacket(state);
            if (packet.getPreferenceName() != null) {
                return Platform.getPreferencesService().getInt(MessageFactory.getPreferenceNodeQualifier(), packet.getPreferenceName(), packet.getSeverity(), scopeContexts);
            }
            return packet.getSeverity();
        }

        private Packet getPacket(int state) {
            return (Packet)this.map.get(new Integer(state));
        }

        private class Packet {
            private String msg = null;
            private int severity = -1;
            private String preferenceName = null;

            public Packet(String msg, int severity) {
                this.msg = msg;
                this.severity = severity;
            }

            public Packet(String msg, int severity, String preferenceName) {
                this.msg = msg;
                this.severity = severity;
                this.preferenceName = preferenceName;
            }

            public String getMessage() {
                return this.msg;
            }

            public int getSeverity() {
                return this.severity;
            }

            public String getPreferenceName() {
                return this.preferenceName;
            }
        }
    }

    private static interface NodeType {
        public static final int ATTRIBUTE = 0;
        public static final int ELEMENT = 1;
        public static final int DOCUMENT_TYPE = 2;
        public static final int TEXT = 3;
        public static final int COMMENT = 4;
        public static final int CDATA_SECTION = 5;
        public static final int PROCESSING_INSTRUCTION = 6;
        public static final int ENTITY_REFERENCE = 7;
        public static final int MAX_TYPE = 8;
    }
}

