/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public abstract class Base {
    protected static final String PROP_LOCKED = "locked";
    protected static final String PROP_PRIVATE = "private";
    protected static final String PROP_NAME = "name";
    protected static final String PROP_ID = "id";
    protected static final String PROP_TIMESTAMP = "timestamp";
    protected Map map = new HashMap();
    protected IFile file;

    public Base(IFile file) {
        this.file = file;
    }

    public Base(IFile file, String id) {
        this.file = file;
        this.map.put(PROP_ID, id);
    }

    public int getTimestamp() {
        return this.getAttribute(PROP_TIMESTAMP, -1);
    }

    public IFile getFile() {
        return this.file;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return (String)obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int getAttribute(String attributeName, int defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return Integer.parseInt((String)obj);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return Boolean.valueOf((String)obj);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public List getAttribute(String attributeName, List defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            List list = (List)obj;
            if (list != null) {
                return list;
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    public Map getAttribute(String attributeName, Map defaultValue) {
        try {
            Object obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            Map map2 = (Map)obj;
            if (map2 != null) {
                return map2;
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    public String getId() {
        return this.getAttribute(PROP_ID, "");
    }

    public String getName() {
        return this.getAttribute(PROP_NAME, "");
    }

    public boolean isReadOnly() {
        return this.getAttribute(PROP_LOCKED, false);
    }

    public boolean isPrivate() {
        return this.getAttribute(PROP_PRIVATE, false);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected abstract String getXMLRoot();

    protected void save(IMemento memento) {
        IMemento child = memento;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object obj = this.map.get(key);
            if (obj instanceof String) {
                child.putString(key, (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                Integer in = (Integer)obj;
                child.putInteger(key, in);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean bool = (Boolean)obj;
                child.putBoolean(key, bool);
                continue;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                this.saveList(child, key, list);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map map2 = (Map)obj;
            this.saveMap(child, key, map2);
        }
        this.saveState(child);
    }

    protected void saveMap(IMemento memento, String key, Map map2) {
        IMemento child = memento.createChild("map");
        child.putString("key", key);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            child.putString(s, (String)map2.get(s));
        }
    }

    protected void saveList(IMemento memento, String key, List list) {
        IMemento child = memento.createChild("list");
        child.putString("key", key);
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            child.putString("value" + i++, s);
        }
    }

    protected void saveToFile(IProgressMonitor monitor) throws CoreException {
        try {
            XMLMemento memento = XMLMemento.createWriteRoot(this.getXMLRoot());
            this.save(memento);
            InputStream in = memento.getInputStream();
            if (this.file.exists()) {
                this.file.setContents(in, true, true, ProgressUtil.getSubMonitorFor(monitor, 1000));
            } else {
                this.file.create(in, true, ProgressUtil.getSubMonitorFor(monitor, 1000));
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save " + this.getXMLRoot(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorSaving, (Object)this.getFile().toString()), (Throwable)e));
        }
    }

    protected void doSave(IProgressMonitor monitor) throws CoreException {
        if (this.file != null) {
            this.saveToFile(monitor);
        } else {
            this.saveToMetadata(monitor);
        }
        ResourceManager.getInstance().resolveServers();
    }

    protected void saveToMetadata(IProgressMonitor monitor) {
    }

    protected abstract void saveState(IMemento var1);

    protected void load(IMemento memento) {
        IMemento[] maps;
        int i;
        this.map = new HashMap();
        Iterator iterator = memento.getNames().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.map.put(key, memento.getString(key));
        }
        IMemento[] children = memento.getChildren("list");
        if (children != null) {
            int size = children.length;
            i = 0;
            while (i < size) {
                this.loadList(children[i]);
                ++i;
            }
        }
        if ((maps = memento.getChildren("map")) != null) {
            i = 0;
            while (i < maps.length) {
                this.loadMap(maps[i]);
                ++i;
            }
        }
        this.loadState(memento);
    }

    protected void loadMap(IMemento memento) {
        String key = memento.getString("key");
        HashMap<String, String> vMap = new HashMap<String, String>();
        List keys = memento.getNames();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            String v = memento.getString(s);
            vMap.put(s, v);
        }
        this.map.put(key, vMap);
    }

    protected void loadList(IMemento memento) {
        String key = memento.getString("key");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        String key2 = memento.getString("value" + i++);
        while (key2 != null) {
            list.add(key2);
            key2 = memento.getString("value" + i++);
        }
        this.map.put(key, list);
    }

    protected abstract void loadState(IMemento var1);

    protected void resolve() {
    }

    public void delete() throws CoreException {
        if (this.isWorkingCopy()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, "Cannot delete a working copy", null));
        }
        if (this.file != null) {
            this.deleteFromFile();
        } else {
            this.deleteFromMetadata();
        }
    }

    protected void deleteFromFile() throws CoreException {
        this.file.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void deleteFromMetadata() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Base)) {
            return false;
        }
        Base base = (Base)obj;
        if (this.getId() == null) {
            return false;
        }
        return this.getId().equals(base.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFromFile(IProgressMonitor monitor) throws CoreException {
        InputStream in = null;
        try {
            try {
                in = this.file.getContents();
                IMemento memento = XMLMemento.loadMemento(in);
                this.load(memento);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not load from file" + e.getMessage(), e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorLoading, (Object)this.getFile().toString()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        in.close();
    }

    protected void loadFromMemento(IMemento memento, IProgressMonitor monitor) {
        this.load(memento);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFromPath(IPath path, IProgressMonitor monitor) throws CoreException {
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(path.toFile());
                IMemento memento = XMLMemento.loadMemento(fin);
                this.load(memento);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not load from path: " + e.getMessage(), e);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorLoading, (Object)path.toString()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                fin.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        fin.close();
    }

    public IStatus validateEdit(Object context) {
        if (this.file == null) {
            return null;
        }
        return this.file.getWorkspace().validateEdit(new IFile[]{this.file}, context);
    }
}

