/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Node;

public class TestModelClone
extends TestCase {
    private HashMap embeddedModelQueries = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    public TestModelClone(String name) {
        super(name);
    }

    public static Test getTest() {
        return new TestModelClone("testCreateStructuredModelJSP");
    }

    public void testCloneStructuredModelXML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelHTML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelJSP() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        IDOMDocument doc = ((IDOMModel)clonedModel).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"cloned model did not have embedded adapter", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"cloned model did not have embedded handler", (Object)embeddedHandler);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelJSPXML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz);
        String testContent = "<%@ page contentType=\"text/xml\" %>";
        model.getStructuredDocument().setText((Object)this, testContent);
        TestModelClone.assertTrue((String)"model should not need reinit", (!model.isReinitializationNeeded() ? 1 : 0) != 0);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.wst.xml.core.internal.modelhandler.EmbeddedXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz2);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.xml.core.internal.modelhandler.EmbeddedXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(clonedModel, clazz3);
    }

    private void checkEmbeddedType(IStructuredModel model, Class expectedType) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have pageDirective", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"model did not have embedded handler", (Object)embeddedHandler);
        TestModelClone.assertEquals((Object)expectedType, embeddedHandler.getClass());
    }

    public void testCreateStructuredModelJSP() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        ArrayList factories = (ArrayList)model.getFactoryRegistry().getFactories();
        factories = (ArrayList)factories.clone();
        IStructuredModel clonedModel = model.newInstance();
        if (model.getModelHandler() == null) {
            System.out.println();
            TestModelClone.assertTrue((boolean)false);
        }
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        ArrayList newFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        newFactories = (ArrayList)newFactories.clone();
        boolean passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().replaceText((Object)this, 0, 0, "<sample> text");
        ArrayList twoFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        twoFactories = (ArrayList)twoFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, twoFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().setText((Object)this, "<%@ page contentType=\"text/html\"");
        ArrayList threeFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        threeFactories = (ArrayList)threeFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, threeFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCreateStructuredModelJSPXHTML() throws IOException {
        Class<?> clazz;
        Class<?> clazz2;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        model.getStructuredDocument().setText((Object)this, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<%@page language=\"java\" contentType=\"text/xml; charset=ISO-8859-1\"\n        pageEncoding=\"ISO-8859-1\"%>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/xml; charset=ISO-8859-1\" />\n<style>\nA { color: red; }\n</style>\n</head>\n</html>\n");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkModelQuery(model, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedModelQuery(model, clazz5, clazz2, clazz);
    }

    public void testCreateStructuredModelJSPXHTMnoDoctype() throws IOException {
        Class<?> clazz;
        Class<?> clazz2;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        model.getStructuredDocument().setText((Object)this, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<%@page language=\"java\" contentType=\"text/xml; charset=ISO-8859-1\"\n        pageEncoding=\"ISO-8859-1\"%>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/xml; charset=ISO-8859-1\" />\n<style>\nA { color: red; }\n</style>\n</head>\n</html>\n");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkModelQuery(model, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedModelQuery(model, clazz5, clazz2, clazz);
    }

    public void testCreateStructuredModelJSPXHTML2() throws IOException {
        Class<?> clazz;
        Class<?> clazz2;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        model.getStructuredDocument().setText((Object)this, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<%@page language=\"java\" contentType=\"application/xml; charset=ISO-8859-1\"\n        pageEncoding=\"ISO-8859-1\"%>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"application/xml; charset=ISO-8859-1\" />\n<style>\nA { color: red; }\n</style>\n</head>\n</html>\n");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkModelQuery(model, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedModelQuery(model, clazz5, clazz2, clazz);
    }

    private void checkModelQuery(IStructuredModel model, Class class1) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModelQueryAdapter modelQueryAdapter = (ModelQueryAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have modelQueryAdapter", (Object)modelQueryAdapter);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestModelClone.assertTrue((String)"modelQueryAdapter is wrong class", (boolean)class1.equals(clazz2));
    }

    private void checkEmbeddedModelQuery(IStructuredModel model, Class outerQueryAdapter, Class outerQueryClass, Class embeddedQueryClass) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModelQueryAdapter modelQueryAdapter = (ModelQueryAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have modelQueryAdapter", (Object)modelQueryAdapter);
        Class expected = outerQueryAdapter;
        Class<?> actual = modelQueryAdapter.getClass();
        TestModelClone.assertEquals((String)"document's model query is not as expected", (Object)expected, actual);
        ModelQuery modelQuery = modelQueryAdapter.getModelQuery();
        expected = outerQueryClass;
        actual = modelQuery.getClass();
        TestModelClone.assertEquals((String)"model query adapter's model query is not as expected", (Object)expected, actual);
        ModelQuery nodeQuery = this.getEmbeddedModelQuery((Node)doc);
        TestModelClone.assertNotNull((String)"node does not have a modelQueryAdapter", (Object)nodeQuery);
        expected = embeddedQueryClass;
        actual = nodeQuery.getClass();
        TestModelClone.assertEquals((String)"documents model query is not as expected", (Object)expected, actual);
    }

    private boolean checkForSameEmbeddedFactories(IStructuredModel model, IStructuredModel clonedModel) {
        boolean result = true;
        EmbeddedTypeHandler oldEmbeddedType = this.getEmbeddedType(model);
        EmbeddedTypeHandler newEmbeddedType = this.getEmbeddedType(clonedModel);
        if (!oldEmbeddedType.getClass().equals(newEmbeddedType.getClass())) {
            result = false;
            TestModelClone.assertTrue((boolean)result);
        }
        List oldFactories = oldEmbeddedType.getAdapterFactories();
        List newFactories = newEmbeddedType.getAdapterFactories();
        result = this.checkFactoriesListForEquivalence(oldFactories, newFactories);
        return result;
    }

    private EmbeddedTypeHandler getEmbeddedType(IStructuredModel model) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have embedded adapter", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"model did not have embedded handler", (Object)embeddedHandler);
        return embeddedHandler;
    }

    private boolean checkFactoriesListForIdentity(List factories, List newFactories) {
        boolean result = true;
        if (factories.size() != newFactories.size()) {
            result = false;
        }
        return result;
    }

    private boolean checkFactoriesListForEquivalence(List factories, List newFactories) {
        boolean result = true;
        if (factories.size() != newFactories.size()) {
            result = false;
        } else {
            int i = 0;
            while (i < factories.size()) {
                if (!factories.get(i).getClass().equals(newFactories.get(i).getClass())) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void testCreateStructuredModelHTML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        ArrayList factories = (ArrayList)model.getFactoryRegistry().getFactories();
        factories = (ArrayList)factories.clone();
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        ArrayList newFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        newFactories = (ArrayList)newFactories.clone();
        boolean passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().setText((Object)this, "<sample> text");
        ArrayList twoFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        twoFactories = (ArrayList)twoFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    private ModelQuery getEmbeddedModelQuery(Node node) {
        ModelQuery embeddedModelQuery = null;
        if (node instanceof INodeNotifier) {
            PageDirectiveAdapter pageDirectiveAdapter;
            Node ownerNode = node.getOwnerDocument();
            if (ownerNode == null) {
                ownerNode = node;
            }
            INodeNotifier iNodeNotifier = (INodeNotifier)ownerNode;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz)) != null) {
                String effectiveContentType = null;
                ModelQuery potentialModelQueryObject = null;
                String familyId = pageDirectiveAdapter.getEmbeddedType().getFamilyId();
                effectiveContentType = "org.eclipse.wst.html.core.contentfamily.html".equals(familyId) ? "text/html" : pageDirectiveAdapter.getContentType();
                potentialModelQueryObject = (ModelQuery)this.embeddedModelQueries.get(effectiveContentType);
                if (potentialModelQueryObject == null) {
                    ModelQueryAdapter embeddedAdapter;
                    INodeNotifier iNodeNotifier2 = (INodeNotifier)node;
                    Class<?> clazz2 = class$6;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$6 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((embeddedAdapter = (ModelQueryAdapter)pageDirectiveAdapter.adapt(iNodeNotifier2, (Object)clazz2)) != null) {
                        embeddedModelQuery = embeddedAdapter.getModelQuery();
                        this.embeddedModelQueries.put(effectiveContentType, embeddedModelQuery);
                    }
                } else {
                    embeddedModelQuery = potentialModelQueryObject;
                }
            }
        }
        return embeddedModelQuery;
    }

    public void testCreateStructuredModelJSPXML() throws IOException {
        Class<?> clazz;
        Class<?> clazz2;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        model.getStructuredDocument().setText((Object)this, "<%-- keep JSP page compiler from generating code that accesses the session --%>\n<%@ page session=\"false\"  contentType=\"text/xml; charset=ISO-8859-1\" %>\n\n<!-- load WPS portlet tag library and initialize objects -->\n<%@ taglib uri=\"/WEB-INF/tld/portlet.tld\" prefix=\"portletAPI\" %>\n<portletAPI:init /> \n\n<%-- Replace the name of the layout specified by the layoutName attribute of the canvas element below with the layout name for your portlet. --%>\n<canvas xmlns =\"http://www.volantis.com/xmlns/marlin-cdm\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        layoutName=\"/sample_layout.mlyt\" \n        type=\"portlet\" >\n\n\n<%-- Specify the pane name from your layout policy as the value for the name attribute of the pane element below  --%>\n<pane name=\"sample_pane\">\n    <p>Hello!</p>\n    <p>This is an XDIME <b>view mode</b> page . You have to edit this page to customize it for your own use.<br/><br/>\n    The source file for this page is \"/Web Content/testportlet_legacy/jsp/xdime/TemplateLegacyPortletView.jsp\".\n</p>\n\n<br/>\nThis is image 1    \n<img src=\"/paw.mimg\" alt=\"noimg\" />\n\n<br/>\nThis is image 2    \n<img src=\"paw.mimg\" alt=\"noimg\" />\n\n</pane>\n</canvas>");
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.xml.core.internal.modelhandler.EmbeddedXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkModelQuery(model, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$7) == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.wst.xml.core.internal.modelquery.XMLModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedModelQuery(model, clazz5, clazz2, clazz);
    }

    public void testCreateStructuredModelJSPWML() throws IOException {
        Class<?> clazz;
        Class<?> clazz2;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        model.getStructuredDocument().setText((Object)this, "<%@ page contentType=\"text/vnd.wap.wml\" %>\n\n  <jsp:useBean id=\"beanInstanceName\" scope=\"session\" class=\"package.class\" />\n  <jsp:getProperty name=\"beanInstanceName\" property=\"*\" />\n\n  <?xml version=\"1.0\" encoding=\"utf-8\"?>\n  <!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.3//EN\" \"http://www.wapforum.org/DTD/wml13.dtd\">\n  <wml>\n\n    <template>\n      <!-- Template implementation here. -->\n      <do type=\"prev\"><prev/></do>\n    </template>\n\n  <%\n  if (session.isNew() || session.getAttribute(\"userid\")==null ) {\n  %>\n    <card id=\"card1\" title=\"Card #1\">\n\n      <do type=\"unknown\" label=\"Next\">\n        <go href=\"#card2\"/>\n      </do>\n      <p align=\"center\">\n        <big><b>First Card</b></big>\n      </p>\n    </card>\n\n  <%\n  } else {\n  %>\n    <card id=\"card2\" title=\"Card #2\">\n\n      <p align=\"center\">\n        <big><b> <%= beanInstanceName.getUserid() %> </b></big>\n      </p>\n    </card>\n  <%\n  }\n  %>\n  </wml>");
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkModelQuery(model, clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryAdapterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$3) == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jst.jsp.core.internal.modelquery.JSPModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedModelQuery(model, clazz5, clazz2, clazz);
    }
}

