/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.project.facet.ProductManager;

public class J2EEPreferences {
    private Plugin owner = null;
    private Preferences preferences = null;
    private boolean persistOnChange = false;

    public J2EEPreferences(Plugin owner) {
        this.owner = owner;
    }

    protected void initializeDefaultPreferences() {
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.j2eeWebContentName", "WebContent");
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.staticWebContentName", "WebContent");
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.javaSourceName", "JavaSource");
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.ui.preference.j2eeVersion", "J2EE_1_4");
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.createClientJar", false);
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preference.clientjar.cp.compatibility", true);
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.ui.preference.incrementalDeployment", true);
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preferences.useEARLibraries", ProductManager.getProperty((String)"use_ear_libraries"));
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preferences.useWebAppLibraries", ProductManager.getProperty((String)"use_web_app_libraries"));
        this.getPreferences().setDefault("org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport", false);
    }

    public String getSetting(String key) {
        return this.getPreferences().getString(key);
    }

    public void setSetting(String key, String value) {
        this.getPreferences().setValue(key, value);
        this.firePreferenceChanged();
    }

    public boolean getUseEARLibraries() {
        return this.getPreferences().getBoolean("org.eclipse.jst.j2ee.preferences.useEARLibraries");
    }

    public void setUseEARLibraries(boolean value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preferences.useEARLibraries", value);
        this.firePreferenceChanged();
    }

    public boolean getUseEARLibrariesJDTExport() {
        return this.getPreferences().getBoolean("org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport");
    }

    public void setUseEARLibrariesJDTExport(boolean value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport", value);
        this.firePreferenceChanged();
    }

    public boolean getUseWebLibaries() {
        return this.getPreferences().getBoolean("org.eclipse.jst.j2ee.preferences.useWebAppLibraries");
    }

    public void setUseWebLibraries(boolean value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preferences.useWebAppLibraries", value);
        this.firePreferenceChanged();
    }

    public String getJ2EEWebContentFolderName() {
        return this.getPreferences().getString("org.eclipse.jst.j2ee.preference.j2eeWebContentName");
    }

    public String getStaticWebContentFolderName() {
        return this.getPreferences().getString("org.eclipse.jst.j2ee.preference.staticWebContentName");
    }

    public String getJavaSourceFolderName() {
        return this.getPreferences().getString("org.eclipse.jst.j2ee.preference.javaSourceName");
    }

    public String getHighestJ2EEVersionSetting() {
        return this.getPreferences().getString("org.eclipse.jst.j2ee.ui.preference.j2eeVersion");
    }

    public boolean isServerTargetingEnabled() {
        return this.getPreferences().getBoolean("org.eclipse.jst.j2ee.preference.servertargetsupport");
    }

    public void setJ2EEWebContentFolderName(String value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preference.j2eeWebContentName", value);
        this.firePreferenceChanged();
    }

    public void setStaticWebContentFolderName(String value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preference.staticWebContentName", value);
        this.firePreferenceChanged();
    }

    public void setJavaSourceFolderName(String value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preference.javaSourceName", value);
        this.firePreferenceChanged();
    }

    public void setHighestJ2EEVersionSetting(String value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.ui.preference.j2eeVersion", value);
        this.firePreferenceChanged();
    }

    public void setServerTargetingEnabled(boolean value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.preference.servertargetsupport", value);
        this.firePreferenceChanged();
    }

    public void setIncrementalDeploymentEnabled(boolean value) {
        this.getPreferences().setValue("org.eclipse.jst.j2ee.ui.preference.incrementalDeployment", value);
        this.firePreferenceChanged();
    }

    public boolean isIncrementalDeploymentEnabled() {
        return this.getPreferences().getBoolean("org.eclipse.jst.j2ee.ui.preference.incrementalDeployment");
    }

    public int getHighestJ2EEVersionID() {
        String versionPreference = this.getHighestJ2EEVersionSetting();
        if ("J2EE_1_2".equals(versionPreference)) {
            return 12;
        }
        if ("J2EE_1_3".equals(versionPreference)) {
            return 13;
        }
        return 14;
    }

    public void firePreferenceChanged() {
        if (this.isPersistOnChange()) {
            this.persist();
        }
    }

    public void persist() {
        this.getOwner().savePluginPreferences();
    }

    public boolean isPersistOnChange() {
        return this.persistOnChange;
    }

    public void setPersistOnChange(boolean persistOnChange) {
        this.persistOnChange = persistOnChange;
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.getOwner().getPluginPreferences();
        }
        return this.preferences;
    }

    private Plugin getOwner() {
        return this.owner;
    }

    public static interface Defaults {
        public static final String J2EE_WEB_CONTENT = "WebContent";
        public static final String STATIC_WEB_CONTENT = "WebContent";
        public static final String JAVA_SOURCE = "JavaSource";
        public static final String J2EE_VERSION = "J2EE_1_4";
        public static final int J2EE_VERSION_ID = 14;
        public static final boolean CREATE_EJB_CLIENT_JAR = false;
        public static final boolean EJB_CLIENT_JAR_CP_COMPATIBILITY = true;
        public static final boolean INCREMENTAL_DEPLOYMENT_SUPPORT = true;
        public static final boolean USE_EAR_LIBRARIES_JDT_EXPORT = false;
    }

    public static interface Keys {
        public static final String J2EE_WEB_CONTENT = "org.eclipse.jst.j2ee.preference.j2eeWebContentName";
        public static final String STATIC_WEB_CONTENT = "org.eclipse.jst.j2ee.preference.staticWebContentName";
        public static final String JAVA_SOURCE = "org.eclipse.jst.j2ee.preference.javaSourceName";
        public static final String SERVER_TARGET_SUPPORT = "org.eclipse.jst.j2ee.preference.servertargetsupport";
        public static final String CREATE_EJB_CLIENT_JAR = "org.eclipse.jst.j2ee.preference.createClientJar";
        public static final String J2EE_VERSION = "org.eclipse.jst.j2ee.ui.preference.j2eeVersion";
        public static final String EJB_CLIENT_JAR_CP_COMPATIBILITY = "org.eclipse.jst.j2ee.preference.clientjar.cp.compatibility";
        public static final String INCREMENTAL_DEPLOYMENT_SUPPORT = "org.eclipse.jst.j2ee.ui.preference.incrementalDeployment";
        public static final String USE_EAR_LIBRARIES = "org.eclipse.jst.j2ee.preferences.useEARLibraries";
        public static final String USE_WEB_APP_LIBRARIES = "org.eclipse.jst.j2ee.preferences.useWebAppLibraries";
        public static final String USE_EAR_LIBRARIES_JDT_EXPORT = "org.eclipse.jst.j2ee.preferences.useEARLibrariesJDTExport";
    }

    public static interface Values {
        public static final String J2EE_VERSION_1_2 = "J2EE_1_2";
        public static final String J2EE_VERSION_1_3 = "J2EE_1_3";
        public static final String J2EE_VERSION_1_4 = "J2EE_1_4";
        public static final String J2EE_WEB_CONTENT = "WebContent";
        public static final String STATIC_WEB_CONTENT = "WebContent";
        public static final String JAVA_SOURCE = "JavaSource";
    }
}

