/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.models.sql.tables;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ReferenceType
extends AbstractEnumerator {
    public static final int SYSTEM_GENERATED = 0;
    public static final int USER_GENERATED = 1;
    public static final int DERIVED_SELF_REF = 2;
    public static final ReferenceType SYSTEM_GENERATED_LITERAL = new ReferenceType(0, "SYSTEM_GENERATED", "SYSTEM_GENERATED");
    public static final ReferenceType USER_GENERATED_LITERAL = new ReferenceType(1, "USER_GENERATED", "USER_GENERATED");
    public static final ReferenceType DERIVED_SELF_REF_LITERAL = new ReferenceType(2, "DERIVED_SELF_REF", "DERIVED_SELF_REF");
    private static final ReferenceType[] VALUES_ARRAY = new ReferenceType[]{SYSTEM_GENERATED_LITERAL, USER_GENERATED_LITERAL, DERIVED_SELF_REF_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ReferenceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReferenceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReferenceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReferenceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReferenceType get(int value) {
        switch (value) {
            case 0: {
                return SYSTEM_GENERATED_LITERAL;
            }
            case 1: {
                return USER_GENERATED_LITERAL;
            }
            case 2: {
                return DERIVED_SELF_REF_LITERAL;
            }
        }
        return null;
    }

    private ReferenceType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

