/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.java.EscapedTextUtil;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPIncludeRegionHelper;
import org.eclipse.jst.jsp.core.internal.java.StackMap;
import org.eclipse.jst.jsp.core.internal.java.XMLJSPRegionHelper;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelper;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibHelperManager;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibVariable;
import org.eclipse.jst.jsp.core.jspel.IJSPELTranslator;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMDocumentTracker;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JSPTranslator {
    private static final String EL_TRANSLATOR_EXTENSION_NAME = "elTranslator";
    private static final String ELTRANSLATOR_PROP_NAME = "ELTranslator";
    private static final String DEFAULT_JSP_EL_TRANSLATOR_ID = "org.eclipse.jst.jsp.defaultJSP20";
    private static final String JSP_CORE_PLUGIN_ID = "org.eclipse.jst.jsp.core";
    private static final boolean DEBUG;
    private static final boolean DEBUG_SAVE_OUTPUT;
    private IJSPELTranslator fELTranslator = null;
    public static final String ENDL = "\n";
    private String fClassHeader = "public class _JSPServlet extends ";
    private String fClassname = "_JSPServlet";
    private String fImplicitImports = "import javax.servlet.*;\nimport javax.servlet.http.*;\nimport javax.servlet.jsp.*;\n\n";
    private String fServiceHeader = "public void _jspService(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response)\n\t\tthrows java.io.IOException, javax.servlet.ServletException {\njavax.servlet.jsp.PageContext pageContext = null;\njavax.servlet.ServletContext application = null;\njavax.servlet.ServletConfig config = null;\njavax.servlet.jsp.JspWriter out = null;\nObject page = null;\n";
    private String fSessionVariableDeclaration = "javax.servlet.http.HttpSession session = null;\n";
    private String fFooter = "}}";
    private String fException = "Throwable exception = null;";
    public static final String EXPRESSION_PREFIX = "out.print(\"\"+";
    public static final String EXPRESSION_SUFFIX = ");";
    private String fSuperclass = "javax.servlet.http.HttpServlet";
    private String fTryCatchStart = "\ntry {\n";
    private String fTryCatchEnd = " } catch (java.lang.Exception e) {} \n";
    private int fSourcePosition = -1;
    private int fRelativeOffset = -1;
    private int fCursorPosition = -1;
    private boolean fIsErrorPage;
    private boolean fCursorInExpression = false;
    private boolean fIsInASession = true;
    private StringBuffer fUserCode = new StringBuffer();
    private StringBuffer fUserELExpressions = new StringBuffer();
    private StringBuffer fUserDeclarations = new StringBuffer();
    private StringBuffer fUserImports = new StringBuffer();
    private StackMap fTagToVariableMap = null;
    private StringBuffer fResult;
    private StringBuffer fCursorOwner = null;
    private IDOMModel fStructuredModel = null;
    private IStructuredDocument fStructuredDocument = null;
    private IStructuredDocumentRegion fCurrentNode;
    private boolean fInCodeRegion = false;
    protected static final int STANDARD_JSP = 0;
    protected static final int EMBEDDED_JSP = 1;
    protected static final int DECLARATION = 2;
    protected static final int EXPRESSION = 4;
    protected static final int SCRIPTLET = 8;
    private Stack fIncludes = null;
    private ArrayList fBlockMarkers = null;
    private int fOffsetInUserImports = 0;
    private int fOffsetInUserDeclarations = 0;
    private int fOffsetInUserCode = 0;
    private HashMap fJava2JspRanges = new HashMap();
    private HashMap fImportRanges = new HashMap();
    private HashMap fCodeRanges = new HashMap();
    private HashMap fDeclarationRanges = new HashMap();
    private HashMap fUseBeanRanges = new HashMap();
    private HashMap fUserELRanges = new HashMap();
    private HashMap fIndirectRanges = new HashMap();
    private IProgressMonitor fProgressMonitor = null;
    private StringBuffer fJspTextBuffer = new StringBuffer();
    private ArrayList fELProblems = new ArrayList();
    private String fELTranslatorID;
    private int fLastJSPType = 8;

    static {
        DEBUG_SAVE_OUTPUT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jsptranslationstodisk"));
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspjavamapping");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    private void configure(IDOMNode node, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        this.fStructuredModel = node.getModel();
        String baseLocation = this.fStructuredModel.getBaseLocation();
        this.fELTranslatorID = this.getELTranslatorProperty(baseLocation);
        this.fStructuredDocument = this.fStructuredModel.getStructuredDocument();
        String className = this.createClassname(node);
        if (className.length() > 0) {
            this.setClassname(className);
            this.fClassHeader = "public class " + className + " extends ";
        }
    }

    private void configure(IFile jspFile, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
        this.fELTranslatorID = this.getELTranslatorProperty(jspFile);
        String className = this.createClassname(jspFile);
        if (className.length() > 0) {
            this.setClassname(className);
            this.fClassHeader = "public class " + className + " extends ";
        }
    }

    private void setJspText(IFile jspFile) {
        try {
            BufferedInputStream in = new BufferedInputStream(jspFile.getContents());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.fJspTextBuffer.append(line);
                this.fJspTextBuffer.append(ENDL);
            }
            reader.close();
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private String getELTranslatorProperty(String baseLocation) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String elTranslatorValue = null;
        IFile file = workspaceRoot.getFile((IPath)new Path(baseLocation));
        if (file != null) {
            elTranslatorValue = this.getELTranslatorProperty(file);
        }
        return elTranslatorValue;
    }

    private String getELTranslatorProperty(IFile file) {
        String elTranslatorValue = null;
        if (file != null && file.exists()) {
            try {
                elTranslatorValue = file.getPersistentProperty(new QualifiedName(JSP_CORE_PLUGIN_ID, ELTRANSLATOR_PROP_NAME));
                if (elTranslatorValue == null) {
                    elTranslatorValue = file.getProject().getPersistentProperty(new QualifiedName(JSP_CORE_PLUGIN_ID, ELTRANSLATOR_PROP_NAME));
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return elTranslatorValue;
    }

    private String createClassname(IDOMNode node) {
        String classname = "";
        if (node != null) {
            String base = node.getModel().getBaseLocation();
            classname = JSP2ServletNameUtil.mangle(base);
        }
        return classname;
    }

    private String createClassname(IFile jspFile) {
        String classname = "";
        if (jspFile != null) {
            classname = JSP2ServletNameUtil.mangle(jspFile.getFullPath().toString());
        }
        return classname;
    }

    public void setClassname(String classname) {
        this.fClassname = classname;
    }

    public String getClassname() {
        return this.fClassname != null ? this.fClassname : "GenericJspServlet";
    }

    public void reset(IDOMNode node, IProgressMonitor progress) {
        this.configure(node, progress);
        this.reset();
        this.fJspTextBuffer.append(this.fStructuredDocument.get());
    }

    public void reset(IFile jspFile, IProgressMonitor progress) {
        this.configure(jspFile, progress);
        this.reset();
        this.setJspText(jspFile);
    }

    private void reset() {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.setCanceled(false);
        }
        this.fSourcePosition = -1;
        this.fRelativeOffset = -1;
        this.fCursorPosition = -1;
        this.fCursorInExpression = false;
        this.fIsErrorPage = false;
        this.fIsInASession = true;
        this.fUserCode = new StringBuffer();
        this.fUserDeclarations = new StringBuffer();
        this.fUserImports = new StringBuffer();
        this.fUserELExpressions = new StringBuffer();
        this.fResult = null;
        this.fCursorOwner = null;
        this.fCurrentNode = null;
        this.fInCodeRegion = false;
        if (this.fIncludes != null) {
            this.fIncludes.clear();
        }
        this.fBlockMarkers = null;
        this.fOffsetInUserImports = 0;
        this.fOffsetInUserDeclarations = 0;
        this.fOffsetInUserCode = 0;
        this.fJava2JspRanges.clear();
        this.fImportRanges.clear();
        this.fCodeRanges.clear();
        this.fUseBeanRanges.clear();
        this.fDeclarationRanges.clear();
        this.fUserELRanges.clear();
        this.fIndirectRanges.clear();
        this.fJspTextBuffer = new StringBuffer();
        this.fELProblems = new ArrayList();
    }

    public final StringBuffer getEmptyTranslation() {
        this.reset();
        this.buildResult();
        return this.getTranslation();
    }

    private final void buildResult() {
        this.fResult = new StringBuffer(this.fImplicitImports.length() + this.fUserImports.length() + this.fClassHeader.length() + this.fUserDeclarations.length() + this.fServiceHeader.length() + this.fTryCatchStart.length() + this.fUserCode.length() + this.fTryCatchEnd.length() + this.fFooter.length());
        int javaOffset = 0;
        this.fResult.append(this.fImplicitImports);
        this.updateRanges(this.fImportRanges, javaOffset += this.fImplicitImports.length());
        this.append(this.fUserImports);
        javaOffset += this.fUserImports.length();
        this.fResult.append(this.fClassHeader);
        javaOffset += this.fClassHeader.length();
        this.fResult.append(String.valueOf(this.fSuperclass) + "{" + ENDL);
        this.updateRanges(this.fDeclarationRanges, javaOffset += this.fSuperclass.length() + 2);
        this.append(this.fUserDeclarations);
        this.updateRanges(this.fUserELRanges, javaOffset += this.fUserDeclarations.length());
        this.append(this.fUserELExpressions);
        javaOffset += this.fUserELExpressions.length();
        this.fResult.append(this.fServiceHeader);
        javaOffset += this.fServiceHeader.length();
        if (this.fIsErrorPage) {
            this.fResult.append(this.fException);
            javaOffset += this.fException.length();
        }
        if (this.fIsInASession) {
            this.fResult.append(this.fSessionVariableDeclaration);
            javaOffset += this.fSessionVariableDeclaration.length();
        }
        this.fResult.append(this.fTryCatchStart);
        this.updateRanges(this.fCodeRanges, javaOffset += this.fTryCatchStart.length());
        this.append(this.fUserCode);
        javaOffset += this.fUserCode.length();
        this.fResult.append(this.fTryCatchEnd);
        javaOffset += this.fTryCatchEnd.length();
        this.fResult.append(this.fFooter);
        javaOffset += this.fFooter.length();
        this.fJava2JspRanges.putAll(this.fImportRanges);
        this.fJava2JspRanges.putAll(this.fDeclarationRanges);
        this.fJava2JspRanges.putAll(this.fCodeRanges);
        this.fJava2JspRanges.putAll(this.fUserELRanges);
    }

    private void updateRanges(HashMap rangeMap, int offsetInJava) {
        Iterator it = rangeMap.keySet().iterator();
        while (it.hasNext()) {
            ((Position)it.next()).offset += offsetInJava;
        }
    }

    public HashMap getJava2JspRanges() {
        return this.fJava2JspRanges;
    }

    public HashMap getJsp2JavaRanges() {
        if (this.fJava2JspRanges == null) {
            return null;
        }
        HashMap flipFlopped = new HashMap();
        Iterator keys = this.fJava2JspRanges.keySet().iterator();
        Object range = null;
        while (keys.hasNext()) {
            range = keys.next();
            flipFlopped.put(this.fJava2JspRanges.get(range), range);
        }
        return flipFlopped;
    }

    public HashMap getJava2JspImportRanges() {
        return this.fImportRanges;
    }

    public HashMap getJava2JspUseBeanRanges() {
        return this.fUseBeanRanges;
    }

    public HashMap getJava2JspIndirectRanges() {
        return this.fIndirectRanges;
    }

    protected void addImports(String value) {
        this.addImports(value, true);
    }

    protected void addImports(String value, boolean addToMap) {
        StringTokenizer st = new StringTokenizer(value, ",", false);
        String tok = "";
        while (st.hasMoreTokens()) {
            tok = st.nextToken();
            this.appendImportToBuffer(tok, (ITextRegionCollection)this.fCurrentNode, addToMap);
        }
    }

    protected void append(StringBuffer buf) {
        if (this.getCursorOwner() == buf) {
            this.fCursorPosition = this.fResult.length() + this.getRelativeOffset();
        }
        this.fResult.append(buf.toString());
    }

    public final StringBuffer getTranslation() {
        if (DEBUG) {
            StringBuffer debugString = new StringBuffer();
            try {
                Iterator it = this.fJava2JspRanges.keySet().iterator();
                while (it.hasNext()) {
                    debugString.append("--------------------------------------------------------------\n");
                    Position java = (Position)it.next();
                    debugString.append("Java range:[" + java.offset + ":" + java.length + "]\n");
                    debugString.append("[" + this.fResult.toString().substring(java.offset, java.offset + java.length) + "]\n");
                    debugString.append("--------------------------------------------------------------\n");
                    debugString.append("|maps to...|\n");
                    debugString.append("==============================================================\n");
                    Position jsp = (Position)this.fJava2JspRanges.get(java);
                    debugString.append("JSP range:[" + jsp.offset + ":" + jsp.length + "]\n");
                    debugString.append("[" + this.fJspTextBuffer.toString().substring(jsp.offset, jsp.offset + jsp.length) + "]\n");
                    debugString.append("==============================================================\n");
                    debugString.append(ENDL);
                    debugString.append(ENDL);
                }
            }
            catch (Exception e) {
                Logger.logException("JSPTranslation error", e);
            }
            Logger.log(201, debugString.toString());
        }
        if (DEBUG_SAVE_OUTPUT) {
            IProject project = this.getFile().getProject();
            String shortenedClassname = StringUtils.replace((String)this.getFile().getName(), (String)".", (String)"_");
            String filename = String.valueOf(shortenedClassname) + ".java";
            IPath path = project.getFullPath().append("src/" + filename);
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
                }
                ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
                textFileBufferManager.connect(path, (IProgressMonitor)new NullProgressMonitor());
                ITextFileBuffer javaOutputBuffer = textFileBufferManager.getTextFileBuffer(path);
                javaOutputBuffer.getDocument().set(StringUtils.replace((String)this.fResult.toString(), (String)this.getClassname(), (String)shortenedClassname));
                javaOutputBuffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
                textFileBufferManager.disconnect(path, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            System.out.println("Updated translation: " + path);
        }
        return this.fResult;
    }

    public final String getJspText() {
        return this.fJspTextBuffer.toString();
    }

    protected void addTaglibVariables(String tagToAdd) {
        this.addTaglibVariables(tagToAdd, (ITextRegionCollection)this.getCurrentNode());
    }

    protected void addTaglibVariables(String tagToAdd, ITextRegionCollection customTag) {
        block13: {
            TaglibVariable[] taglibVars;
            String decl;
            block12: {
                IFile f = this.getFile();
                if (f == null || !f.exists()) {
                    return;
                }
                TaglibHelper helper = TaglibHelperManager.getInstance().getTaglibHelper(f);
                decl = "";
                if (!customTag.getFirstRegion().getType().equals("XML_TAG_OPEN")) break block12;
                TaglibVariable[] taglibVars2 = helper.getTaglibVariables(tagToAdd, this.getStructuredDocument(), customTag);
                this.fTagToVariableMap.push(tagToAdd, taglibVars2);
                int i = 0;
                while (i < taglibVars2.length) {
                    if (taglibVars2[i].getScope() == 1) {
                        decl = taglibVars2[i].getDeclarationString();
                        this.appendToBuffer(decl, this.fUserCode, false, customTag);
                    }
                    ++i;
                }
                StringBuffer text = new StringBuffer();
                text.append("{ // <");
                text.append(tagToAdd);
                if (customTag.getLastRegion().getType().equals("XML_EMPTY_TAG_CLOSE")) {
                    text.append("/>\n");
                } else {
                    text.append(">\n");
                }
                this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
                int i2 = 0;
                while (i2 < taglibVars2.length) {
                    if (taglibVars2[i2].getScope() == 0) {
                        decl = taglibVars2[i2].getDeclarationString();
                        this.appendToBuffer(decl, this.fUserCode, false, customTag);
                    }
                    ++i2;
                }
                if (!customTag.getLastRegion().getType().equals("XML_EMPTY_TAG_CLOSE")) break block13;
                text = new StringBuffer();
                text.append("} // <");
                text.append(tagToAdd);
                text.append("/>\n");
                this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
                this.fTagToVariableMap.pop(tagToAdd);
                i2 = 0;
                while (i2 < taglibVars2.length) {
                    if (taglibVars2[i2].getScope() == 2) {
                        decl = taglibVars2[i2].getDeclarationString();
                        this.appendToBuffer(decl, this.fUserCode, false, customTag);
                    }
                    ++i2;
                }
                break block13;
            }
            if (customTag.getFirstRegion().getType().equals("XML_END_TAG_OPEN") && (taglibVars = (TaglibVariable[])this.fTagToVariableMap.pop(tagToAdd)) != null) {
                StringBuffer text = new StringBuffer();
                text.append("} // </");
                text.append(tagToAdd);
                text.append(">\n");
                this.appendToBuffer(text.toString(), this.fUserCode, false, customTag);
                int i = 0;
                while (i < taglibVars.length) {
                    if (taglibVars[i].getScope() == 2) {
                        decl = taglibVars[i].getDeclarationString();
                        this.appendToBuffer(decl, this.fUserCode, false, customTag);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private IFile getFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 60->63)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List getBlockMarkers() {
        if (this.fBlockMarkers == null) {
            this.fBlockMarkers = new ArrayList();
        }
        return this.fBlockMarkers;
    }

    public void translate() {
        if (this.fTagToVariableMap == null) {
            this.fTagToVariableMap = new StackMap();
        }
        this.setCurrentNode(this.fStructuredDocument.getFirstStructuredDocumentRegion());
        while (this.getCurrentNode() != null && !this.isCanceled()) {
            if (this.getCurrentNode().getType() == "XML_COMMENT_TEXT" || this.getCurrentNode().getType() == "XML_CDATA_TEXT" || this.getCurrentNode().getType() == "UNDEFINED") {
                this.translateXMLCommentNode(this.getCurrentNode());
            } else {
                this.translateRegionContainer((ITextRegionCollection)this.getCurrentNode(), 0);
            }
            if (this.getCurrentNode() == null) continue;
            this.advanceNextNode();
        }
        int size = this.fTagToVariableMap.size();
        int i = 0;
        while (i < size) {
            this.appendToBuffer("}", this.fUserCode, false, (ITextRegionCollection)this.fStructuredDocument.getLastStructuredDocumentRegion());
            ++i;
        }
        this.fTagToVariableMap.clear();
        this.buildResult();
    }

    /*
     * Exception decompiling
     */
    protected void setDocumentContent(IDocument document, InputStream contentStream, String charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 124->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCanceled() {
        return this.fProgressMonitor == null ? false : this.fProgressMonitor.isCanceled();
    }

    private void advanceNextNode() {
        this.setCurrentNode(this.getCurrentNode().getNext());
        if (this.getCurrentNode() != null) {
            this.setSourceReferencePoint();
        }
    }

    private void setSourceReferencePoint() {
        if (this.isJSP(this.getCurrentNode().getFirstRegion().getType())) {
            Iterator it = this.getCurrentNode().getRegions().iterator();
            ITextRegion r = null;
            while (it.hasNext()) {
                r = (ITextRegion)it.next();
                if (r.getType() == "JSP_CONTENT" || r.getType() == "XML_CONTENT" || r.getType() == "JSP_DIRECTIVE_NAME" || r.getType() == "XML_TAG_ATTRIBUTE_VALUE" && this.getCurrentNode().getFullText(r).trim().equals("import")) break;
            }
        }
    }

    protected void translateRegionContainer(ITextRegionCollection container, int JSPType) {
        ITextRegionCollection containerRegion = container;
        this.handleScopingIfNecessary(containerRegion);
        Iterator regions = containerRegion.getRegions().iterator();
        ITextRegion region = null;
        while (regions.hasNext()) {
            region = (ITextRegion)regions.next();
            String type = region.getType();
            if ("BLOCK_TEXT".equals(type)) {
                if (region instanceof ITextRegionContainer) {
                    Iterator regionIterator = ((ITextRegionCollection)region).getRegions().iterator();
                    this.translateJSPNode(region, regionIterator, type, 1);
                } else {
                    this.decodeScriptBlock(containerRegion.getFullText(region), containerRegion.getStartOffset());
                }
            }
            if (type != null && this.isJSP(type)) {
                this.translateJSPNode((ITextRegion)containerRegion, regions, type, JSPType);
                continue;
            }
            if (type == null || type != "XML_TAG_OPEN" && type != "XML_END_TAG_OPEN") continue;
            this.translateXMLNode(containerRegion, regions);
        }
    }

    private void handleScopingIfNecessary(ITextRegionCollection containerRegion) {
    }

    private void startScope() {
        StringBuffer text = new StringBuffer();
        text.append("{ // <");
        text.append(this.getRegionName((ITextRegionCollection)this.fCurrentNode));
        text.append(">\n");
        this.appendToBuffer(text.toString(), this.fUserCode, false, (ITextRegionCollection)this.fCurrentNode);
    }

    private void endScope() {
        StringBuffer text = new StringBuffer();
        text.append("} // </");
        text.append(this.getRegionName((ITextRegionCollection)this.fCurrentNode));
        text.append(">\n");
        this.appendToBuffer(text.toString(), this.fUserCode, false, (ITextRegionCollection)this.fCurrentNode);
    }

    private boolean isSelfClosingTag(ITextRegionCollection containerRegion) {
        if (containerRegion == null) {
            return false;
        }
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion r = regions.get(regions.size() - 1);
        return r.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private boolean isCustomTag(ITextRegionCollection containerRegion) {
        String tagName = this.getRegionName(containerRegion);
        if (tagName == null) {
            return false;
        }
        return tagName.indexOf(":") > 0 && !tagName.startsWith("jsp:");
    }

    private String getRegionName(ITextRegionCollection containerRegion) {
        ITextRegionList regions = containerRegion.getRegions();
        ITextRegion nameRegion = null;
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameRegion = r;
                break;
            }
            ++i;
        }
        return nameRegion != null ? containerRegion.getText(nameRegion).trim() : null;
    }

    void decodeScriptBlock(String blockText, int startOfBlock) {
        XMLJSPRegionHelper helper = new XMLJSPRegionHelper(this, false);
        helper.addBlockMarker(new BlockMarker("jsp:scriptlet", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:expression", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:declaration", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:directive.include", null, "JSP_CONTENT", false));
        helper.addBlockMarker(new BlockMarker("jsp:directive.taglib", null, "JSP_CONTENT", false));
        helper.reset(blockText);
        helper.forceParse();
    }

    public final String stripCDATA(String text) {
        String resultText = "";
        String CDATA_OPEN = "<![CDATA[";
        String CDATA_CLOSE = "]]>";
        int start = 0;
        int end = text.length();
        while (start < text.length()) {
            if (text.indexOf(CDATA_OPEN, start) > -1) {
                end = text.indexOf(CDATA_OPEN, start);
                resultText = String.valueOf(resultText) + text.substring(start, end);
                start = end + CDATA_OPEN.length();
                continue;
            }
            if (text.indexOf(CDATA_CLOSE, start) > -1) {
                end = text.indexOf(CDATA_CLOSE, start);
                resultText = String.valueOf(resultText) + text.substring(start, end);
                start = end + CDATA_CLOSE.length();
                continue;
            }
            end = text.length();
            resultText = String.valueOf(resultText) + text.substring(start, end);
            break;
        }
        return resultText;
    }

    protected boolean isJSP(String type) {
        return (type == "JSP_DIRECTIVE_OPEN" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_DECLARATION_OPEN" || type == "JSP_SCRIPTLET_OPEN" || type == "JSP_CONTENT" || type == "JSP_EL_OPEN") && type != "XML_TAG_OPEN";
    }

    protected void translateXMLNode(ITextRegionCollection container, Iterator regions) {
        ITextRegion r = null;
        if (regions.hasNext() && ((r = (ITextRegion)regions.next()).getType() == "XML_TAG_NAME" || r.getType() == "JSP_DIRECTIVE_NAME")) {
            StringTokenizer st;
            String fullTagName = container.getText(r);
            if (fullTagName.indexOf(58) > -1 && !fullTagName.startsWith("jsp:")) {
                this.addTaglibVariables(fullTagName, container);
            }
            if ((st = new StringTokenizer(fullTagName, ":.", false)).hasMoreTokens() && st.nextToken().equals("jsp")) {
                if (st.hasMoreTokens()) {
                    String jspTagName = st.nextToken();
                    if (jspTagName.equals("scriptlet")) {
                        this.translateXMLJSPContent(8);
                    } else if (jspTagName.equals("expression")) {
                        this.translateXMLJSPContent(4);
                    } else if (jspTagName.equals("declaration")) {
                        this.translateXMLJSPContent(2);
                    } else if (jspTagName.equals("directive")) {
                        if (st.hasMoreTokens()) {
                            String directiveName = st.nextToken();
                            if (directiveName.equals("taglib")) {
                                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                                    String prefix;
                                    r = (ITextRegion)regions.next();
                                    if (!container.getText(r).equals("prefix") || (prefix = this.getAttributeValue(r, regions)) == null) continue;
                                    this.handleTaglib(prefix);
                                }
                                return;
                            }
                            if (directiveName.equals("include")) {
                                String fileLocation = "";
                                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                                    r = (ITextRegion)regions.next();
                                }
                                fileLocation = this.getAttributeValue(r, regions);
                                if (fileLocation != null) {
                                    this.handleIncludeFile(fileLocation);
                                }
                            } else if (directiveName.equals("page") && container != null) {
                                this.translatePageDirectiveAttributes(container, regions);
                            }
                        }
                    } else if (jspTagName.equals("include")) {
                        this.checkAttributeValueContainer(regions, "page");
                    } else if (jspTagName.equals("forward")) {
                        this.checkAttributeValueContainer(regions, "page");
                    } else if (jspTagName.equals("param")) {
                        this.checkAttributeValueContainer(regions, "value");
                    } else if (jspTagName.equals("setProperty")) {
                        this.checkAttributeValueContainer(regions, "value");
                    } else if (jspTagName.equals("useBean")) {
                        this.checkAttributeValueContainer(regions, "name");
                        if (this.getCurrentNode() != null) {
                            this.translateUseBean(container);
                        }
                    }
                }
            } else {
                this.checkAllAttributeValueContainers(regions);
            }
        }
    }

    private void checkAllAttributeValueContainers(Iterator regions) {
        ITextRegion embedded = null;
        while (regions.hasNext()) {
            embedded = (ITextRegion)regions.next();
            if (!(embedded instanceof ITextRegionContainer)) continue;
            this.translateEmbeddedJSPInAttribute((ITextRegionCollection)((ITextRegionContainer)embedded));
        }
    }

    private void checkAttributeValueContainer(Iterator regions, String attrName) {
        ITextRegion r = null;
        while (regions.hasNext()) {
            r = (ITextRegion)regions.next();
            if (r.getType() != "XML_TAG_ATTRIBUTE_NAME" || !this.getCurrentNode().getText(r).equals(attrName)) continue;
            while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null) {
                if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") break;
            }
            if (!(r instanceof ContextRegionContainer)) break;
            this.translateEmbeddedJSPInAttribute((ITextRegionCollection)((ContextRegionContainer)r));
            break;
        }
    }

    private void translateXMLJSPContent(int type) {
        IStructuredDocumentRegion sdr = this.getCurrentNode().getNext();
        int start = sdr.getStartOffset();
        int end = sdr.getEndOffset();
        String sdrText = "";
        while (sdr != null && sdr.getType() != "XML_TAG_NAME") {
            start = sdr.getStartOffset();
            sdrText = sdr.getText();
            if (sdr.getType() == "XML_CDATA_TEXT") {
                if (sdrText.startsWith("<![CDATA[") && sdrText.endsWith("]]>")) {
                    start = sdr.getStartOffset() + 9;
                    end = sdr.getEndOffset() - 3;
                    sdrText = sdrText.substring(9, sdrText.length() - 3);
                    this.writeToBuffer(type, sdrText, start, end);
                }
            } else {
                sdrText = EscapedTextUtil.getUnescapedText(sdrText);
                end = sdr.getEndOffset();
                this.writeToBuffer(type, sdrText, start, end);
            }
            sdr = sdr.getNext();
        }
        this.setCurrentNode(sdr);
        this.setSourceReferencePoint();
    }

    private void writeToBuffer(int type, String content, int jspStart, int jspEnd) {
        switch (type) {
            case 8: {
                this.translateScriptletString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
                break;
            }
            case 4: {
                this.translateExpressionString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
                break;
            }
            case 2: {
                this.translateDeclarationString(content, (ITextRegionCollection)this.getCurrentNode(), jspStart, jspEnd - jspStart, false);
            }
        }
    }

    protected void translateXMLCommentNode(IStructuredDocumentRegion node) {
        Iterator it = node.getRegions().iterator();
        ITextRegion commentRegion = null;
        while (it != null && it.hasNext()) {
            commentRegion = (ITextRegion)it.next();
            if (commentRegion instanceof ITextRegionContainer) {
                this.translateRegionContainer((ITextRegionCollection)((ITextRegionContainer)commentRegion), 1);
                continue;
            }
            if (!"XML_COMMENT_TEXT".equals(commentRegion.getType())) continue;
            this.decodeScriptBlock(node.getFullText(commentRegion), node.getStartOffset(commentRegion));
        }
    }

    protected void translateJSPNode(ITextRegion region, Iterator regions, String type, int JSPType) {
        if (type == "JSP_DIRECTIVE_OPEN" && regions != null) {
            this.translateDirective((ITextRegionCollection)this.fCurrentNode, regions);
        } else {
            IStructuredDocumentRegion contentRegion = null;
            if (JSPType == 0 && this.setCurrentNode(this.getCurrentNode().getNext()) != null) {
                contentRegion = this.getCurrentNode();
            } else if (JSPType == 1 && region instanceof ITextRegionCollection) {
                this.translateEmbeddedJSPInBlock((ITextRegionCollection)region, regions);
                contentRegion = null;
            }
            if (contentRegion != null) {
                if (type == "JSP_EXPRESSION_OPEN") {
                    this.translateExpression((ITextRegionCollection)contentRegion);
                } else if (type == "JSP_DECLARATION_OPEN") {
                    this.translateDeclaration((ITextRegionCollection)contentRegion);
                } else if (type == "JSP_CONTENT" || type == "JSP_SCRIPTLET_OPEN") {
                    this.translateScriptlet((ITextRegionCollection)contentRegion);
                }
            } else {
                this.setCursorOwner(this.getJSPTypeForRegion(region));
            }
        }
    }

    private void translateEL(String elText, String delim, IStructuredDocumentRegion currentNode, int contentStart, int contentLength) {
        IJSPELTranslator translator = this.getELTranslator();
        if (translator != null) {
            translator.translateEL(elText, delim, currentNode, contentStart, contentLength, this.fUserELExpressions, this.fUserELRanges, this.fStructuredDocument);
        }
    }

    public IJSPELTranslator getELTranslator() {
        if (this.fELTranslator == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JSP_CORE_PLUGIN_ID, EL_TRANSLATOR_EXTENSION_NAME);
            IConfigurationElement bestTranslator = null;
            IExtension[] extensions = extensionPoint.getExtensions();
            int curExtension = 0;
            while (curExtension < extensions.length) {
                IExtension extension = extensions[curExtension];
                IConfigurationElement[] translators = extension.getConfigurationElements();
                int curTranslator = 0;
                while (curTranslator < translators.length) {
                    String idString;
                    IConfigurationElement elTranslator = translators[curTranslator];
                    if (EL_TRANSLATOR_EXTENSION_NAME.equals(elTranslator.getName()) && ((idString = elTranslator.getAttribute("id")) != null && idString.equals(this.fELTranslatorID) || bestTranslator == null && DEFAULT_JSP_EL_TRANSLATOR_ID.equals(idString))) {
                        bestTranslator = elTranslator;
                    }
                    ++curTranslator;
                }
                ++curExtension;
            }
            if (bestTranslator != null) {
                try {
                    Object execExt = bestTranslator.createExecutableExtension("class");
                    if (execExt instanceof IJSPELTranslator) {
                        this.fELTranslator = (IJSPELTranslator)execExt;
                        return this.fELTranslator;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return this.fELTranslator;
    }

    private void translateEmbeddedJSPInBlock(ITextRegionCollection collection, Iterator regions) {
        ITextRegion region = null;
        while (regions.hasNext()) {
            region = (ITextRegion)regions.next();
            if (this.isJSP(region.getType())) break;
            region = null;
        }
        if (region != null) {
            this.translateEmbeddedJSPInAttribute(collection);
            while (regions.hasNext()) {
                regions.next();
            }
        }
    }

    private void translateEmbeddedJSPInAttribute(ITextRegionCollection embeddedContainer) {
        ITextRegionList embeddedRegions = embeddedContainer.getRegions();
        ITextRegion delim = null;
        ITextRegion content = null;
        String type = null;
        String quotetype = null;
        if (embeddedRegions.get(0).getType() == "JSP_DIRECTIVE_OPEN") {
            Iterator iterator = embeddedRegions.iterator();
            iterator.next();
            this.translateDirective(embeddedContainer, iterator);
        } else {
            int i = 0;
            while (i < embeddedRegions.size()) {
                String regionType;
                delim = embeddedRegions.get(i);
                type = delim.getType();
                if (type == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || type == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" || type == "JSP_TAG_ATTRIBUTE_VALUE_DQUOTE" || type == "JSP_TAG_ATTRIBUTE_VALUE_SQUOTE") {
                    quotetype = type;
                }
                if (i + 1 < embeddedRegions.size() && ((regionType = embeddedRegions.get(i + 1).getType()) == "JSP_CONTENT" || regionType == "JSP_EL_CONTENT")) {
                    content = embeddedRegions.get(i + 1);
                }
                if (content != null) {
                    boolean inThisRegion;
                    int contentStart = embeddedContainer.getStartOffset(content);
                    int rStart = this.fCurrentNode.getStartOffset() + contentStart;
                    int rEnd = this.fCurrentNode.getStartOffset() + embeddedContainer.getEndOffset(content);
                    boolean bl = inThisRegion = rStart <= this.fSourcePosition && rEnd >= this.fSourcePosition;
                    if (type == "JSP_EXPRESSION_OPEN") {
                        this.fLastJSPType = 4;
                        this.translateExpressionString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), quotetype);
                    } else if (type == "JSP_SCRIPTLET_OPEN") {
                        this.fLastJSPType = 8;
                        this.translateScriptletString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), false);
                    } else if (type == "JSP_DECLARATION_OPEN") {
                        this.fLastJSPType = 2;
                        this.translateDeclarationString(embeddedContainer.getText(content), embeddedContainer, contentStart, content.getLength(), false);
                    } else if (type == "JSP_EL_OPEN") {
                        this.fLastJSPType = 4;
                        this.translateEL(embeddedContainer.getText(content), embeddedContainer.getText(delim), this.fCurrentNode, contentStart, content.getLength());
                    }
                    if (inThisRegion) {
                        this.setCursorOwner(this.fLastJSPType);
                        int currentBufferLength = this.getCursorOwner().length();
                        this.setRelativeOffset(this.fSourcePosition - contentStart + currentBufferLength);
                        if (this.fLastJSPType == 4) {
                            this.setCursorInExpression(true);
                            this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                        }
                    }
                } else {
                    type = null;
                    content = null;
                }
                ++i;
            }
        }
    }

    private int getJSPTypeForRegion(ITextRegion region) {
        String regionType = region.getType();
        int type = 8;
        if (regionType == "JSP_SCRIPTLET_OPEN") {
            type = 8;
        } else if (regionType == "JSP_EXPRESSION_OPEN") {
            type = 4;
        } else if (regionType == "JSP_DECLARATION_OPEN") {
            type = 2;
        } else if (regionType == "JSP_CONTENT") {
            type = this.fLastJSPType;
        }
        this.fLastJSPType = type;
        return type;
    }

    protected void translateDirective(ITextRegionCollection container, Iterator regions) {
        ITextRegion r = null;
        String attrValue = "";
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "JSP_DIRECTIVE_NAME") {
            String regionText = container.getText(r);
            if (regionText.indexOf("taglib") > -1) {
                this.handleTaglib();
                return;
            }
            if (regionText.equals("include")) {
                String fileLocation = "";
                while (r != null && regions.hasNext() && !r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                    r = (ITextRegion)regions.next();
                }
                fileLocation = this.getAttributeValue(r, regions, container);
                if (attrValue == null) continue;
                this.handleIncludeFile(fileLocation);
                continue;
            }
            if (regionText.indexOf("page") <= -1) continue;
            this.translatePageDirectiveAttributes(container, regions);
        }
    }

    protected void handleTaglib() {
        TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
        if (mgr != null) {
            List trackers = mgr.getCMDocumentTrackers(this.getCurrentNode().getEnd());
            Iterator it = trackers.iterator();
            CMDocumentTracker tracker = null;
            Iterator taglibRegions = null;
            IStructuredDocumentRegion sdRegion = null;
            ITextRegion r = null;
            while (it.hasNext()) {
                tracker = (CMDocumentTracker)it.next();
                sdRegion = tracker.getStructuredDocumentRegion();
                if (sdRegion == null || sdRegion.isDeleted()) continue;
                taglibRegions = sdRegion.getRegions().iterator();
                while (sdRegion != null && !sdRegion.isDeleted() && taglibRegions.hasNext()) {
                    r = (ITextRegion)taglibRegions.next();
                    if (!r.getType().equals("JSP_DIRECTIVE_NAME") || !sdRegion.getText(r).equals("taglib")) continue;
                    this.addBlockMarkers(tracker.getDocument());
                }
            }
        }
    }

    private void handleTaglib(String prefix) {
        TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
        if (mgr != null) {
            List trackers = mgr.getCMDocumentTrackers(this.getCurrentNode().getEnd());
            Iterator it = trackers.iterator();
            CMDocumentTracker tracker = null;
            while (it.hasNext()) {
                tracker = (CMDocumentTracker)it.next();
                this.addBlockMarkers(String.valueOf(prefix) + ":", tracker.getDocument());
            }
        }
    }

    protected void addBlockMarkers(CMDocument doc) {
        if (doc.getElements().getLength() > 0) {
            Iterator elements = doc.getElements().iterator();
            CMNode node = null;
            while (elements.hasNext()) {
                node = (CMNode)elements.next();
                this.getBlockMarkers().add(new BlockMarker(node.getNodeName(), null, "JSP_CONTENT", true));
            }
        }
    }

    protected void addBlockMarkers(String prefix, CMDocument doc) {
        if (doc.getElements().getLength() > 0) {
            Iterator elements = doc.getElements().iterator();
            CMNode node = null;
            while (elements.hasNext()) {
                node = (CMNode)elements.next();
                if (node instanceof TLDElementDeclaration && ((TLDElementDeclaration)node).getBodycontent().equals("tagdependent")) {
                    this.getBlockMarkers().add(new BlockMarker(String.valueOf(prefix) + node.getNodeName(), null, "BLOCK_TEXT", true));
                    continue;
                }
                this.getBlockMarkers().add(new BlockMarker(String.valueOf(prefix) + node.getNodeName(), null, "JSP_CONTENT", true));
            }
        }
    }

    protected String getAttributeValue(ITextRegion r, Iterator remainingRegions) {
        return this.getAttributeValue(r, remainingRegions, (ITextRegionCollection)this.getCurrentNode());
    }

    protected String getAttributeValue(ITextRegion r, Iterator remainingRegions, ITextRegionCollection container) {
        if (r.getType().equals("XML_TAG_ATTRIBUTE_NAME") && remainingRegions.hasNext() && (r = (ITextRegion)remainingRegions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && remainingRegions.hasNext() && (r = (ITextRegion)remainingRegions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
            return StringUtils.stripQuotes((String)container.getText(r));
        }
        return null;
    }

    protected void translatePageDirectiveAttributes(ITextRegionCollection container, Iterator regions) {
        ITextRegion r = null;
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() != "JSP_CLOSE") {
            String attrValue = null;
            String attrName = null;
            if (!r.getType().equals("XML_TAG_ATTRIBUTE_NAME") || (attrName = container.getText(r).trim()).length() <= 0) continue;
            if (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValue = StringUtils.strip((String)container.getText(r));
            }
            this.setDirectiveAttribute(attrName, attrValue);
        }
    }

    protected void setDirectiveAttribute(String attrName, String attrValue) {
        if (attrValue == null) {
            return;
        }
        if (attrName.equals("extends")) {
            this.fSuperclass = attrValue;
        } else if (attrName.equals("import")) {
            this.addImports(attrValue);
        } else if (attrName.equals("session")) {
            this.fIsInASession = "true".equalsIgnoreCase(attrValue);
        } else if (!attrName.equals("buffer") && !attrName.equals("autoFlush") && !attrName.equals("isThreadSafe") && attrName.equals("isErrorPage")) {
            this.fIsErrorPage = "true".equalsIgnoreCase(attrValue);
        }
    }

    protected void handleIncludeFile(String filename) {
        if (filename != null) {
            String fileLocation = null;
            fileLocation = this.getResolver() != null ? (this.getIncludes().empty() ? this.getResolver().getLocationByURI(StringUtils.strip((String)filename)) : this.getResolver().getLocationByURI(StringUtils.strip((String)filename), (String)this.getIncludes().peek())) : StringUtils.strip((String)filename);
            if (!this.getIncludes().contains(fileLocation) && this.getBaseLocation() != null && !fileLocation.equals(this.getBaseLocation())) {
                this.getIncludes().push(fileLocation);
                JSPIncludeRegionHelper helper = new JSPIncludeRegionHelper(this, true);
                boolean parsed = helper.parse(fileLocation);
                if (!parsed) {
                    Logger.log(204, "Error: included file " + filename + " not found {" + this.getBaseLocation() + ")");
                }
                this.getIncludes().pop();
            }
        }
    }

    private URIResolver getResolver() {
        return this.fStructuredModel != null ? this.fStructuredModel.getResolver() : null;
    }

    private String getBaseLocation() {
        if (this.getResolver() == null) {
            return null;
        }
        return this.getResolver().getFileBaseLocation();
    }

    private Stack getIncludes() {
        if (this.fIncludes == null) {
            this.fIncludes = new Stack();
        }
        return this.fIncludes;
    }

    protected void translateExpressionString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, embeddedContainer);
        this.appendToBuffer(newText, this.fUserCode, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect);
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, embeddedContainer);
    }

    protected void translateExpressionString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, String quotetype) {
        if (quotetype == null || quotetype == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || quotetype == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE") {
            this.translateExpressionString(newText, embeddedContainer, jspPositionStart, jspPositionLength, false);
            return;
        }
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, embeddedContainer);
        int length = newText.length();
        int runStart = 0;
        int i = 0;
        while (i < length) {
            char c = newText.charAt(i);
            if (c == '\\') {
                int runLength = i - runStart;
                if (runLength > 0) {
                    this.appendToBuffer(newText.substring(runStart, i), this.fUserCode, true, embeddedContainer, jspPositionStart, runLength, true, true);
                    jspPositionStart += runLength + 1;
                    jspPositionLength -= runLength + 1;
                }
                runStart = ++i;
                if (i >= length) break;
                c = newText.charAt(i);
            }
            ++i;
        }
        int runLength = i - runStart;
        if (runLength > 0) {
            this.appendToBuffer(newText.substring(runStart, i), this.fUserCode, true, embeddedContainer, jspPositionStart, runLength, true, false);
        }
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, embeddedContainer);
    }

    protected void translateDeclarationString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, this.fUserDeclarations, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect);
        this.appendToBuffer(ENDL, this.fUserDeclarations, false, embeddedContainer);
    }

    protected void translateScriptletString(String newText, ITextRegionCollection embeddedContainer, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, this.fUserCode, true, embeddedContainer, jspPositionStart, jspPositionLength, isIndirect);
    }

    protected void translateExpression(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 4);
        this.appendToBuffer(EXPRESSION_PREFIX, this.fUserCode, false, region);
        this.appendToBuffer(newText, this.fUserCode, true, region);
        this.appendToBuffer(EXPRESSION_SUFFIX, this.fUserCode, false, region);
    }

    protected void translateDeclaration(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 2);
        this.appendToBuffer(newText, this.fUserDeclarations, true, region);
        this.appendToBuffer(ENDL, this.fUserDeclarations, false, region);
    }

    protected void translateScriptlet(ITextRegionCollection region) {
        String newText = this.getUnescapedRegionText(region, 8);
        this.appendToBuffer(newText, this.fUserCode, true, region);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion) {
        int start = 0;
        int length = 0;
        if (jspReferenceRegion != null) {
            start = jspReferenceRegion.getStartOffset();
            length = jspReferenceRegion.getLength();
        }
        this.appendToBuffer(newText, buffer, addToMap, jspReferenceRegion, start, length, false);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion, int jspPositionStart, int jspPositionLength, boolean isIndirect) {
        this.appendToBuffer(newText, buffer, addToMap, jspReferenceRegion, jspPositionStart, jspPositionLength, isIndirect, false);
    }

    private void appendToBuffer(String newText, StringBuffer buffer, boolean addToMap, ITextRegionCollection jspReferenceRegion, int jspPositionStart, int jspPositionLength, boolean isIndirect, boolean nonl) {
        int origNewTextLength = newText.length();
        if (jspReferenceRegion == null) {
            return;
        }
        if (!nonl && !newText.endsWith(ENDL)) {
            newText = String.valueOf(newText) + ENDL;
        }
        if (buffer == this.fUserCode) {
            buffer.append(newText);
            if (addToMap) {
                if (this.isUsebeanTag(jspReferenceRegion)) {
                    try {
                        this.appendUseBeanToBuffer(newText, jspReferenceRegion, isIndirect);
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                } else {
                    Position javaRange = new Position(this.fOffsetInUserCode, origNewTextLength);
                    Position jspRange = new Position(jspPositionStart, jspPositionLength);
                    this.fCodeRanges.put(javaRange, jspRange);
                    if (isIndirect) {
                        this.fIndirectRanges.put(javaRange, jspRange);
                    }
                }
            }
            this.fOffsetInUserCode += newText.length();
        } else if (buffer == this.fUserDeclarations) {
            buffer.append(newText);
            if (addToMap) {
                Position javaRange = new Position(this.fOffsetInUserDeclarations, newText.length());
                Position jspRange = new Position(jspPositionStart, jspPositionLength);
                this.fDeclarationRanges.put(javaRange, jspRange);
                if (isIndirect) {
                    this.fIndirectRanges.put(javaRange, jspRange);
                }
            }
            this.fOffsetInUserDeclarations += newText.length();
        }
    }

    private boolean isUsebeanTag(ITextRegionCollection jspReferenceRegion) {
        ITextRegionList regions = jspReferenceRegion.getRegions();
        ITextRegion r = null;
        boolean isUseBean = false;
        int i = 0;
        while (i < regions.size()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                if (r.getTextLength() != 11 || !jspReferenceRegion.getText(r).equals("jsp:useBean")) break;
                isUseBean = true;
                break;
            }
            ++i;
        }
        return isUseBean;
    }

    private void appendImportToBuffer(String importName, ITextRegionCollection jspReferenceRegion, boolean addToMap) {
        String javaImportString = "import " + importName + ";" + ENDL;
        this.fUserImports.append(javaImportString);
        if (addToMap) {
            this.addImportToMap(importName, jspReferenceRegion);
        }
        this.fOffsetInUserImports += javaImportString.length();
    }

    private void addImportToMap(String importName, ITextRegionCollection jspReferenceRegion) {
        Position javaRange = new Position(this.fOffsetInUserImports + 7, 1);
        Position jspRange = new Position(jspReferenceRegion.getStart(), jspReferenceRegion.getLength());
        ITextRegionList regions = jspReferenceRegion.getRegions();
        int size = regions.size();
        int start = -1;
        int length = -1;
        ITextRegion r = null;
        int i = 0;
        while (i < size) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && jspReferenceRegion.getText(r).trim().equals("import") && size > i + 2 && (r = regions.get(i + 2)).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                String jspImportText = jspReferenceRegion.getText(r);
                start = jspImportText.indexOf(importName);
                length = importName.length();
                if (start == -1 || length < 1) break;
                jspRange.setOffset(jspReferenceRegion.getStartOffset(r) + start);
                jspRange.setLength(length);
                javaRange.setLength(length);
                break;
            }
            ++i;
        }
        if (start != -1 && length > 1) {
            this.fImportRanges.put(javaRange, jspRange);
        }
    }

    private void appendUseBeanToBuffer(String newText, ITextRegionCollection jspReferenceRegion, boolean isIndirect) throws Exception {
        StringTokenizer st = new StringTokenizer(newText, " ", false);
        int i = 0;
        String[] parsedJava = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            parsedJava[i++] = st.nextToken();
        }
        String type = parsedJava[0] != null ? parsedJava[0] : "";
        String id = parsedJava[1] != null ? parsedJava[1] : "";
        String className = parsedJava.length > 4 ? parsedJava[4] : "";
        Position javaTypeRange = new Position(this.fOffsetInUserCode, type.length());
        Position javaIdRange = new Position(this.fOffsetInUserCode + type.length() + 1, id.length());
        Position javaClassRange = new Position(this.fOffsetInUserCode + type.length() + 1 + id.length() + 7, 0);
        if (className.length() >= 4) {
            int classNameLength = className.substring(0, className.indexOf(40)).length();
            javaClassRange = new Position(this.fOffsetInUserCode + type.length() + 1 + id.length() + 7, classNameLength);
        }
        ITextRegionList regions = jspReferenceRegion.getRegions();
        ITextRegion r = null;
        String attrName = "";
        String attrValue = "";
        int quoteOffset = 0;
        Position jspTypeRange = null;
        Position jspIdRange = null;
        Position jspClassRange = null;
        int j = 0;
        while (j < regions.size()) {
            r = regions.get(j);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = jspReferenceRegion.getText(r);
                if (regions.size() >= j + 2 && regions.get(j + 2).getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    r = regions.get(j + 2);
                    attrValue = jspReferenceRegion.getText(r);
                    int n = quoteOffset = attrValue.startsWith("\"") || attrValue.startsWith("'") ? 1 : 0;
                    if (attrName.equals("type")) {
                        jspTypeRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    } else if (attrName.equals("id")) {
                        jspIdRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    } else if (attrName.equals("class")) {
                        jspClassRange = new Position(jspReferenceRegion.getStartOffset(r) + quoteOffset, StringUtils.stripQuotesLeaveInsideSpace((String)attrValue).length());
                    }
                }
            }
            ++j;
        }
        if (!type.equals("") && jspTypeRange != null) {
            this.fCodeRanges.put(javaTypeRange, jspTypeRange);
            this.fUseBeanRanges.put(javaTypeRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaTypeRange, jspTypeRange);
            }
        }
        if (!id.equals("") && jspIdRange != null) {
            this.fCodeRanges.put(javaIdRange, jspIdRange);
            this.fUseBeanRanges.put(javaIdRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaIdRange, jspTypeRange);
            }
        }
        if (!className.equals("") && jspClassRange != null) {
            this.fCodeRanges.put(javaClassRange, jspClassRange);
            this.fUseBeanRanges.put(javaClassRange, jspTypeRange);
            if (isIndirect) {
                this.fIndirectRanges.put(javaClassRange, jspTypeRange);
            }
        }
    }

    protected void setCursorOwner(int JSPType) {
        switch (JSPType) {
            case 2: {
                this.setCursorOwner(this.fUserDeclarations);
                break;
            }
            case 4: 
            case 8: {
                this.setCursorOwner(this.fUserCode);
                break;
            }
            default: {
                this.setCursorOwner(this.fUserCode);
            }
        }
    }

    protected String getUnescapedRegionText(ITextRegionCollection stRegion, int JSPType) {
        StringBuffer buffer = new StringBuffer();
        int start = stRegion.getStartOffset();
        int end = stRegion.getEndOffset();
        if (stRegion instanceof ITextRegionContainer && stRegion.getType() == "BLOCK_TEXT" && stRegion.getRegions() != null && stRegion.getRegions().size() > 1) {
            ITextRegion jspContent = stRegion.getRegions().get(1);
            start = stRegion.getStartOffset(jspContent);
            end = stRegion.getEndOffset(jspContent);
        }
        int CDATAOffset = 0;
        int bufferSize = 0;
        if (stRegion.getType() == "JSP_CONTENT" || stRegion.getType() == "BLOCK_TEXT" || stRegion.getType() == "XML_TAG_NAME") {
            boolean bl = this.fInCodeRegion = start <= this.fSourcePosition && this.fSourcePosition <= end;
            if (this.fInCodeRegion) {
                this.setCursorOwner(JSPType);
                this.setRelativeOffset(this.fSourcePosition - start + this.getCursorOwner().length());
                if (JSPType == 4) {
                    this.setCursorInExpression(true);
                    this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                }
            }
            ITextRegion jspContent = null;
            if (stRegion.getRegions() != null && stRegion.getRegions().size() > 1) {
                jspContent = stRegion.getRegions().get(1);
            }
            return jspContent != null ? stRegion.getFullText(jspContent) : stRegion.getFullText();
        }
        if (stRegion.getType() == "JSP_CLOSE") {
            this.setCursorOwner(JSPType);
        }
        while (this.getCurrentNode() != null && this.getCurrentNode().getType() != "XML_TAG_NAME") {
            start = this.getCurrentNode().getStartOffset();
            end = this.getCurrentNode().getEndOffset();
            bufferSize = buffer.length();
            CDATAOffset = this.unescapeRegion((ITextRegion)this.getCurrentNode(), buffer);
            boolean bl = this.fInCodeRegion = start <= this.fSourcePosition && this.fSourcePosition <= end;
            if (this.fInCodeRegion) {
                this.setCursorOwner(JSPType);
                this.setRelativeOffset(this.fSourcePosition - this.getCurrentNode().getStartOffset() + this.getCursorOwner().length() - CDATAOffset + bufferSize);
                if (JSPType == 4) {
                    this.setCursorInExpression(true);
                    this.setRelativeOffset(this.getRelativeOffset() + EXPRESSION_PREFIX.length());
                }
            }
            if (this.getCurrentNode() == null) continue;
            this.advanceNextNode();
        }
        return buffer.toString();
    }

    protected int unescapeRegion(ITextRegion r, StringBuffer sb) {
        String s = "";
        int lengthBefore = 0;
        int lengthAfter = 0;
        int cdata_tags_length = 0;
        if (r != null && (r.getType() == "XML_CONTENT" || r.getType() == "XML_ENTITY_REFERENCE")) {
            lengthBefore = this.getCurrentNode() != r ? this.getCurrentNode().getFullText(r).length() : this.getCurrentNode().getFullText().length();
            s = EscapedTextUtil.getUnescapedText(this.getCurrentNode(), r);
            lengthAfter = s.length();
            sb.append(s);
        } else if (r != null && r.getType() == "XML_CDATA_TEXT" && r instanceof ITextRegionContainer) {
            Iterator it = ((ITextRegionContainer)r).getRegions().iterator();
            ITextRegion temp = null;
            while (it.hasNext()) {
                temp = (ITextRegion)it.next();
                if (temp instanceof ITextRegionContainer || temp.getType() == "XML_CDATA_TEXT") {
                    sb.append(this.getCurrentNode().getFullText(temp));
                    continue;
                }
                if (temp.getType() != "XML_CDATA_OPEN" && temp.getType() != "XML_CDATA_CLOSE") continue;
                cdata_tags_length += temp.getLength();
            }
        }
        return lengthBefore - lengthAfter + cdata_tags_length;
    }

    protected void translateUseBean(ITextRegionCollection container) {
        ITextRegion r = null;
        String attrName = null;
        String attrValue = null;
        String id = null;
        String type = null;
        String className = null;
        Iterator regions = container.getRegions().iterator();
        while (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && (r.getType() != "XML_TAG_CLOSE" || r.getType() != "XML_EMPTY_TAG_CLOSE")) {
            attrValue = null;
            attrName = null;
            if (r.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                attrName = container.getText(r).trim();
                if (regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_EQUALS" && regions.hasNext() && (r = (ITextRegion)regions.next()) != null && r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                    attrValue = StringUtils.stripQuotes((String)container.getText(r));
                }
            }
            if (attrName == null || attrValue == null) continue;
            if (attrName.equals("id")) {
                id = attrValue;
                continue;
            }
            if (attrName.equals("class")) {
                className = attrValue;
                continue;
            }
            if (!attrName.equals("type")) continue;
            type = attrValue;
        }
        if (id != null && (type != null || className != null)) {
            if (type == null) {
                type = className;
            }
            String prefix = String.valueOf(type) + " " + id + " = ";
            String suffix = "null;\n";
            if (className != null) {
                suffix = "new " + className + "();" + ENDL;
            }
            this.appendToBuffer(String.valueOf(prefix) + suffix, this.fUserCode, true, container);
        }
    }

    public final int getCursorPosition() {
        return this.fCursorPosition;
    }

    protected boolean isCursorInExpression() {
        return this.fCursorInExpression;
    }

    protected void setCursorInExpression(boolean in) {
        this.fCursorInExpression = in;
    }

    public final void setSourceCursor(int i) {
        this.fSourcePosition = i;
    }

    public final int getSourcePosition() {
        return this.fSourcePosition;
    }

    public final TLDCMDocumentManager getTLDCMDocumentManager() {
        return TaglibController.getTLDCMDocumentManager((IDocument)this.fStructuredDocument);
    }

    public final void setRelativeOffset(int relativeOffset) {
        this.fRelativeOffset = relativeOffset;
    }

    public final int getRelativeOffset() {
        return this.fRelativeOffset;
    }

    private void setCursorOwner(StringBuffer cursorOwner) {
        this.fCursorOwner = cursorOwner;
    }

    public final StringBuffer getCursorOwner() {
        return this.fCursorOwner;
    }

    private IStructuredDocumentRegion setCurrentNode(IStructuredDocumentRegion currentNode) {
        this.fCurrentNode = currentNode;
        return this.fCurrentNode;
    }

    public final IStructuredDocumentRegion getCurrentNode() {
        return this.fCurrentNode;
    }

    public ArrayList getELProblems() {
        return this.fELProblems;
    }

    public IStructuredDocument getStructuredDocument() {
        return this.fStructuredDocument;
    }
}

