/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaDirectiveAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.BaseSelectionAction;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDFileEditorInput;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDImportImpl;

public class OpenInNewEditor
extends BaseSelectionAction {
    public static final String ID = "OpenInNewEditor";
    static /* synthetic */ Class class$0;

    public OpenInNewEditor(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_OPEN_IN_NEW_EDITOR);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            XSDBaseAdapter xsdAdapter = (XSDBaseAdapter)selection;
            XSDConcreteComponent fComponent = (XSDConcreteComponent)xsdAdapter.getTarget();
            XSDSchema schema = fComponent.getSchema();
            if (fComponent.getSchema() != null) {
                IWorkbenchWindow workbenchWindow;
                String schemaLocation = URIHelper.removePlatformResourceProtocol((String)fComponent.getSchema().getSchemaLocation());
                Path schemaPath = new Path(schemaLocation);
                IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
                if (selection instanceof XSDSchemaDirectiveAdapter) {
                    XSDSchemaDirective dir = (XSDSchemaDirective)((XSDSchemaDirectiveAdapter)selection).getTarget();
                    if (dir instanceof XSDImportImpl) {
                        ((XSDImportImpl)dir).importSchema();
                    }
                    if (dir.getResolvedSchema() != null) {
                        schemaLocation = URIHelper.removePlatformResourceProtocol((String)dir.getResolvedSchema().getSchemaLocation());
                        schemaPath = new Path(schemaLocation);
                        schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
                        schema = dir.getResolvedSchema();
                        fComponent = dir.getResolvedSchema();
                    }
                }
                if (schemaFile != null && schemaFile.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    try {
                        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        XSDSchema xsdSchema = (XSDSchema)iWorkbenchPart.getAdapter((Class)clazz);
                        IEditorPart editorPart = null;
                        if (xsdSchema != null && fComponent.getRootContainer().eResource() == xsdSchema.eResource()) {
                            IEditorInput input;
                            XSDFileEditorInput xsdFileEditorInput = new XSDFileEditorInput(schemaFile, fComponent.getSchema());
                            IEditorPart activeEditor = page.getActiveEditor();
                            String editorName = null;
                            if (activeEditor != null && (input = activeEditor.getEditorInput()) != null) {
                                editorName = input.getName();
                                xsdFileEditorInput.setEditorName(editorName);
                            }
                            IEditorReference[] refs = page.getEditorReferences();
                            int length = refs.length;
                            int i = 0;
                            while (i < length) {
                                IFile aFile;
                                IEditorInput input2 = refs[i].getEditorInput();
                                if (input2 instanceof XSDFileEditorInput && (aFile = ((XSDFileEditorInput)input2).getFile()).getFullPath().equals((Object)schemaFile.getFullPath()) && ((XSDFileEditorInput)input2).getSchema() == schema) {
                                    editorPart = refs[i].getEditor(true);
                                    page.activate(refs[i].getPart(true));
                                    break;
                                }
                                ++i;
                            }
                            if (editorPart == null) {
                                editorPart = page.openEditor((IEditorInput)xsdFileEditorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                            }
                        } else {
                            editorPart = page.openEditor((IEditorInput)new FileEditorInput(schemaFile), "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                        }
                        if (editorPart instanceof InternalXSDMultiPageEditor) {
                            ((InternalXSDMultiPageEditor)editorPart).openOnGlobalReference(fComponent);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

