/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.w3c.dom.Node;

public class MoveAttributeAction
extends Action {
    protected List selectedNodes;
    protected Node parentNode;
    protected Node previousRefChild;
    protected Node nextRefChild;
    boolean doInsertBefore;
    List selectedComponentsList;
    XSDConcreteComponent parentComponent;
    XSDConcreteComponent previousRefComponent;
    XSDConcreteComponent nextRefComponent;

    public MoveAttributeAction(XSDConcreteComponent parentComponent, List selectedComponents, XSDConcreteComponent previousRefChildComponent, XSDConcreteComponent nextRefChildComponent) {
        this.parentComponent = parentComponent;
        this.selectedComponentsList = selectedComponents;
        this.previousRefComponent = previousRefChildComponent;
        this.nextRefComponent = nextRefChildComponent;
        this.selectedNodes = new ArrayList(selectedComponents.size());
        Iterator i = selectedComponents.iterator();
        while (i.hasNext()) {
            XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
            this.selectedNodes.add(concreteComponent.getElement());
        }
        this.parentNode = parentComponent.getElement();
        this.nextRefChild = nextRefChildComponent != null ? nextRefChildComponent.getElement() : null;
        this.previousRefChild = previousRefChildComponent != null ? previousRefChildComponent.getElement() : null;
        boolean bl = this.doInsertBefore = this.nextRefChild != null;
        if (this.nextRefComponent != null && this.nextRefComponent.getContainer().getContainer() == parentComponent) {
            this.doInsertBefore = true;
        }
        if (this.previousRefComponent != null && this.previousRefComponent.getContainer().getContainer() == parentComponent) {
            this.doInsertBefore = false;
        }
    }

    public boolean canMove() {
        boolean result = true;
        if (this.nextRefComponent instanceof XSDElementDeclaration || this.previousRefComponent instanceof XSDElementDeclaration) {
            return false;
        }
        return result;
    }

    public void run() {
        if (this.parentComponent instanceof XSDAttributeGroupDefinition) {
            this.moveUnderXSDAttributeGroupDefinition((XSDAttributeGroupDefinition)this.parentComponent);
        } else if (this.parentComponent instanceof XSDComplexTypeDefinition) {
            this.moveUnderXSDComplexTypeDefinition((XSDComplexTypeDefinition)this.parentComponent);
        }
    }

    protected void moveUnderXSDAttributeGroupDefinition(XSDAttributeGroupDefinition parentModelGroup) {
        try {
            Iterator i = this.selectedComponentsList.iterator();
            while (i.hasNext()) {
                XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
                if (this.doInsertBefore ? concreteComponent == this.nextRefComponent : concreteComponent == this.previousRefComponent) continue;
                Iterator iterator = parentModelGroup.getContents().iterator();
                while (iterator.hasNext()) {
                    XSDAttributeDeclaration attribute;
                    XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator.next();
                    if (!(attributeGroupContent instanceof XSDAttributeUse) || (attribute = ((XSDAttributeUse)attributeGroupContent).getContent()) != concreteComponent) continue;
                    parentModelGroup.getContents().remove((Object)attribute.getContainer());
                    break;
                }
                int index = 0;
                EList attributeGroupContents = parentModelGroup.getContents();
                Iterator iterator2 = attributeGroupContents.iterator();
                while (iterator2.hasNext()) {
                    XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator2.next();
                    if (attributeGroupContent instanceof XSDAttributeUse) {
                        XSDAttributeDeclaration attribute = ((XSDAttributeUse)attributeGroupContent).getContent();
                        if (this.doInsertBefore) {
                            if (attribute == this.nextRefComponent) {
                                parentModelGroup.getContents().add(index, (Object)concreteComponent.getContainer());
                                break;
                            }
                        } else if (attribute == this.previousRefComponent) {
                            parentModelGroup.getContents().add(index + 1, (Object)concreteComponent.getContainer());
                            break;
                        }
                    }
                    ++index;
                }
                if (attributeGroupContents.size() != 0) continue;
                parentModelGroup.getContents().add((Object)concreteComponent.getContainer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void moveUnderXSDComplexTypeDefinition(XSDComplexTypeDefinition complexType) {
        try {
            Iterator i = this.selectedComponentsList.iterator();
            while (i.hasNext()) {
                XSDConcreteComponent concreteComponent = (XSDConcreteComponent)i.next();
                if (this.doInsertBefore ? concreteComponent == this.nextRefComponent : concreteComponent == this.previousRefComponent) continue;
                Iterator iterator = complexType.getAttributeContents().iterator();
                while (iterator.hasNext()) {
                    XSDAttributeDeclaration attribute;
                    XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator.next();
                    if (!(attributeGroupContent instanceof XSDAttributeUse) || (attribute = ((XSDAttributeUse)attributeGroupContent).getContent()) != concreteComponent) continue;
                    complexType.getAttributeContents().remove((Object)attribute.getContainer());
                    break;
                }
                int index = 0;
                EList attributeGroupContents = complexType.getAttributeContents();
                Iterator iterator2 = attributeGroupContents.iterator();
                while (iterator2.hasNext()) {
                    XSDAttributeGroupContent attributeGroupContent = (XSDAttributeGroupContent)iterator2.next();
                    if (attributeGroupContent instanceof XSDAttributeUse) {
                        XSDAttributeDeclaration attribute = ((XSDAttributeUse)attributeGroupContent).getContent();
                        if (this.doInsertBefore) {
                            if (attribute == this.nextRefComponent) {
                                complexType.getAttributeContents().add(index, (Object)concreteComponent.getContainer());
                                break;
                            }
                        } else if (attribute == this.previousRefComponent) {
                            complexType.getAttributeContents().add(index + 1, (Object)concreteComponent.getContainer());
                            break;
                        }
                    }
                    ++index;
                }
                if (attributeGroupContents.size() != 0) continue;
                complexType.getAttributeContents().add((Object)concreteComponent.getContainer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

