/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.IVirtualContainerAPITest;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public class IVirtualFolderAPITest
extends IVirtualContainerAPITest {
    public static final String TEST_FOLDER_NAME = "WEB-INF";
    public static final IPath WEBCONTENT_FOLDER_REAL_PATH = new Path("/WebModule1/WebContent/");
    public static final IPath WEBINF_FOLDER_REAL_PATH = WEBCONTENT_FOLDER_REAL_PATH.append("WEB-INF");
    public static final IPath WEBINF_FOLDER_RUNTIME_PATH = new Path("/WEB-INF");
    public static final IPath TESTDATA_FOLDER_REAL_PATH = new Path("WebModule1/testdata");
    public static final IPath TESTDATA_FOLDER_RUNTIME_PATH = new Path("/");
    private static final IPath DELETEME_PATH = new Path("/deleteme");

    public IVirtualFolderAPITest(String name) {
        super(name);
    }

    protected void doSetup() throws Exception {
        this.expectedPlatformContainerPath = TESTDATA_FOLDER_REAL_PATH;
        this.expectedRuntimePath = WEBINF_FOLDER_RUNTIME_PATH;
        this.expectedName = TEST_FOLDER_NAME;
        this.expectedProject = TestWorkspace.TEST_PROJECT;
        this.targetExistingPlatformResource = TestWorkspace.TEST_PROJECT.getFolder(WEBINF_FOLDER_REAL_PATH);
        IVirtualComponent component = ComponentCore.createComponent((IProject)TestWorkspace.TEST_PROJECT);
        IVirtualFolder rootFolder = component.getRootFolder();
        this.virtualParent = rootFolder;
        this.targetExistingVirtualResource = this.virtualParent.getFolder(WEBINF_FOLDER_RUNTIME_PATH);
        this.targetVirtualContainer = this.virtualParent.getFolder(TESTDATA_FOLDER_RUNTIME_PATH);
        this.targetPlatformContainer = TestWorkspace.TEST_PROJECT.getFolder(TESTDATA_FOLDER_REAL_PATH);
        this.targetVirtualResourceToDelete = this.virtualParent.getFolder(DELETEME_PATH);
        this.targetVirtualResourceToDelete.create(256, null);
        this.targetPlatformResourceToDelete = this.expectedProject.getFolder(this.targetVirtualResourceToDelete.getProjectRelativePath());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.targetPlatformResourceToDelete.exists()) {
            this.targetPlatformResourceToDelete.delete(256, null);
        }
    }

    public void testGetUnderlyingFolder() {
        IContainer underlyingResource = ((IVirtualFolder)this.targetExistingVirtualResource).getUnderlyingFolder();
        IFolder expectedPlatformResource = TestWorkspace.TEST_PROJECT.getFolder(WEBINF_FOLDER_RUNTIME_PATH);
        IVirtualFolderAPITest.assertEquals((String)("The underlying resource should be " + expectedPlatformResource.getProjectRelativePath()), (Object)expectedPlatformResource, (Object)underlyingResource);
    }

    public void testGetUnderlyingFolders() {
        IContainer[] underlyingResources = ((IVirtualFolder)this.targetVirtualContainer).getUnderlyingFolders();
        IVirtualFolderAPITest.assertEquals((String)"There should be two folders mapped to root", (int)2, (int)underlyingResources.length);
        HashSet<IContainer> underlyingResourcesSet = new HashSet<IContainer>(Arrays.asList(underlyingResources));
        HashSet<IFolder> expectedUnderlyingResourcesSet = new HashSet<IFolder>();
        expectedUnderlyingResourcesSet.add(TestWorkspace.TEST_PROJECT.getFolder(TESTDATA_FOLDER_REAL_PATH));
        expectedUnderlyingResourcesSet.add(TestWorkspace.TEST_PROJECT.getFolder(WEBCONTENT_FOLDER_REAL_PATH));
        IVirtualFolderAPITest.assertEquals((Object)("Expecting two folders mapped to root." + expectedUnderlyingResourcesSet), underlyingResourcesSet);
    }
}

