/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.TestDataModelProvider;

public class DataModelFactoryTest
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void testBogusExtension() {
        IDataModel dataModel = null;
        try {
            dataModel = DataModelFactory.createDataModel((String)"bogus");
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testInvalidExtensionID() {
        IDataModel dataModel = null;
        try {
            dataModel = DataModelFactory.createDataModel((String)"badID");
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testInvalidExtensionClass() {
        IDataModel dataModel = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            dataModel = DataModelFactory.createDataModel((Class)clazz);
        }
        catch (Exception e) {
        }
        DataModelFactoryTest.assertNull((Object)dataModel);
    }

    public void testValidExtensionIDAndProviderType() {
        String[] descs = DataModelFactory.getDataModelProviderIDsForKind((String)"testProviderBase");
        IDataModel dataModel = DataModelFactory.createDataModel((String)descs[0]);
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionID() {
        IDataModel dataModel = DataModelFactory.createDataModel((String)"org.eclipse.wst.common.frameworks.datamodel.tests.ITestDataModel");
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.common.frameworks.datamodel.tests.ITestDataModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDataModel dataModel = DataModelFactory.createDataModel((Class)clazz);
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionInstance() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new TestDataModelProvider());
        DataModelFactoryTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }
}

