/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.adapters.jdom.JavaFieldJDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaMethodJDOMAdaptor;
import org.eclipse.jem.internal.java.adapters.IJavaClassAdaptor;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdapterFactory;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.internal.plugin.JavaPlugin;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.InheritanceCycleException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jem.util.TimerTests;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.logger.proxy.Logger;

public class JavaClassJDOMAdaptor
extends JDOMAdaptor
implements IJavaClassAdaptor {
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    public static final String REFLECT_CLASS = "Reflect JDOM Class";
    public static final String REFLECT_METHODS = "Reflect all JDOM methods for a class";
    public static final String REFLECT_FIELDS = "Reflect all JDOM fields for a class";
    protected IType sourceType = null;
    protected JavaReflectionAdapterFactory adapterFactory;
    private Map typeResolutionCache = new HashMap(25);
    private boolean hasReflectedFields;
    private boolean isReflectingFields;
    private boolean hasReflectedMethods;
    private boolean isReflectingMethods;
    private Map existingFields = new HashMap();
    private Map existingMethods = new HashMap();
    protected boolean flushAndClearCachedModelObject;

    public JavaClassJDOMAdaptor(Notifier target, IJavaProject workingProject, JavaReflectionAdapterFactory inFactory) {
        super(target, workingProject);
        this.setAdapterFactory(inFactory);
    }

    protected boolean addFields() {
        IField[] fields = null;
        try {
            fields = this.getSourceType().getFields();
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e, Level.WARNING);
            return false;
        }
        XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
        Field field = null;
        JavaFieldJDOMAdaptor adapter = null;
        HashMap<IField, Field> newExisting = new HashMap<IField, Field>(fields.length);
        ArrayList<Field> newFields = new ArrayList<Field>();
        int i = 0;
        while (i < fields.length) {
            IField ifield = fields[i];
            field = (Field)this.existingFields.remove(ifield);
            if (field != null) {
                newExisting.put(ifield, field);
                adapter = (JavaFieldJDOMAdaptor)EcoreUtil.getExistingAdapter((Notifier)field, (Object)"JavaReflection");
                if (adapter == null) {
                    adapter = (JavaFieldJDOMAdaptor)this.getAdapterFactory().adaptNew((Notifier)field, (Object)"JavaReflection");
                } else {
                    adapter.flushReflectedValuesIfNecessaryNoNotification(true);
                }
                adapter.setSourceField(ifield);
            } else {
                field = this.createJavaField(ifield, resource);
                newExisting.put(ifield, field);
                newFields.add(field);
                adapter = (JavaFieldJDOMAdaptor)this.getAdapterFactory().adaptNew((Notifier)field, (Object)"JavaReflection");
                if (adapter != null) {
                    adapter.setSourceField(ifield);
                }
            }
            ++i;
        }
        BasicEList fieldsList = (BasicEList)this.getJavaClassTarget().getFieldsGen();
        if (!this.existingFields.isEmpty()) {
            URI baseURI = resource.getURI();
            Collection toDelete = this.existingFields.values();
            Iterator itr = toDelete.iterator();
            while (itr.hasNext()) {
                InternalEObject m = (InternalEObject)itr.next();
                String id = resource.getID((EObject)m);
                if (id == null) continue;
                m.eSetProxyURI(baseURI.appendFragment(id));
            }
            fieldsList.removeAll(toDelete);
        }
        if (!newFields.isEmpty()) {
            fieldsList.addAllUnique(newFields);
        }
        this.existingFields = newExisting;
        return true;
    }

    protected boolean addMethods() {
        IMethod[] methods = null;
        try {
            methods = this.getSourceType().getMethods();
        }
        catch (JavaModelException e) {
            Logger.getLogger().log((Throwable)e, Level.WARNING);
            return false;
        }
        XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
        Method method = null;
        JavaMethodJDOMAdaptor adapter = null;
        HashMap<IMethod, Method> newExisting = new HashMap<IMethod, Method>(methods.length);
        ArrayList<Method> newMethods = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            IMethod im = methods[i];
            method = (Method)this.existingMethods.remove(im);
            if (method != null) {
                newExisting.put(im, method);
                adapter = (JavaMethodJDOMAdaptor)JavaClassJDOMAdaptor.retrieveAdaptorFrom((EObject)method);
                if (adapter != null) {
                    adapter.flushReflectedValuesIfNecessaryNoNotification(true);
                    adapter.setSourceMethod(im);
                }
            } else {
                method = this.createJavaMethod(im, resource);
                newExisting.put(im, method);
                newMethods.add(method);
                adapter = (JavaMethodJDOMAdaptor)this.getAdapterFactory().adaptNew((Notifier)method, (Object)"JavaReflection");
                if (adapter != null) {
                    adapter.setSourceMethod(methods[i]);
                }
            }
            ++i;
        }
        BasicEList methodsList = (BasicEList)this.getJavaClassTarget().getMethodsGen();
        if (!this.existingMethods.isEmpty()) {
            URI baseURI = resource.getURI();
            Collection toDelete = this.existingMethods.values();
            Iterator itr = toDelete.iterator();
            while (itr.hasNext()) {
                InternalEObject m = (InternalEObject)itr.next();
                String id = resource.getID((EObject)m);
                if (id == null) continue;
                m.eSetProxyURI(baseURI.appendFragment(id));
            }
            methodsList.removeAll(toDelete);
        }
        if (!newMethods.isEmpty()) {
            methodsList.addAllUnique(newMethods);
        }
        this.existingMethods = newExisting;
        return true;
    }

    protected void clearSource() {
        this.sourceType = null;
    }

    protected boolean flushFields() {
        this.existingFields.clear();
        XMIResource res = (XMIResource)this.getJavaClassTarget().eResource();
        URI baseURI = res.getURI();
        EList fields = this.getJavaClassTarget().getFieldsGen();
        int msize = fields.size();
        int i = 0;
        while (i < msize) {
            InternalEObject f = (InternalEObject)fields.get(i);
            String id = res.getID((EObject)f);
            if (id != null) {
                f.eSetProxyURI(baseURI.appendFragment(id));
            }
            ++i;
        }
        fields.clear();
        return true;
    }

    protected boolean flushImplements() {
        this.getJavaClassTarget().getImplementsInterfacesGen().clear();
        return true;
    }

    protected boolean flushMethods() {
        this.existingMethods.clear();
        XMIResource res = (XMIResource)this.getJavaClassTarget().eResource();
        URI baseURI = res.getURI();
        EList methods = this.getJavaClassTarget().getMethodsGen();
        int msize = methods.size();
        int i = 0;
        while (i < msize) {
            InternalEObject m = (InternalEObject)methods.get(i);
            String id = res.getID((EObject)m);
            if (id != null) {
                m.eSetProxyURI(baseURI.appendFragment(id));
            }
            ++i;
        }
        methods.clear();
        return true;
    }

    protected boolean flushModifiers() {
        JavaClass javaClassTarget = (JavaClass)this.getTarget();
        javaClassTarget.setAbstract(false);
        javaClassTarget.setFinal(false);
        javaClassTarget.setPublic(false);
        javaClassTarget.setKind(TypeKind.UNDEFINED_LITERAL);
        return true;
    }

    protected boolean flushInnerClasses() {
        this.getJavaClassTarget().getDeclaredClassesGen().clear();
        return true;
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        this.flushAndClearCachedModelObject = clearCachedModelObject;
        return true;
    }

    private void flushNow() {
        if (this.flushAndClearCachedModelObject) {
            this.setSourceType(null);
        }
        this.typeResolutionCache.clear();
        this.flushModifiers();
        this.flushSuper();
        this.flushImplements();
        if (this.flushAndClearCachedModelObject) {
            this.flushMethods();
            this.flushFields();
        }
        this.hasReflectedMethods = false;
        this.hasReflectedFields = false;
        this.flushInnerClasses();
        this.flushAndClearCachedModelObject = false;
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
        this.getJavaClassTarget().setReflected(false);
        super.postFlushReflectedValuesIfNecessary(isExisting);
    }

    protected boolean flushSuper() {
        EList targetSupers = this.getJavaClassTarget().primGetESuperTypes();
        targetSupers.clear();
        return true;
    }

    protected JavaReflectionAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected IType getBinaryType() {
        return this.getBinaryType(((JavaClass)this.getTarget()).getQualifiedName());
    }

    protected JavaClassImpl getJavaClassTarget() {
        return (JavaClassImpl)this.getTarget();
    }

    public Object getReflectionSource() {
        return this.getSourceType();
    }

    public boolean hasCachedReflectionSource() {
        return this.sourceType != null;
    }

    public IType getSourceType() {
        if (this.sourceType == null || this.flushAndClearCachedModelObject) {
            JavaClassImpl javaClass = (JavaClassImpl)this.getTarget();
            this.sourceType = JDOMSearchHelper.findType(javaClass.getJavaPackage().getName(), javaClass.primGetName(), this.getSourceProject());
            if (this.hasValidReflection()) {
                this.flushReflectedValuesIfNecessaryNoNotification(false);
            }
        }
        return this.sourceType;
    }

    protected IType getType() {
        return this.getSourceType();
    }

    protected Map getTypeResolutionCache() {
        return this.typeResolutionCache;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean isSourceTypeFromBinary() {
        if (this.getSourceType() == null) {
            return false;
        }
        return this.getSourceType().isBinary();
    }

    protected JavaClass reflectJavaClass(String qualifiedName) {
        IType type = JDOMSearchHelper.findType(qualifiedName, true, this.getSourceProject(), this);
        if (type != null) {
            return this.reflectJavaClass(type);
        }
        return this.createJavaClassRef(qualifiedName);
    }

    protected JavaClass reflectJavaClass(IType aType) {
        if (aType != null) {
            JavaClassJDOMAdaptor adaptor;
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(aType.getFullyQualifiedName(), (EObject)this.getTarget());
            if (javaClass != null && (adaptor = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)javaClass.eAdapters(), (Object)"JavaReflection")) != null) {
                adaptor.setSourceType(aType);
            }
            return javaClass;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reflectValues() {
        boolean isHeadless;
        if (this.hasFlushed) {
            this.flushNow();
        }
        super.reflectValues();
        boolean bl = isHeadless = UIContextDetermination.getCurrentContext() == 102;
        if (this.canReflect()) {
            block8: {
                TimerTests.basicTest.startCumulativeStep(REFLECT_CLASS);
                try {
                    IResource res;
                    ICompilationUnit cu = this.getSourceType().getCompilationUnit();
                    boolean isWC = cu != null ? cu.isWorkingCopy() : false;
                    IResource iResource = res = isWC ? this.getSourceType().getResource() : null;
                    if (isWC && (res == null || !res.isAccessible())) break block8;
                    this.setModifiers();
                    this.setNaming();
                    try {
                        this.setSuper();
                    }
                    catch (InheritanceCycleException e) {
                        JavaPlugin.getDefault().getLogger().log((Throwable)e);
                    }
                    this.setImplements();
                    this.reflectInnerClasses();
                    this.setDeclaringClass();
                    if (!isHeadless) break block8;
                    this.registerWithFactory();
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    TimerTests.basicTest.stopCumulativeStep(REFLECT_CLASS);
                    throw throwable;
                }
                TimerTests.basicTest.stopCumulativeStep(REFLECT_CLASS);
                return true;
            }
            Object var6_8 = null;
            TimerTests.basicTest.stopCumulativeStep(REFLECT_CLASS);
        }
        if (isHeadless) {
            return false;
        }
        this.registerWithFactory();
        return true;
    }

    protected void setDeclaringClass() {
        IType declaringType = this.getSourceType().getDeclaringType();
        if (declaringType != null) {
            ResourceSet set = this.getTargetResource().getResourceSet();
            String packageName = declaringType.getPackageFragment().getElementName();
            JavaClassImpl declaringClass = (JavaClassImpl)JavaRefFactory.eINSTANCE.reflectType(packageName, declaringType.getTypeQualifiedName(), set);
            declaringClass.getDeclaredClasses();
        }
    }

    private boolean canReflect() {
        return this.isResourceLoaded() && this.getSourceProject() != null && this.getSourceType() != null && this.getSourceType().exists();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean reflectFieldsIfNecessary() {
        if (this.reflectValuesIfNecessary() && this.canReflect()) {
            if (!this.hasReflectedFields && !this.isReflectingFields) {
                this.isReflectingFields = true;
                try {
                    try {
                        TimerTests.basicTest.startCumulativeStep(REFLECT_FIELDS);
                        this.addFields();
                        this.hasReflectedFields = true;
                    }
                    catch (Throwable e) {
                        this.hasReflectedFields = false;
                        Logger logger = Logger.getLogger();
                        if (logger.isLoggingLevel(Level.WARNING)) {
                            logger.log((Object)ResourceHandler.getString((String)"Failed_reflecting_values_ERROR_"), Level.WARNING);
                            logger.logWarning(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.isReflectingFields = false;
                    TimerTests.basicTest.stopCumulativeStep(REFLECT_FIELDS);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    this.isReflectingFields = false;
                }
                TimerTests.basicTest.stopCumulativeStep(REFLECT_FIELDS);
            }
            return this.hasReflectedFields;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean reflectMethodsIfNecessary() {
        if (this.reflectValuesIfNecessary() && this.canReflect()) {
            if (!this.hasReflectedMethods && !this.isReflectingMethods) {
                block9: {
                    this.isReflectingMethods = true;
                    try {
                        try {
                            TimerTests.basicTest.startCumulativeStep(REFLECT_METHODS);
                            this.hasReflectedMethods = this.addMethods();
                        }
                        catch (Throwable e) {
                            this.hasReflectedMethods = false;
                            Logger logger = Logger.getLogger();
                            if (logger.isLoggingLevel(Level.WARNING)) {
                                logger.log((Object)ResourceHandler.getString((String)"Failed_reflecting_values_ERROR_"), Level.WARNING);
                                logger.logWarning(e);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        this.isReflectingMethods = false;
                        if (!this.hasReflected) {
                            this.flushMethods();
                        }
                        TimerTests.basicTest.stopCumulativeStep(REFLECT_METHODS);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        this.isReflectingMethods = false;
                        if (this.hasReflected) break block9;
                        this.flushMethods();
                    }
                }
                TimerTests.basicTest.stopCumulativeStep(REFLECT_METHODS);
            }
            return this.hasReflectedMethods;
        }
        return false;
    }

    private void registerWithFactory() {
        this.getAdapterFactory().registerReflection(this.getJavaClassTarget().getQualifiedNameForReflection(), (ReflectionAdaptor)this);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 8 && notification.getOldValue() == this && notification.getNotifier() == this.getTarget()) {
            this.getAdapterFactory().unregisterReflection(this.getJavaClassTarget().getQualifiedNameForReflection());
        }
    }

    protected void setAdapterFactory(JavaReflectionAdapterFactory inFactory) {
        this.adapterFactory = inFactory;
    }

    protected void setImplements() {
        try {
            String[] interfaceNames = this.getSourceType().getSuperInterfaceNames();
            EList list = this.getJavaClassTarget().getImplementsInterfacesGen();
            int i = 0;
            while (i < interfaceNames.length) {
                String name = interfaceNames[i];
                String innertypeName = JDOMSearchHelper.getResolvedTypeName(name, this.getType(), this.getTypeResolutionCache());
                if (innertypeName != null) {
                    name = innertypeName;
                }
                JavaClass ref = this.reflectJavaClass(name);
                list.add(ref);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void setModifiers() {
        block4: {
            JavaClass javaClassTarget = (JavaClass)this.getTarget();
            try {
                javaClassTarget.setAbstract(Flags.isAbstract((int)this.getSourceType().getFlags()));
                javaClassTarget.setFinal(Flags.isFinal((int)this.getSourceType().getFlags()));
                javaClassTarget.setPublic(Flags.isPublic((int)this.getSourceType().getFlags()));
                if (this.getSourceType().isClass()) {
                    javaClassTarget.setKind(TypeKind.CLASS_LITERAL);
                } else {
                    javaClassTarget.setKind(TypeKind.INTERFACE_LITERAL);
                }
            }
            catch (JavaModelException npe) {
                Logger logger = JavaPlugin.getDefault().getLogger();
                if (!logger.isLoggingLevel(Level.WARNING)) break block4;
                logger.log((Object)ResourceHandler.getString((String)"Error_Introspecting_Flags_ERROR_", (Object[])new Object[]{javaClassTarget.getQualifiedName(), npe.getMessage()}), Level.WARNING);
            }
        }
    }

    protected void setNaming() {
    }

    protected void setSourceType(IType aType) {
        this.sourceType = aType;
    }

    protected void setSuper() throws InheritanceCycleException {
        String superName = null;
        IType superType = null;
        try {
            if (!this.getSourceType().isInterface()) {
                IType declaringType;
                superName = this.getSourceType().getSuperclassName();
                if (!this.getSourceType().isBinary() && superName != null && this.isTargetInner() && (declaringType = this.getSourceType().getDeclaringType()) != null) {
                    IType[] inners = declaringType.getTypes();
                    int i = 0;
                    while (i < inners.length) {
                        IType type = inners[i];
                        if (superName.equals(type.getElementName())) {
                            superName = String.valueOf(declaringType.getElementName()) + '.' + superName;
                            this.reflectInnerClasses(declaringType);
                            superType = type;
                            break;
                        }
                        ++i;
                    }
                }
                if (superName == null && !this.getSourceType().getFullyQualifiedName().equals(OBJECT_TYPE_NAME)) {
                    superName = OBJECT_TYPE_NAME;
                }
                if (superName != null) {
                    JavaClass javaClassTarget = (JavaClass)this.getTarget();
                    if (superType != null) {
                        javaClassTarget.setSupertype(this.reflectJavaClass(superType));
                    } else {
                        javaClassTarget.setSupertype(this.reflectJavaClass(superName));
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private boolean isTargetInner() {
        JavaClassImpl javaClass = (JavaClassImpl)this.getTarget();
        return javaClass.getName().indexOf(36) != -1;
    }

    public boolean sourceTypeExists() {
        return this.getSourceType() != null;
    }

    protected void reflectInnerClasses() {
        IType[] innerClasses = null;
        try {
            innerClasses = this.getSourceType().getTypes();
        }
        catch (JavaModelException javaModelException) {}
        if (innerClasses != null && innerClasses.length != 0) {
            EList declaredClasses = this.getJavaClassTarget().getDeclaredClassesGen();
            ResourceSet set = this.getTargetResource().getResourceSet();
            String packageName = this.getSourceType().getPackageFragment().getElementName();
            int i = 0;
            while (i < innerClasses.length) {
                JavaClass inner = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(packageName, innerClasses[i].getTypeQualifiedName(), set);
                declaredClasses.add(inner);
                ++i;
            }
        }
    }

    protected void reflectInnerClasses(IType aType) {
        IType[] innerClasses = null;
        try {
            innerClasses = aType.getTypes();
        }
        catch (JavaModelException javaModelException) {}
        if (innerClasses != null && innerClasses.length != 0) {
            ResourceSet set = this.getTargetResource().getResourceSet();
            String packageName = aType.getPackageFragment().getElementName();
            JavaClassImpl parentType = (JavaClassImpl)JavaRefFactory.eINSTANCE.reflectType(packageName, aType.getTypeQualifiedName(), set);
            EList declaredClasses = parentType.getDeclaredClassesGen();
            int i = 0;
            while (i < innerClasses.length) {
                JavaClass inner = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(packageName, innerClasses[i].getTypeQualifiedName(), set);
                declaredClasses.add(inner);
                ++i;
            }
        }
    }

    synchronized boolean hasValidReflection() {
        return this.sourceType != null && this.hasReflected && !this.isReflecting;
    }
}

