/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.internal.outputview.DialogShowXMLField;
import org.eclipse.wst.rdb.internal.outputview.IOutputViewXMLDataHandler;
import org.eclipse.wst.rdb.internal.outputview.OutputView;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

public class OutputUtil {
    protected static IWorkbenchWindow activeWindow = null;
    protected static IWorkbenchPage activePage = null;
    protected static IViewPart viewPart = null;
    protected static final String VIEW_XML_DATA_HANDLER_EXT_POINT = "org.eclipse.wst.rdb.outputview.viewXmlDataHandler";
    protected static final String VIEW_XML_DATA_HANDLER_EXT_ATTR_CLASS = "class";
    protected static final String VIEW_XML_DATA_HANDLER_EXT_ATTR_ID = "id";
    protected static final String VIEW_XML_DATA_HANDLER_EXT_ATTR_OVERRIDE = "overrideDefault";
    protected static boolean overridePresent = false;
    protected static HashMap contributedViewXmlDataHandlers;

    static {
        OutputUtil.addXMLDataHandlersFromExtensions();
    }

    public static OutputView getOutputView() {
        return OutputUtil.getOutputView(false);
    }

    public static OutputView getOutputView(boolean async) {
        if (activeWindow == null) {
            activeWindow = OutputViewPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        }
        if (activeWindow == null) {
            IWorkbenchWindow[] ww = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (ww.length > 0) {
                activeWindow = ww[0];
                if (activeWindow == null) {
                    return null;
                }
            } else {
                return null;
            }
            activePage = activeWindow.getActivePage();
            if (activePage == null) {
                IWorkbenchPage[] pages = activeWindow.getPages();
                int i = 0;
                while (i < pages.length) {
                    if (pages[i].getPerspective().getId().equals("com.ibm.datatools.core.internal.ui.perspective")) {
                        activePage = pages[i];
                    }
                    ++i;
                }
            }
        } else {
            activePage = activeWindow.getActivePage();
        }
        if (activePage == null) {
            return null;
        }
        if (async) {
            viewPart = null;
            Display display = activeWindow.getShell().getDisplay();
            if (display != null) {
                activePage.getViewReferences();
                if (OutputUtil.isFoundOutputView()) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            activePage.bringToTop((IWorkbenchPart)viewPart);
                        }
                    });
                } else {
                    display.syncExec(new Runnable(){

                        public void run() {
                            OutputUtil.openOutputView();
                        }
                    });
                }
                if (viewPart != null) {
                    return (OutputView)viewPart;
                }
                return null;
            }
            return null;
        }
        OutputUtil.showOutputView();
        return (OutputView)viewPart;
    }

    public static String getCharacterEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public static void launchXMLDialog(Shell aShell, String aTitle, String text) {
        if (!overridePresent) {
            DialogShowXMLField xmlDialog = new DialogShowXMLField(aShell, aTitle, text);
            xmlDialog.open();
        }
        Iterator i = contributedViewXmlDataHandlers.values().iterator();
        while (i.hasNext()) {
            IOutputViewXMLDataHandler handler = (IOutputViewXMLDataHandler)i.next();
            handler.setData(text);
            handler.handleData();
        }
    }

    private static void addXMLDataHandlersFromExtensions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(VIEW_XML_DATA_HANDLER_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        contributedViewXmlDataHandlers = new LinkedHashMap(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement currentConfigElement = configElements[j];
                try {
                    IOutputViewXMLDataHandler myTabs = (IOutputViewXMLDataHandler)currentConfigElement.createExecutableExtension(VIEW_XML_DATA_HANDLER_EXT_ATTR_CLASS);
                    String id = currentConfigElement.getAttribute(VIEW_XML_DATA_HANDLER_EXT_ATTR_ID);
                    overridePresent |= Boolean.valueOf(currentConfigElement.getAttribute(VIEW_XML_DATA_HANDLER_EXT_ATTR_OVERRIDE)).booleanValue();
                    contributedViewXmlDataHandlers.put(id, myTabs);
                }
                catch (CoreException ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:addXMLDataHandlersFromExtensions()", ex);
                }
                ++j;
            }
            ++i;
        }
    }

    protected static void showOutputView() {
        try {
            if (!OutputUtil.isFoundOutputView()) {
                viewPart = activePage.showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)new Shell(), (String)OutputViewPlugin.getString("STR_OPEN_OUTPUT_ERROR"), (String)e.getMessage());
            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:getOutputView.", e);
            viewPart = null;
        }
    }

    private static boolean isFoundOutputView() {
        boolean isFoundView = false;
        IViewReference[] viewReference = activePage.getViewReferences();
        int i = 0;
        while (i < viewReference.length) {
            viewPart = viewReference[i].getView(false);
            if (viewPart instanceof OutputView) {
                isFoundView = true;
                break;
            }
            ++i;
        }
        return isFoundView;
    }

    private static void openOutputView() {
        try {
            viewPart = activePage.showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)new Shell(), (String)OutputViewPlugin.getString("STR_OPEN_OUTPUT_ERROR"), (String)e.getMessage());
            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:getOutputView.", e);
            viewPart = null;
        }
    }
}

