/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.html.internal.validation.HTMLValidationResult;
import org.eclipse.wst.html.internal.validation.LocalizedMessage;
import org.eclipse.wst.html.internal.validation.TaskListHelper;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class HTMLValidationReporter
implements ValidationReporter {
    private IValidator owner = null;
    private IReporter reporter = null;
    private IFile file = null;
    private IStructuredModel model = null;
    private HTMLValidationResult result = null;
    static /* synthetic */ Class class$0;

    public HTMLValidationReporter(IValidator owner, IReporter reporter, IFile file, IStructuredModel model) {
        this.owner = owner;
        this.reporter = reporter;
        this.file = file;
        this.model = model;
    }

    public void clear() {
        if (this.file == null) {
            return;
        }
        this.result = null;
        if (this.reporter != null) {
            this.reporter.removeAllMessages(this.owner, (Object)this.file);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.html.internal.validation.HTMLValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String id = clazz.getName();
            try {
                TaskListHelper.getTaskList().removeAllTasks((IResource)this.file, id, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public HTMLValidationResult getResult() {
        if (this.result == null) {
            this.result = new HTMLValidationResult();
        }
        return this.result;
    }

    public void report(ValidationMessage message) {
        if (message == null || message.getSeverity() == -1) {
            return;
        }
        if (this.file == null) {
            return;
        }
        IMessage mes = this.translateMessage(message);
        if (this.reporter != null) {
            this.reporter.addMessage(this.owner, mes);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.html.internal.validation.HTMLValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String id = clazz.getName();
            String location = Integer.toString(mes.getLineNumber());
            String name = "";
            IPath filePath = this.file.getFullPath();
            if (filePath != null) {
                name = filePath.toString();
            }
            try {
                TaskListHelper.getTaskList().addTask(id, (IResource)this.file, location, mes.getId(), mes.getText(), mes.getSeverity(), name, mes.getGroupName(), mes.getOffset(), mes.getLength());
            }
            catch (CoreException coreException) {}
        }
    }

    private IMessage translateMessage(ValidationMessage message) {
        IStructuredDocument flatModel;
        int severity = 4;
        HTMLValidationResult result = this.getResult();
        switch (message.getSeverity()) {
            case 1: {
                severity = 1;
                result.addError();
                break;
            }
            case 2: {
                severity = 2;
                result.addWarning();
                break;
            }
            case 3: {
                result.addInformation();
                break;
            }
        }
        LocalizedMessage mes = new LocalizedMessage(severity, message.getMessage(), (IResource)this.file);
        mes.setOffset(message.getOffset());
        mes.setLength(message.getLength());
        if (this.model != null && (flatModel = this.model.getStructuredDocument()) != null) {
            int line = flatModel.getLineOfOffset(message.getOffset());
            mes.setLineNo(line + 1);
        }
        return mes;
    }
}

