/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.IOrdered;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class ModuleFactory
implements IOrdered {
    private IConfigurationElement element;
    public ModuleFactoryDelegate delegate;
    private List moduleTypes;
    private List modules;
    private Map projectToModulesMap = new HashMap();

    public ModuleFactory(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getOrder() {
        try {
            return Integer.parseInt(this.element.getAttribute("order"));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public IModuleType[] getModuleTypes() {
        if (this.moduleTypes == null) {
            this.moduleTypes = ServerPlugin.getModuleTypes(this.element.getChildren("moduleType"));
        }
        IModuleType[] mt = new IModuleType[this.moduleTypes.size()];
        this.moduleTypes.toArray(mt);
        return mt;
    }

    public boolean isProjectModuleFactory() {
        return "true".equalsIgnoreCase(this.element.getAttribute("projects"));
    }

    public ModuleFactoryDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate == null) {
            try {
                this.delegate = (ModuleFactoryDelegate)this.element.createExecutableExtension("class");
                InternalInitializer.initializeModuleFactoryDelegate(this.delegate, this, monitor);
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create delegate " + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public IModule getModule(String id) {
        IModule[] modules2 = this.getModules();
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                Module module = (Module)modules2[i];
                if (id.equals(module.getInternalId())) {
                    return module;
                }
                ++i;
            }
        }
        return null;
    }

    public IModule[] getModules(IProject project) {
        ModuleFactoryDelegate mfd = this.getDelegate(null);
        if (mfd instanceof ProjectModuleFactoryDelegate) {
            IModule[] result = (IModule[])this.projectToModulesMap.get(project);
            if (result == null) {
                result = ((ProjectModuleFactoryDelegate)mfd).getModules204165(project);
                this.projectToModulesMap.put(project, result);
            }
            return result;
        }
        return mfd.getModules();
    }

    public void clearModuleCache() {
        this.modules = null;
        this.projectToModulesMap.clear();
    }

    public IModule[] getModules() {
        if (this.modules == null) {
            try {
                this.modules = new ArrayList();
                IModule[] modules2 = this.getDelegate(null).getModules();
                if (modules2 != null) {
                    int size = modules2.length;
                    int i = 0;
                    while (i < size) {
                        this.modules.add(modules2[i]);
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + t.getMessage());
                return null;
            }
        }
        IModule[] m = new IModule[this.modules.size()];
        this.modules.toArray(m);
        return m;
    }

    public String toString() {
        return "ModuleFactory[" + this.getId() + "]";
    }
}

