/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.nsedit;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.nsedit.XSDVisitor;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class TargetNamespaceChangeHandler {
    String newNS;
    String oldNS;
    XSDSchema xsdSchema;

    public TargetNamespaceChangeHandler(XSDSchema xsdSchema, String oldNS, String newNS) {
        this.xsdSchema = xsdSchema;
        this.oldNS = oldNS;
        this.newNS = newNS;
    }

    public void resolve() {
        ElementReferenceRenamer elementReferenceRenamer = new ElementReferenceRenamer();
        elementReferenceRenamer.visitSchema(this.xsdSchema);
        AttributeReferenceRenamer attributeReferenceRenamer = new AttributeReferenceRenamer();
        attributeReferenceRenamer.visitSchema(this.xsdSchema);
    }

    class ElementReferenceRenamer
    extends XSDVisitor {
        public void visitElementDeclaration(XSDElementDeclaration element) {
            super.visitElementDeclaration(element);
            if (element.isElementDeclarationReference()) {
                if (element.getResolvedElementDeclaration().getTargetNamespace() != null) {
                    if (element.getResolvedElementDeclaration().getTargetNamespace().equals(TargetNamespaceChangeHandler.this.oldNS)) {
                        element.getResolvedElementDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                    }
                } else if (TargetNamespaceChangeHandler.this.oldNS == null || TargetNamespaceChangeHandler.this.oldNS != null && TargetNamespaceChangeHandler.this.oldNS.equals("")) {
                    element.getResolvedElementDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                }
            }
        }
    }

    class AttributeReferenceRenamer
    extends XSDVisitor {
        public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
            super.visitComplexTypeDefinition(type);
            if (type.getAttributeContents() != null) {
                Iterator iter = type.getAttributeContents().iterator();
                while (iter.hasNext()) {
                    XSDAttributeUse attrUse;
                    XSDAttributeDeclaration attrDecl;
                    XSDAttributeGroupContent attrGroupContent = (XSDAttributeGroupContent)iter.next();
                    if (!(attrGroupContent instanceof XSDAttributeUse) || (attrDecl = (attrUse = (XSDAttributeUse)attrGroupContent).getContent()) == null || !attrDecl.isAttributeDeclarationReference()) continue;
                    if (attrDecl.getResolvedAttributeDeclaration().getTargetNamespace() != null) {
                        if (!attrDecl.getResolvedAttributeDeclaration().getTargetNamespace().equals(TargetNamespaceChangeHandler.this.oldNS)) continue;
                        attrDecl.getResolvedAttributeDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                        continue;
                    }
                    if (TargetNamespaceChangeHandler.this.oldNS != null && (TargetNamespaceChangeHandler.this.oldNS == null || !TargetNamespaceChangeHandler.this.oldNS.equals(""))) continue;
                    attrDecl.getResolvedAttributeDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                }
            }
        }

        public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
            super.visitAttributeGroupDefinition(attributeGroup);
            EList list = attributeGroup.getAttributeUses();
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    XSDAttributeUse attrUse = (XSDAttributeUse)iter.next();
                    XSDAttributeDeclaration attrDecl = attrUse.getContent();
                    if (attrDecl == null || !attrDecl.isAttributeDeclarationReference()) continue;
                    if (attrDecl.getResolvedAttributeDeclaration().getTargetNamespace() != null) {
                        if (!attrDecl.getResolvedAttributeDeclaration().getTargetNamespace().equals(TargetNamespaceChangeHandler.this.oldNS)) continue;
                        attrDecl.getResolvedAttributeDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                        continue;
                    }
                    if (TargetNamespaceChangeHandler.this.oldNS != null && (TargetNamespaceChangeHandler.this.oldNS == null || !TargetNamespaceChangeHandler.this.oldNS.equals(""))) continue;
                    attrDecl.getResolvedAttributeDeclaration().setTargetNamespace(TargetNamespaceChangeHandler.this.newNS);
                }
            }
        }
    }
}

