/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.jst.j2ee.internal.common.CommonEditResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ModuleStructuralModel;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateInputProvider;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorImpl;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class ClasspathModel
implements ResourceStateInputProvider,
ResourceStateValidator {
    protected IProject project;
    protected IVirtualComponent selectedEARComponent;
    protected IArchive earFile;
    protected IVirtualComponent component;
    public EARArtifactEdit earArtifactEdit;
    protected IVirtualComponent[] availableEARComponents = null;
    protected ClassPathSelection classPathSelection;
    protected List listeners;
    protected List nonResourceFiles;
    protected ResourceStateValidator stateValidator;
    protected ArchiveManifest manifest;
    public static String NO_EAR_MESSAGE = CommonEditResourceHandler.getString("NO_EAR_JARDEP_FOR_MOD_UI_");
    protected List targetWLPRefComponentList;
    protected boolean isWLPModel = false;
    protected ClassPathSelection classPathWLPSelection;
    protected Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            IVirtualComponent e1 = (IVirtualComponent)o1;
            IVirtualComponent e2 = (IVirtualComponent)o2;
            return e1.getProject().getName().compareTo(e2.getProject().getName());
        }
    };
    private static IPath WEBLIB = new Path("WEB-INF/lib").makeAbsolute();

    public ClasspathModel(ArchiveManifest initialManifest) {
        this(initialManifest, false);
    }

    public ClasspathModel(ArchiveManifest initialManifest, boolean isWLPModel) {
        this.manifest = initialManifest;
        this.isWLPModel = isWLPModel;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        this.initializeComponent();
        this.getAvailableEARComponents();
    }

    private void initializeComponent() {
        this.setComponent(ComponentCore.createComponent((IProject)this.getProject()));
    }

    protected IVirtualComponent[] refreshAvailableEARs() {
        if (this.component != null) {
            IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects(this.getComponent().getProject());
            this.availableEARComponents = ComponentUtilities.getComponents((IProject[])earProjects);
            if (this.availableEARComponents != null && this.availableEARComponents.length > 0) {
                Arrays.sort(this.availableEARComponents, this.comparator);
                if (this.selectedEARComponent == null || !Arrays.asList(this.availableEARComponents).contains(this.selectedEARComponent)) {
                    this.selectedEARComponent = this.availableEARComponents.length > 0 ? this.availableEARComponents[0] : null;
                }
            }
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent[] getAvailableEARComponents() {
        if (this.availableEARComponents == null) {
            this.refreshAvailableEARs();
        }
        return this.availableEARComponents;
    }

    public IVirtualComponent getSelectedEARComponent() {
        return this.selectedEARComponent;
    }

    public void setSelectedEARComponent(IVirtualComponent component) {
        this.selectedEARComponent = component;
        this.fireNotification(new ClasspathModelEvent(2));
    }

    public String getArchiveURI() {
        if (this.selectedEARComponent != null) {
            IVirtualReference[] refs = this.selectedEARComponent.getReferences();
            IVirtualComponent moduleComp = this.getComponent();
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getReferencedComponent().equals(moduleComp)) {
                    return refs[i].getArchiveName();
                }
                ++i;
            }
        }
        return null;
    }

    public EARArtifactEdit getEARArtifactEdit() {
        if (this.earArtifactEdit == null || this.selectedEARComponentChanged()) {
            this.earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead(this.selectedEARComponent);
        }
        return this.earArtifactEdit;
    }

    private boolean selectedEARComponentChanged() {
        if (this.earArtifactEdit != null && !this.earArtifactEdit.getComponent().getName().equals(this.selectedEARComponent.getName())) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
            return true;
        }
        return false;
    }

    protected void initializeEARFile() {
        if (this.selectedEARComponent == null || !this.isDDInEAR(this.selectedEARComponent)) {
            this.earFile = null;
            return;
        }
        try {
            this.earFile = JavaEEArchiveUtilities.INSTANCE.openArchive(this.selectedEARComponent);
        }
        catch (ArchiveOpenFailureException aofex) {
            this.handleOpenFailureException((Exception)((Object)aofex));
        }
    }

    protected void initializeSelection(ArchiveManifest existing) {
        block18: {
            try {
                try {
                    this.initializeEARFile();
                    this.initializeArchive();
                    if (J2EEProjectUtilities.isEARProject(this.getProject())) break block18;
                    if (this.getProject() != null) {
                        if (existing == null) {
                            if (this.manifest != null) {
                                J2EEProjectUtilities.writeManifest(this.getProject(), this.manifest);
                            } else {
                                this.manifest = J2EEProjectUtilities.readManifest(this.getProject());
                            }
                        } else {
                            J2EEProjectUtilities.writeManifest(this.getProject(), existing);
                            this.manifest = existing;
                        }
                        if (this.selectedEARComponent != null) {
                            IVirtualReference[] archiveFiles = this.selectedEARComponent.getReferences();
                            IVirtualComponent anArchive = null;
                            int i = 0;
                            while (i < archiveFiles.length) {
                                anArchive = archiveFiles[i].getReferencedComponent();
                                try {
                                    if (J2EEProjectUtilities.isEJBComponent(anArchive)) {
                                        IModelProvider modelProvider = ModelProviderManager.getModelProvider(anArchive.getProject());
                                        modelProvider.getModelObject();
                                    }
                                    J2EEProjectUtilities.readManifest(anArchive.getProject());
                                }
                                catch (ManifestException mfEx) {
                                    Logger.getLogger().logError((Throwable)mfEx);
                                }
                                catch (DeploymentDescriptorLoadException ddException) {
                                    Logger.getLogger().logError((Throwable)ddException);
                                }
                                ++i;
                            }
                        }
                    }
                    this.createClassPathSelection();
                }
                catch (IOException e) {
                    this.handleOpenFailureException(e);
                    if (this.earFile != null) {
                        JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
                    }
                }
            }
            finally {
                if (this.earFile != null) {
                    JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
                }
            }
        }
    }

    protected void initializeArchive() {
    }

    protected void createClassPathSelection() {
        this.classPathSelection = this.getComponent() != null && this.selectedEARComponent != null ? new ClassPathSelection(this.getComponent(), this.selectedEARComponent) : null;
    }

    protected boolean isDDInEAR(IVirtualComponent aComponent) {
        IProject mofRoot = aComponent.getProject();
        if (mofRoot == null || !mofRoot.exists()) {
            return false;
        }
        return mofRoot.exists((IPath)new Path(String.valueOf(aComponent.getRootFolder().getProjectRelativePath().toString()) + "//" + "META-INF/application.xml"));
    }

    protected void handleOpenFailureException(Exception ex) {
        Logger.getLogger().logError((Throwable)ex);
    }

    public void dispose() {
        if (this.earArtifactEdit != null) {
            this.earArtifactEdit.dispose();
            this.earArtifactEdit = null;
        }
    }

    public ClassPathSelection getClassPathSelection() {
        if (this.classPathSelection == null) {
            this.initializeSelection(null);
        }
        return this.classPathSelection;
    }

    public void resetClassPathSelection(ArchiveManifest mf) {
        this.initializeSelection(mf);
        this.fireNotification(new ClasspathModelEvent(4));
    }

    public void resetClassPathSelection() {
        this.resetClassPathSelection(null);
    }

    public void resetClassPathSelectionForWLPs() {
        this.classPathWLPSelection = null;
    }

    public void addListener(ClasspathModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ClasspathModelListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireNotification(ClasspathModelEvent evt) {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ClasspathModelListener listener = (ClasspathModelListener)this.listeners.get(i);
            listener.modelChanged(evt);
            ++i;
        }
    }

    public void setSelection(ClasspathElement element, boolean selected) {
        element.setSelected(selected);
        if (!this.isWLPModel()) {
            this.updateManifestClasspath();
        } else {
            this.fireNotification(new ClasspathModelEvent(1));
        }
    }

    public void setAllClasspathElementsSelected(boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(selected);
            this.updateManifestClasspath();
        }
    }

    public void setAllClasspathElementsSelected(List elements, boolean selected) {
        ClassPathSelection s = this.getClassPathSelection();
        if (s != null) {
            s.setAllSelected(elements, selected);
            this.updateManifestClasspath();
        }
    }

    public Archive getArchive() {
        return null;
    }

    public void updateManifestClasspath() {
        if (this.classPathSelection != null && this.classPathSelection.isModified()) {
            this.manifest.setClassPath(this.classPathSelection.toString());
            this.fireNotification(new ClasspathModelEvent(1));
        }
    }

    public void updateMainClass(String mainClass) {
        this.manifest.setMainClass(mainClass);
        this.fireNotification(new ClasspathModelEvent(5));
    }

    public void updateImplVersion(String implVersion) {
        this.manifest.setImplemenationVersion(implVersion);
        this.fireNotification(new ClasspathModelEvent(7));
    }

    public void fireSavedEvent() {
        this.fireNotification(new ClasspathModelEvent(6));
    }

    public void primSetManifest(ArchiveManifest mf) {
        this.manifest = mf;
    }

    public void setManifest(ArchiveManifest newManifest) {
        try {
            J2EEProjectUtilities.writeManifest(this.getProject(), newManifest);
        }
        catch (IOException e) {
            this.handleOpenFailureException(e);
        }
        this.getClassPathSelection();
        this.fireNotification(new ClasspathModelEvent(3));
    }

    public void selectEAR(int index) {
        ArchiveManifestImpl mf = new ArchiveManifestImpl((Manifest)((ArchiveManifestImpl)this.getArchive().getManifest()));
        JavaEEArchiveUtilities.INSTANCE.closeArchive(this.earFile);
        this.selectedEARComponent = this.availableEARComponents[index];
        this.initializeSelection((ArchiveManifest)mf);
        this.fireNotification(new ClasspathModelEvent(2));
    }

    public void moveUp(List toMoveUp) {
        this.getClassPathSelection().moveUp(toMoveUp);
        this.updateManifestClasspath();
    }

    public void moveDown(List toMoveDown) {
        this.getClassPathSelection().moveDown(toMoveDown);
        this.updateManifestClasspath();
    }

    public void refresh() {
        ArchiveManifest mf = null;
        if (this.getComponent() != null) {
            mf = J2EEProjectUtilities.readManifest(this.getProject());
        }
        this.refreshAvailableEARs();
        this.resetClassPathSelection(mf);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
    }

    public List getNonResourceFiles() {
        if (this.nonResourceFiles == null) {
            this.initNonResourceFiles();
        }
        return this.nonResourceFiles;
    }

    protected void initNonResourceFiles() {
        if (this.getComponent() == null) {
            return;
        }
        this.nonResourceFiles = new ArrayList(1);
        if (this.isWLPModel) {
            IFile dotProject = this.getComponent().getProject().getFile(".project");
            if (dotProject != null) {
                this.nonResourceFiles.add(dotProject);
            }
        } else {
            IFile mf = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
            if (mf != null) {
                this.nonResourceFiles.add(mf);
            }
        }
    }

    public List getNonResourceInconsistentFiles() {
        return null;
    }

    public boolean isDirty() {
        ClassPathSelection selection = this.getClassPathSelection();
        if (selection == null) {
            return false;
        }
        return selection.isModified();
    }

    public Set getAffectedFiles() {
        HashSet<IFile> result = new HashSet<IFile>();
        IFile aFile = J2EEProjectUtilities.getManifestFile(this.getComponent().getProject());
        if (aFile != null && aFile.exists()) {
            result.add(aFile);
        }
        result.addAll(ProjectUtilities.getFilesAffectedByClasspathChange((IProject)this.getComponent().getProject()));
        return result;
    }

    public List getResources() {
        if (this.isWLPModel) {
            StructureEdit sEdit = null;
            try {
                sEdit = StructureEdit.getStructureEditForWrite((IProject)this.project);
                ModuleStructuralModel structuralModel = sEdit.getModuleStructuralModel();
                ArrayList resources = new ArrayList();
                resources.addAll(structuralModel.getResources());
                ArrayList arrayList = resources;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                List list = Collections.EMPTY_LIST;
                return list;
            }
            finally {
                if (sEdit != null) {
                    sEdit.dispose();
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    public boolean selectDependencyIfNecessary(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(referencedProject)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public boolean selectDependencyIfNecessary(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null || this.classPathSelection.hasDirectOrIndirectDependencyTo(jarName)) {
            return false;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null) {
            this.setSelection(element, true);
            return true;
        }
        return false;
    }

    public void removeDependency(String jarName) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(jarName);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void removeDependency(IProject referencedProject) {
        this.getClassPathSelection();
        if (this.classPathSelection == null) {
            return;
        }
        ClasspathElement element = this.classPathSelection.getClasspathElement(referencedProject);
        if (element != null && element.isValid()) {
            this.setSelection(element, false);
        }
    }

    public void selectFilterLevel(int filterLevel) {
        this.getClassPathSelection();
        if (this.classPathSelection != null) {
            this.classPathSelection.selectFilterLevel(filterLevel);
        }
        this.updateManifestClasspath();
    }

    public ResourceStateValidator getStateValidator() {
        if (this.stateValidator == null) {
            this.stateValidator = this.createStateValidator();
        }
        return this.stateValidator;
    }

    private ResourceStateValidator createStateValidator() {
        return new ResourceStateValidatorImpl((ResourceStateInputProvider)this);
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().checkActivation(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.getStateValidator().lostActivation(presenter);
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().validateState(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        return this.getStateValidator().checkSave(presenter);
    }

    public boolean checkReadOnly() {
        return this.getStateValidator().checkReadOnly();
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public void setComponent(IVirtualComponent component) {
        this.component = component;
    }

    public ClassPathSelection getClassPathSelectionForWLPs() {
        if (this.classPathWLPSelection == null) {
            this.initializeSelectionForWLPs();
        }
        return this.classPathWLPSelection;
    }

    private static IVirtualReference[] getLibModules(IProject project) {
        ArrayList<IVirtualReference> result = new ArrayList<IVirtualReference>();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] refComponents = null;
        refComponents = !comp.isBinary() ? ((J2EEModuleVirtualComponent)comp).getNonManifestReferences() : comp.getReferences();
        int i = 0;
        while (i < refComponents.length) {
            if (refComponents[i].getRuntimePath().equals((Object)WEBLIB)) {
                result.add(refComponents[i]);
            }
            ++i;
        }
        return result.toArray(new IVirtualReference[result.size()]);
    }

    private void initializeSelectionForWLPs() {
        String unresolvedURI;
        this.classPathWLPSelection = new ClassPathSelection();
        this.classPathWLPSelection.setFilterLevel(2);
        HashSet<IProject> existingWebLibProjects = new HashSet<IProject>();
        ArrayList<IVirtualReference> otherExistingWebLibRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] libModules = ClasspathModel.getLibModules(this.component.getProject());
        int i = 0;
        while (i < libModules.length) {
            IVirtualComponent comp = libModules[i].getReferencedComponent();
            if (comp != null && comp.exists()) {
                if (comp.isBinary()) {
                    otherExistingWebLibRefs.add(libModules[i]);
                } else {
                    IProject p = comp.getProject();
                    if (p != null && p.exists()) {
                        existingWebLibProjects.add(p);
                    }
                }
            }
            ++i;
        }
        HashSet possibleWebLibs = new HashSet();
        try {
            List javaProjects = J2EEProjectUtilities.getAllJavaNonFlexProjects();
            possibleWebLibs.addAll(javaProjects);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        IProject[] utilityProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType("jst.utility");
        possibleWebLibs.addAll(Arrays.asList(utilityProjects));
        IProject[] ejbProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType("jst.ejb");
        possibleWebLibs.addAll(Arrays.asList(ejbProjects));
        HashMap pathToComp = new HashMap();
        for (IProject possibleWebLib : possibleWebLibs) {
            IVirtualComponent component;
            if (possibleWebLib.getName().startsWith(".")) continue;
            boolean isExistingWebLib = existingWebLibProjects.contains(possibleWebLib);
            this.classPathWLPSelection.createProjectElement(possibleWebLib, isExistingWebLib);
            if (!isExistingWebLib || (component = ComponentCore.createComponent((IProject)possibleWebLib)) == null) continue;
            this.classPathWLPSelection.buildClasspathComponentDependencyMap(component, pathToComp);
        }
        for (IVirtualReference ref : otherExistingWebLibRefs) {
            IVirtualComponent referencedComponent = ref.getReferencedComponent();
            if (ClasspathDependencyUtil.isClasspathComponentDependency(referencedComponent)) continue;
            try {
                unresolvedURI = ModuleURIUtil.getArchiveName((URI)URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)));
                URI archiveURI = URI.createURI((String)unresolvedURI);
                ClasspathElement element = this.classPathWLPSelection.createArchiveElement(URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)referencedComponent)), referencedComponent.getName(), archiveURI.lastSegment());
                this.classPathWLPSelection.addClasspathElement(element, unresolvedURI);
            }
            catch (UnresolveableURIException e) {
                Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)e);
            }
        }
        for (IVirtualComponent c : pathToComp.values()) {
            URI archiveURI = URI.createURI((String)ModuleURIUtil.getHandleString((IVirtualComponent)c));
            unresolvedURI = null;
            try {
                unresolvedURI = ModuleURIUtil.getArchiveName((URI)archiveURI);
            }
            catch (UnresolveableURIException e) {
                Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)e);
            }
            if (unresolvedURI == null) continue;
            ClasspathElement element = this.classPathWLPSelection.createClasspathArchiveElement(c.getProject(), archiveURI, unresolvedURI);
            this.classPathWLPSelection.addClasspathElement(element, unresolvedURI);
        }
        try {
            this.classPathWLPSelection.createClasspathEntryElements(this.component, WEBLIB);
        }
        catch (CoreException ce) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)ce);
        }
    }

    public boolean isWLPModel() {
        return this.isWLPModel;
    }

    public void setWLPModel(boolean isWLPModel) {
        this.isWLPModel = isWLPModel;
    }
}

