/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.environment.StatusException;

public class LoggerTests
extends TestCase {
    public LoggerTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            LoggerTests.runAll();
        } else if (args.length == 1) {
            String methodToRun = args[0].trim();
            LoggerTests.runOne(methodToRun);
        }
    }

    public static Test suite() {
        return new TestSuite(LoggerTests.class);
    }

    protected static void runAll() {
        TestRunner.run((Test)LoggerTests.suite());
    }

    public static void runOne(String methodName) {
        TestSuite testSuite = new TestSuite();
        LoggerTests test = new LoggerTests(methodName);
        System.out.println("Calling LoggerTests." + methodName);
        testSuite.addTest((Test)test);
        TestRunner.run((Test)testSuite);
    }

    public void testLogger() {
        IEnvironment environment = EnvironmentService.getEclipseConsoleEnvironment();
        ILog logger = environment.getLog();
        if (logger.isEnabled()) {
            System.out.println(" Logging is enabled");
        } else {
            System.out.println(" Logging is is not enabled");
        }
        LoggerTests.assertTrue((String)"Logging feature enabled", (!logger.isEnabled("bad option") ? 1 : 0) != 0);
        logger.log(4, 0, (Object)this, "test logger", Status.CANCEL_STATUS);
        logger.log(1, 1, (Object)this, "another method", (Object)"object");
        logger.log(2, 3, (Object)this, "one more method", (Throwable)new StatusException(Status.OK_STATUS));
        logger.log(4, "option1", 0, (Object)this, "test logger", Status.CANCEL_STATUS);
        logger.log(1, "option2", 1, (Object)this, "another method", (Object)"object");
        logger.log(2, "option3", 3, (Object)this, "one more method", (Throwable)new StatusException(Status.OK_STATUS));
    }
}

