/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public final class PublishUtil {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final File tempDir = ServerPlugin.getInstance().getStateLocation().toFile();
    private static final String TEMPFILE_PREFIX = "tmp";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private PublishUtil() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFile(InputStream in, IPath to, long ts, IModuleFile mf) throws CoreException {
        OutputStream out;
        block18: {
            out = null;
            File tempFile = null;
            try {
                try {
                    File file = to.toFile();
                    tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + to.getFileExtension(), tempDir);
                    out = new FileOutputStream(tempFile);
                    int avail = in.read(buf);
                    while (true) {
                        block19: {
                            if (avail > 0) break block19;
                            out.close();
                            out = null;
                            PublishUtil.moveTempFile(tempFile, file);
                            if (ts != -1L && ts != 0L) {
                                file.setLastModified(ts);
                            }
                            break;
                        }
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    IPath path = mf.getModuleRelativePath().append(mf.getName());
                    Trace.trace(3, "Error copying file: " + to.toOSString() + " to " + path.toOSString(), e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object)path.toOSString(), (Object)e.getLocalizedMessage()), null));
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (tempFile != null && tempFile.exists()) {
                    tempFile.deleteOnExit();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var9_13 = null;
                if (tempFile == null || !tempFile.exists()) break block18;
                tempFile.deleteOnExit();
            }
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (out == null) return;
        out.close();
    }

    public static IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
        if (!dir.exists() || !dir.isDirectory()) {
            return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null)};
        }
        ArrayList<Status> status = new ArrayList<Status>(2);
        try {
            File[] files = dir.listFiles();
            int size = files.length;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
            boolean deleteCurrent = true;
            int i = 0;
            while (i < size) {
                File current = files[i];
                if (current.isFile()) {
                    if (!current.delete()) {
                        status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)files[i].getAbsolutePath()), null));
                        deleteCurrent = false;
                    }
                    monitor.worked(10);
                } else if (current.isDirectory()) {
                    monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                    IStatus[] stat = PublishUtil.deleteDirectory(current, ProgressUtil.getSubMonitorFor(monitor, 10));
                    if (stat != null && stat.length > 0) {
                        deleteCurrent = false;
                        PublishUtil.addArrayToList(status, stat);
                    }
                }
                ++i;
            }
            if (deleteCurrent && !dir.delete()) {
                status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)dir.getAbsolutePath()), null));
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace(3, "Error deleting directory " + dir.getAbsolutePath(), e);
            status.add(new Status(4, "org.eclipse.wst.server.core", 0, e.getLocalizedMessage(), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public static IStatus[] publishSmart(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        int toSize;
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList<Object> status = new ArrayList<Object>(2);
        File toDir = path.toFile();
        int fromSize = resources.length;
        String[] fromFileNames = new String[fromSize];
        int i = 0;
        while (i < fromSize) {
            fromFileNames[i] = resources[i].getName();
            ++i;
        }
        File[] toFiles = null;
        String[] toFileNames = null;
        boolean foundExistingDir = false;
        if (toDir.exists()) {
            if (toDir.isDirectory()) {
                foundExistingDir = true;
                toFiles = toDir.listFiles();
                toSize = toFiles.length;
                toFileNames = new String[toSize];
                int i2 = 0;
                while (i2 < toSize) {
                    toFileNames[i2] = toFiles[i2].getName();
                    boolean isDir = toFiles[i2].isDirectory();
                    boolean found = false;
                    int j = 0;
                    while (j < fromSize) {
                        if (toFileNames[i2].equals(fromFileNames[j]) && isDir == resources[j] instanceof IModuleFolder) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        if (isDir) {
                            IStatus[] stat = PublishUtil.deleteDirectory(toFiles[i2], null);
                            PublishUtil.addArrayToList(status, stat);
                        } else if (!toFiles[i2].delete()) {
                            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toFiles[i2].getAbsolutePath()), null));
                        }
                        toFiles[i2] = null;
                        toFileNames[i2] = null;
                    }
                    ++i2;
                }
            } else if (!toDir.delete()) {
                status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)toDir.getAbsolutePath()), null));
                IStatus[] stat = new IStatus[status.size()];
                status.toArray(stat);
                return stat;
            }
        }
        if (!foundExistingDir && !toDir.mkdirs()) {
            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)toDir.getAbsolutePath()), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(50);
        if (toFiles == null) {
            toFiles = toDir.listFiles();
        }
        toSize = 0;
        if (toFiles != null) {
            toSize = toFiles.length;
        }
        int dw = 0;
        if (toSize > 0) {
            dw = 500 / toSize;
        }
        if (toFileNames == null) {
            toFileNames = new String[toSize];
        }
        long[] toFileMod = new long[toSize];
        int i3 = 0;
        while (i3 < toSize) {
            if (toFiles[i3] != null) {
                if (toFileNames[i3] != null) {
                    toFileNames[i3] = toFiles[i3].getName();
                }
                toFileMod[i3] = toFiles[i3].lastModified();
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < fromSize) {
            IModuleResource current = resources[i3];
            String name = fromFileNames[i3];
            boolean currentIsDir = current instanceof IModuleFolder;
            if (!currentIsDir) {
                IFile file;
                boolean copy = true;
                IModuleFile mf = (IModuleFile)current;
                long mod = -1L;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IFile)mf.getAdapter(clazz)) != null) {
                    mod = file.getLocalTimeStamp();
                } else {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    File file2 = (File)mf.getAdapter(clazz2);
                    mod = file2.lastModified();
                }
                int j = 0;
                while (j < toSize) {
                    if (name.equals(toFileNames[j]) && mod == toFileMod[j]) {
                        copy = false;
                    }
                    ++j;
                }
                if (copy) {
                    try {
                        PublishUtil.copyFile(mf, path.append(name));
                    }
                    catch (CoreException ce) {
                        status.add(ce.getStatus());
                    }
                }
                monitor.worked(dw);
            } else {
                IModuleFolder folder = (IModuleFolder)current;
                IModuleResource[] children = folder.members();
                monitor.subTask(NLS.bind((String)Messages.copyingTask, (Object[])new String[]{name, name}));
                IStatus[] stat = PublishUtil.publishSmart(children, path.append(name), ProgressUtil.getSubMonitorFor(monitor, dw));
                PublishUtil.addArrayToList(status, stat);
            }
            ++i3;
        }
        if (monitor.isCanceled()) {
            return new IStatus[]{Status.CANCEL_STATUS};
        }
        monitor.worked(500 - dw * toSize);
        monitor.done();
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public static IStatus[] publishDelta(IModuleResourceDelta[] delta, IPath path, IProgressMonitor monitor) {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList status = new ArrayList(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            IStatus[] stat = PublishUtil.publishDelta(delta[i], path, monitor);
            PublishUtil.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public static IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IProgressMonitor monitor) {
        IPath path2;
        File file;
        IPath path22;
        File file2;
        ArrayList<Object> status = new ArrayList<Object>(2);
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file3 = (IModuleFile)resource;
            try {
                if (kind2 == 3) {
                    PublishUtil.deleteFile2(path, file3);
                } else {
                    IPath path23 = path.append(file3.getModuleRelativePath()).append(file3.getName());
                    File f = path23.toFile().getParentFile();
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    PublishUtil.copyFile(file3, path23);
                }
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        if (kind2 == 1 && !(file2 = (path22 = path.append(resource.getModuleRelativePath()).append(resource.getName())).toFile()).exists() && !file2.mkdirs()) {
            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorMkdir, (Object)path22), null));
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = PublishUtil.publishDelta(childDeltas[i], path, monitor);
            PublishUtil.addArrayToList(status, stat);
            ++i;
        }
        if (kind2 == 3 && (file = (path2 = path.append(resource.getModuleRelativePath()).append(resource.getName())).toFile()).exists() && !file.delete()) {
            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private static void deleteFile2(IPath path, IModuleFile file) throws CoreException {
        Trace.trace(11, "Deleting: " + file.getName() + " from " + path.toString());
        IPath path2 = path.append(file.getModuleRelativePath()).append(file.getName());
        if (path2.toFile().exists() && !path2.toFile().delete()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
    }

    private static void copyFile(IModuleFile mf, IPath path) throws CoreException {
        IFile file;
        Trace.trace(11, "Copying: " + mf.getName() + " to " + path.toString());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)mf.getAdapter(clazz)) != null) {
            PublishUtil.copyFile(file.getContents(), path, file.getLocalTimeStamp(), mf);
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            File file2 = (File)mf.getAdapter(clazz2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file2);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file2.getAbsolutePath()), (Throwable)e));
            }
            PublishUtil.copyFile(in, path, file2.lastModified(), mf);
        }
    }

    public static IStatus[] publishFull(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        ArrayList status = new ArrayList(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = PublishUtil.copy(resources[i], path, monitor);
            PublishUtil.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private static IStatus[] copy(IModuleResource resource, IPath path, IProgressMonitor monitor) {
        String name = resource.getName();
        Trace.trace(11, "Copying: " + name + " to " + path.toString());
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            IStatus[] stat = PublishUtil.publishFull(folder.members(), path, monitor);
            PublishUtil.addArrayToList(status, stat);
        } else {
            IModuleFile mf = (IModuleFile)resource;
            File f = (path = path.append(mf.getModuleRelativePath()).append(name)).toFile().getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            try {
                PublishUtil.copyFile(mf, path);
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    /*
     * Exception decompiling
     */
    public static IStatus[] publishZip(IModuleResource[] resources, IPath path, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 230->233)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addZipEntries(ZipOutputStream zout, IModuleResource[] resources) throws Exception {
        if (resources == null) {
            return;
        }
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IModuleResource mf;
            if (resources[i] instanceof IModuleFolder) {
                IContainer folder;
                mf = (IModuleFolder)resources[i];
                IModuleResource[] res = mf.members();
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                String entryPath = path.toPortableString();
                if (!entryPath.endsWith("/")) {
                    entryPath = String.valueOf(entryPath) + '/';
                }
                ZipEntry ze = new ZipEntry(entryPath);
                long ts = 0L;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IContainer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((folder = (IContainer)mf.getAdapter(clazz)) != null) {
                    ts = folder.getLocalTimeStamp();
                }
                if (ts != -1L && ts != 0L) {
                    ze.setTime(ts);
                }
                zout.putNextEntry(ze);
                zout.closeEntry();
                PublishUtil.addZipEntries(zout, res);
            } else {
                Object var12_14;
                IFile file;
                mf = (IModuleFile)resources[i];
                IPath path = mf.getModuleRelativePath().append(mf.getName());
                ZipEntry ze = new ZipEntry(path.toPortableString());
                InputStream in = null;
                long ts = 0L;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((file = (IFile)mf.getAdapter(clazz)) != null) {
                    ts = file.getLocalTimeStamp();
                    in = file.getContents();
                } else {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    File file2 = (File)mf.getAdapter(clazz2);
                    ts = file2.lastModified();
                    in = new FileInputStream(file2);
                }
                if (ts != -1L && ts != 0L) {
                    ze.setTime(ts);
                }
                zout.putNextEntry(ze);
                try {
                    int n = 0;
                    while (n > -1) {
                        n = in.read(buf);
                        if (n <= 0) continue;
                        zout.write(buf, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    var12_14 = null;
                    in.close();
                    throw throwable;
                }
                {
                    var12_14 = null;
                }
                in.close();
                zout.closeEntry();
            }
            ++i;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void moveTempFile(File tempFile, File file) throws CoreException {
        if (file.exists() && !PublishUtil.safeDelete(file, 2)) {
            try {
                try {
                    FileInputStream in = new FileInputStream(tempFile);
                    IStatus status = PublishUtil.copyFile(in, file.getPath());
                    if (!status.isOK()) {
                        MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)file.toString()), null);
                        status2.add(status);
                        throw new CoreException((IStatus)status2);
                    }
                    Object var5_5 = null;
                    tempFile.delete();
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                tempFile.delete();
                throw throwable;
            }
            Object var5_7 = null;
            tempFile.delete();
        }
        if (PublishUtil.safeRename(tempFile, file, 10)) return;
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorRename, (Object)tempFile.toString()), null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IStatus copyFile(InputStream in, String to) {
        IStatus iStatus;
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(to);
                int avail = in.read(buf);
                while (true) {
                    if (avail <= 0) {
                        iStatus = Status.OK_STATUS;
                        Object var4_7 = null;
                        break;
                    }
                    ((OutputStream)out).write(buf, 0, avail);
                    avail = in.read(buf);
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error copying file", e);
                Status status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                Object var4_8 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out == null) return status;
                    ((OutputStream)out).close();
                    return status;
                }
                catch (Exception exception) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {}
            catch (Exception exception) {}
            if (in != null) {
                in.close();
            }
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            if (out == null) throw throwable;
            ((OutputStream)out).close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (in != null) {
            in.close();
        }
        try {}
        catch (Exception exception) {}
        if (out == null) return iStatus;
        ((OutputStream)out).close();
        return iStatus;
    }

    private static boolean safeDelete(File f, int retrys) {
        int count = 0;
        while (count < retrys) {
            if (!f.exists()) {
                return true;
            }
            f.delete();
            if (!f.exists()) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static boolean safeRename(File from, File to, int retrys) {
        File dir = to.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        int count = 0;
        while (count < retrys) {
            if (from.renameTo(to)) {
                return true;
            }
            if (++count >= retrys) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

