/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.etools.common.test.apitools.ProjectUnzipUtil;
import org.eclipse.wst.common.tests.CommonTestsPlugin;

public class TestWorkspace {
    public static final String PROJECT_NAME = "WebModule1";
    public static final String WEB_MODULE_1_NAME = "WebModule1";
    public static final String WEB_MODULE_2_NAME = "WebModule2";
    public static final String NEW_WEB_MODULE_NAME = "NewWebModule";
    public static final String META_INF = "META-INF";
    public static final String WEB_INF = "WEB-INF";
    private static Path zipFilePath = new Path("testData/TestVirtualAPI.zip");
    public static final IProject TEST_PROJECT = ResourcesPlugin.getWorkspace().getRoot().getProject("WebModule1");
    public static final String[] MODULE_NAMES = new String[]{"WebModule1", "WebModule2"};

    public static IProject getTargetProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("WebModule1");
    }

    public static void init() {
        try {
            IProject project = TestWorkspace.getTargetProject();
            if (!project.exists()) {
                TestWorkspace.createProject();
            }
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean createProject() {
        IPath localZipPath = TestWorkspace.getLocalPath();
        ProjectUnzipUtil util = new ProjectUnzipUtil(localZipPath, new String[]{"WebModule1"});
        return util.createProjects();
    }

    private static IPath getLocalPath() {
        URL url = CommonTestsPlugin.instance.find((IPath)zipFilePath);
        try {
            url = Platform.asLocalURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Path(url.getPath());
    }
}

