/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;

public class ArchiveURIConverter
extends URIConverterImpl {
    private IArchive archive = null;
    protected Map uriToPathMap = new HashMap();
    protected Map pathToURIMap = new HashMap();

    public ArchiveURIConverter(IArchive archive) {
        this.archive = archive;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public final URI getURI(IPath path) {
        if (!this.pathToURIMap.containsKey(path)) {
            URI uri = this.convertPathToURI(path);
            this.uriToPathMap.put(uri, path);
            this.pathToURIMap.put(path, uri);
            return uri;
        }
        return (URI)this.pathToURIMap.get(path);
    }

    protected URI convertPathToURI(IPath path) {
        return URI.createURI((String)path.toString());
    }

    public final IPath getPath(URI uri) {
        return (IPath)this.uriToPathMap.get(uri);
    }

    public InputStream createInputStream(URI uri) throws IOException {
        IPath path = this.getPath(uri);
        try {
            IArchiveResource archiveResource = this.getArchive().getArchiveResource(path);
            return archiveResource.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}

