/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class J2EEModuleVirtualComponent
extends VirtualComponent
implements IComponentImplFactory {
    public J2EEModuleVirtualComponent() {
    }

    public J2EEModuleVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new J2EEModuleVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new VirtualFolder(aProject, aRuntimePath);
    }

    public IVirtualReference[] getNonJavaReferences() {
        return this.getReferences(false);
    }

    public IVirtualReference[] getReferences() {
        return this.getReferences(true);
    }

    private IVirtualReference[] getReferences(boolean getJavaRefs) {
        IVirtualReference[] hardReferences = this.getNonManifestReferences(getJavaRefs);
        List dynamicReferences = J2EEModuleVirtualComponent.getManifestReferences((IVirtualComponent)this, hardReferences);
        IVirtualReference[] references = null;
        if (dynamicReferences == null) {
            references = hardReferences;
        } else {
            references = new IVirtualReference[hardReferences.length + dynamicReferences.size()];
            System.arraycopy(hardReferences, 0, references, 0, hardReferences.length);
            int i = 0;
            while (i < dynamicReferences.size()) {
                references[hardReferences.length + i] = (IVirtualReference)dynamicReferences.get(i);
                ++i;
            }
        }
        return references;
    }

    public IVirtualReference[] getNonManifestReferences() {
        return this.getNonManifestReferences(true);
    }

    public IVirtualReference[] getNonManifestReferences(boolean getJavaRefs) {
        ArrayList<IVirtualReference> allRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardReferences = super.getReferences();
        int i = 0;
        while (i < hardReferences.length) {
            allRefs.add(hardReferences[i]);
            ++i;
        }
        if (getJavaRefs) {
            IVirtualReference[] cpRefs = this.getJavaClasspathReferences(hardReferences);
            int i2 = 0;
            while (i2 < cpRefs.length) {
                allRefs.add(cpRefs[i2]);
                ++i2;
            }
        }
        return allRefs.toArray(new IVirtualReference[allRefs.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getManifestClasspath(IVirtualComponent moduleComponent) {
        String[] manifestClasspath = null;
        if (moduleComponent.isBinary()) return ((J2EEModuleVirtualArchiveComponent)moduleComponent).getManifestClasspath();
        IVirtualFile vManifest = moduleComponent.getRootFolder().getFile("META-INF/MANIFEST.MF");
        if (!vManifest.exists()) return manifestClasspath;
        IFile manifestFile = vManifest.getUnderlyingFile();
        InputStream in = null;
        try {
            try {
                in = manifestFile.getContents();
                ArchiveManifestImpl manifest = new ArchiveManifestImpl(in);
                manifestClasspath = manifest.getClassPathTokenized();
                return manifestClasspath;
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
                if (in == null) return manifestClasspath;
                try {
                    in.close();
                    in = null;
                    return manifestClasspath;
                }
                catch (IOException e2) {
                    Logger.getLogger().logError((Throwable)e2);
                }
                return manifestClasspath;
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
                if (in == null) return manifestClasspath;
                try {
                    in.close();
                    in = null;
                    return manifestClasspath;
                }
                catch (IOException e3) {
                    Logger.getLogger().logError((Throwable)e3);
                }
                return manifestClasspath;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
        }
    }

    public IVirtualReference[] getJavaClasspathReferences() {
        return this.getJavaClasspathReferences(null);
    }

    private IVirtualReference[] getJavaClasspathReferences(IVirtualReference[] hardReferences) {
        IProject project = this.getProject();
        ArrayList<IVirtualReference> cpRefs = new ArrayList<IVirtualReference>();
        boolean isWebApp = J2EEProjectUtilities.isDynamicWebComponent((IVirtualComponent)this);
        try {
            if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
                return new IVirtualReference[0];
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null) {
                return new IVirtualReference[0];
            }
            Map referencedEntries = ClasspathDependencyUtil.getComponentClasspathDependencies(javaProject, isWebApp);
            if (referencedEntries.isEmpty()) {
                return new IVirtualReference[0];
            }
            if (hardReferences == null) {
                hardReferences = super.getReferences();
            }
            IPath[] hardRefPaths = new IPath[hardReferences.length];
            int j = 0;
            while (j < hardReferences.length) {
                IVirtualComponent comp = hardReferences[j].getReferencedComponent();
                if (comp.isBinary()) {
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                    File diskFile = archiveComp.getUnderlyingDiskFile();
                    Path diskPath = null;
                    if (diskFile.exists()) {
                        diskPath = new Path(diskFile.getAbsolutePath());
                    } else {
                        IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
                        diskPath = iFile.getFullPath();
                    }
                    hardRefPaths[j] = diskPath;
                }
                ++j;
            }
            for (IClasspathEntry entry : referencedEntries.keySet()) {
                IClasspathAttribute attrib = (IClasspathAttribute)referencedEntries.get(entry);
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp);
                boolean add = true;
                IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
                if (entryLocation == null) {
                    add = false;
                } else {
                    int j2 = 0;
                    while (j2 < hardRefPaths.length) {
                        if (entryLocation.equals((Object)hardRefPaths[j2])) {
                            add = false;
                            break;
                        }
                        ++j2;
                    }
                }
                if (!add) continue;
                String componentPath = "cpe/" + entryLocation.toPortableString();
                VirtualArchiveComponent entryComponent = (VirtualArchiveComponent)ComponentCore.createArchiveComponent((IProject)project, (String)componentPath);
                IVirtualReference entryReference = ComponentCore.createReference((IVirtualComponent)this, (IVirtualComponent)entryComponent, (IPath)runtimePath);
                entryReference.setArchiveName(ClasspathDependencyUtil.getArchiveName(entry));
                cpRefs.add(entryReference);
            }
        }
        catch (CoreException jme) {
            Logger.getLogger().logError((Throwable)jme);
        }
        return cpRefs.toArray(new IVirtualReference[cpRefs.size()]);
    }

    public static List getManifestReferences(IVirtualComponent moduleComponent, IVirtualReference[] hardReferences) {
        ArrayList<IVirtualReference> dynamicReferences = null;
        String[] manifestClasspath = J2EEModuleVirtualComponent.getManifestClasspath(moduleComponent);
        IVirtualReference foundRef = null;
        String earArchiveURI = null;
        boolean simplePath = false;
        if (manifestClasspath != null && manifestClasspath.length > 0) {
            IProject[] earProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType("jst.ear");
            IVirtualReference[] earRefs = null;
            int i = 0;
            while (i < earProjects.length && earRefs == null) {
                IVirtualComponent tempEARComponent = ComponentCore.createComponent((IProject)earProjects[i]);
                IVirtualReference[] tempEarRefs = tempEARComponent.getReferences();
                int j = 0;
                while (j < tempEarRefs.length && earRefs == null) {
                    if (tempEarRefs[j].getReferencedComponent().equals(moduleComponent)) {
                        earRefs = tempEarRefs;
                        foundRef = tempEarRefs[j];
                        earArchiveURI = foundRef.getArchiveName();
                        simplePath = earArchiveURI != null ? earArchiveURI.lastIndexOf("/") == -1 : true;
                    }
                    ++j;
                }
                ++i;
            }
            if (earRefs != null) {
                i = 0;
                while (i < manifestClasspath.length) {
                    boolean found = false;
                    int j = 0;
                    while (j < earRefs.length && !found) {
                        String archiveName;
                        if (foundRef != earRefs[j] && (archiveName = earRefs[j].getArchiveName()) != null) {
                            boolean shouldAdd = false;
                            if (simplePath && manifestClasspath[i].lastIndexOf("/") == -1) {
                                shouldAdd = archiveName.equals(manifestClasspath[i]);
                            } else {
                                String earRelativeURI = ArchiveUtil.deriveEARRelativeURI((String)manifestClasspath[i], (String)earArchiveURI);
                                if (earRelativeURI != null) {
                                    shouldAdd = earRelativeURI.equals(archiveName);
                                }
                            }
                            if (shouldAdd) {
                                found = true;
                                boolean shouldInclude = true;
                                IVirtualComponent dynamicComponent = earRefs[j].getReferencedComponent();
                                if (hardReferences != null) {
                                    int k = 0;
                                    while (k < hardReferences.length && shouldInclude) {
                                        if (hardReferences[k].getReferencedComponent().equals(dynamicComponent)) {
                                            shouldInclude = false;
                                        }
                                        ++k;
                                    }
                                }
                                if (shouldInclude) {
                                    IVirtualReference dynamicReference = ComponentCore.createReference((IVirtualComponent)moduleComponent, (IVirtualComponent)dynamicComponent);
                                    if (dynamicReferences == null) {
                                        dynamicReferences = new ArrayList<IVirtualReference>();
                                    }
                                    dynamicReferences.add(dynamicReference);
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return dynamicReferences;
    }
}

