/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRoot;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public abstract class IVirtualResourceAPITest
extends TestCase {
    protected IVirtualContainer virtualParent;
    protected IVirtualResource targetExistingVirtualResource;
    protected IResource targetExistingPlatformResource;
    protected IVirtualFolder targetVirtualResourceToDelete;
    protected IResource targetPlatformResourceToDelete;
    protected IVirtualResource targetVirtualResourceToCreate = null;
    protected IVirtualResource targetMultiVirtualResource = null;
    protected IProject expectedProject;
    protected IPath expectedRuntimePath;
    protected String expectedName;
    private static final String PROJECT_NAME = null;

    public IVirtualResourceAPITest(String name) {
        super(name);
    }

    protected final void setUp() throws Exception {
        TestWorkspace.init();
        this.doSetup();
        this.assertRequirements();
    }

    protected void assertRequirements() {
    }

    protected abstract void doSetup() throws Exception;

    public void testCreateLinkIPathintIProgressMonitor() throws Exception {
        IVirtualComponent component = ComponentCore.createComponent((IProject)TestWorkspace.getTargetProject(), (String)"WebModule2");
        IVirtualFolder rootFolder = component.getRootFolder();
        IVirtualFolder images = rootFolder.getFolder((IPath)new Path("/images"));
        images.createLink((IPath)new Path("/WebModule2/images"), 0, null);
        IFolder realImages = TestWorkspace.getTargetProject().getFolder((IPath)new Path("/WebModule2/images"));
        IVirtualResourceAPITest.assertTrue((String)"The /WebContent2/images directory must exist.", (boolean)realImages.exists());
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForRead((IProject)TestWorkspace.getTargetProject());
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            ComponentResource[] componentResources = wbComponent.findResourcesByRuntimePath((IPath)new Path("/images"));
            IVirtualResourceAPITest.assertTrue((String)"There should be at least one mapping for virtual path \"/images\".", (componentResources.length > 0 ? 1 : 0) != 0);
            ResourceTreeRoot resourceTreeRoot = ResourceTreeRoot.getSourceResourceTreeRoot((WorkbenchComponent)wbComponent);
            componentResources = resourceTreeRoot.findModuleResources(realImages.getFullPath(), 0);
            IVirtualResourceAPITest.assertTrue((String)("There should be exactly one Component resource with the source path \"" + realImages.getProjectRelativePath() + "\"."), (componentResources.length == 1 ? 1 : 0) != 0);
            IVirtualResourceAPITest.assertTrue((String)"The runtime path should match \"/images\".", (boolean)componentResources[0].getRuntimePath().toString().equals("/images"));
            images.createLink((IPath)new Path("/WebModule2/images"), 0, null);
            componentResources = resourceTreeRoot.findModuleResources(realImages.getFullPath(), 0);
            IVirtualResourceAPITest.assertTrue((String)("There should be exactly one Component resource with the source path \"" + realImages.getProjectRelativePath() + "\"."), (componentResources.length == 1 ? 1 : 0) != 0);
            IVirtualResourceAPITest.assertTrue((String)"The runtime path should match \"/images\".", (boolean)componentResources[0].getRuntimePath().toString().equals("/images"));
        }
        finally {
            if (moduleCore != null) {
                moduleCore.dispose();
            }
        }
    }

    public void testEquals() throws Exception {
    }

    public void testExists() throws Exception {
    }

    public void testGetFileExtension() {
        IVirtualResourceAPITest.assertTrue((String)"The existing virtual resource should have no file extension.", (this.targetExistingVirtualResource.getFileExtension() == null ? 1 : 0) != 0);
    }

    public void testGetWorkspaceRelativePath() {
        IPath realPath = this.targetExistingPlatformResource.getFullPath();
        IPath virtualPath = this.targetExistingVirtualResource.getWorkspaceRelativePath();
        IVirtualResourceAPITest.assertEquals((String)"The workspace relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetProjectRelativePath() {
        IPath realPath = this.targetExistingPlatformResource.getProjectRelativePath();
        IPath virtualPath = this.targetExistingVirtualResource.getProjectRelativePath();
        IVirtualResourceAPITest.assertEquals((String)"The project relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetRuntimePath() {
        IPath virtualPath = this.targetExistingVirtualResource.getRuntimePath();
        IVirtualResourceAPITest.assertEquals((String)"The runtime path of the virtual resource must match the real resource", (Object)this.expectedRuntimePath, (Object)virtualPath);
    }

    public void testGetName() {
        IVirtualResourceAPITest.assertEquals((String)"The name of the virtual resource must match the expected name.", (String)this.expectedName, (String)this.targetExistingVirtualResource.getName());
    }

    public void testGetParent() {
        IVirtualResourceAPITest.assertEquals((String)"The parent of the virtual resource must match the component.", (Object)this.virtualParent, (Object)this.targetExistingVirtualResource.getParent());
    }

    public void testGetProject() {
        IVirtualResourceAPITest.assertEquals((String)"The project of the virtual resource must match the test project.", (Object)this.expectedProject, (Object)this.targetExistingVirtualResource.getProject());
    }

    public void testGetType() {
        IVirtualResourceAPITest.assertEquals((String)"The type of the virtual resource must match the test project.", (int)2, (int)this.targetExistingVirtualResource.getType());
    }

    public void testGetComponent() {
        IVirtualResourceAPITest.assertEquals((String)"The component name of the virtual resource must match the test project.", (String)"WebModule1", (String)this.targetExistingVirtualResource.getComponent().getName());
    }

    public void testIsAccessible() {
        IVirtualResourceAPITest.assertEquals((String)"The platform resource should be accessible only if the virtual resource is accessible.", (boolean)this.targetExistingPlatformResource.isAccessible(), (boolean)this.targetExistingPlatformResource.isAccessible());
    }

    public void testDeleteintIProgressMonitor() throws Exception {
        this.targetVirtualResourceToDelete.delete(0, null);
        IVirtualResourceAPITest.assertTrue((String)"The real folder should be deleted when IVirtualResource.DELETE_METAMODEL_ONLY is NOT supplied.", (!this.targetPlatformResourceToDelete.exists() ? 1 : 0) != 0);
        IVirtualResource[] members = this.virtualParent.members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getRuntimePath().equals((Object)this.targetVirtualResourceToDelete.getRuntimePath())) {
                IVirtualResourceAPITest.fail((String)"Found deleted folder in members()");
            }
            ++i;
        }
    }

    public void testDeleteintIProgressMonitor2() throws Exception {
        this.targetVirtualResourceToDelete.delete(1024, null);
        IVirtualResourceAPITest.assertTrue((String)"The real resource should not be deleted when IVirtualResource.IGNORE_UNDERLYING_RESOURCE is supplied.", (boolean)this.targetPlatformResourceToDelete.exists());
        StructureEdit moduleCore = null;
        try {
            moduleCore = StructureEdit.getStructureEditForWrite((IProject)this.expectedProject);
            WorkbenchComponent wbComponent = moduleCore.getComponent();
            ComponentResource[] resources = wbComponent.findResourcesByRuntimePath(this.targetVirtualResourceToDelete.getRuntimePath());
            IVirtualResourceAPITest.assertTrue((String)"There should be no matching resources found in the model.", (resources.length == 0 ? 1 : 0) != 0);
        }
        finally {
            if (moduleCore != null) {
                moduleCore.saveIfNecessary(null);
                moduleCore.dispose();
            }
        }
    }

    public void testDeleteintIProgressMonitor3() throws Exception {
        this.targetVirtualResourceToDelete.delete(256, null);
        IVirtualResourceAPITest.assertTrue((String)"The real resource should be deleted when IVirtualResource.IGNORE_UNDERLYING_RESOURCE is NOT supplied.", (!this.targetPlatformResourceToDelete.exists() ? 1 : 0) != 0);
        IVirtualResource[] members = this.virtualParent.members();
        int i = 0;
        while (i < members.length) {
            if (members[i].getRuntimePath().equals((Object)this.targetVirtualResourceToDelete.getRuntimePath())) {
                IVirtualResourceAPITest.fail((String)"Found deleted folder in members()");
            }
            ++i;
        }
    }

    public void testGetUnderlyingResource() {
        IResource platformResourceToCreate = this.targetVirtualResourceToCreate.getUnderlyingResource();
        int expectedType = this.determineExpectedType(this.targetVirtualResourceToCreate);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)platformResourceToCreate.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (!platformResourceToCreate.exists() ? 1 : 0) != 0);
        expectedType = this.determineExpectedType(this.targetExistingVirtualResource);
        IResource exitingPlatformResource = this.targetExistingVirtualResource.getUnderlyingResource();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)exitingPlatformResource.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should exist.", (boolean)exitingPlatformResource.exists());
        expectedType = this.determineExpectedType(this.targetMultiVirtualResource);
        IResource multiPlatformResource = this.targetMultiVirtualResource.getUnderlyingResource();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)multiPlatformResource.getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should exist.", (boolean)multiPlatformResource.exists());
    }

    public void testGetUnderlyingResources() {
        int expectedType = this.determineExpectedType(this.targetVirtualResourceToCreate);
        IResource[] platformResourcesToCreate = this.targetVirtualResourceToCreate.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"There should only be one resource in the result array.", (int)1, (int)platformResourcesToCreate.length);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)platformResourcesToCreate[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (!platformResourcesToCreate[0].exists() ? 1 : 0) != 0);
        expectedType = this.determineExpectedType(this.targetExistingVirtualResource);
        IResource[] existingPlatformResource = this.targetExistingVirtualResource.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"There should only be one resource in the result array.", (int)1, (int)existingPlatformResource.length);
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)existingPlatformResource[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (boolean)existingPlatformResource[0].exists());
        expectedType = this.determineExpectedType(this.targetMultiVirtualResource);
        IResource[] multiPlatformResources = this.targetMultiVirtualResource.getUnderlyingResources();
        IVirtualResourceAPITest.assertEquals((String)"The type of the underlying resource should match the expected type.", (int)expectedType, (int)multiPlatformResources[0].getType());
        IVirtualResourceAPITest.assertTrue((String)"The underyling resource should not exist.", (boolean)multiPlatformResources[0].exists());
    }

    private int determineExpectedType(IVirtualResource aVirtualResource) {
        switch (this.targetVirtualResourceToCreate.getType()) {
            case 16: {
                return 1;
            }
            case 32: 
            case 64: {
                return 2;
            }
        }
        return 0;
    }
}

