/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class DefaultingUtils {
    public static String getDefaultEARProjectName(String projectName) {
        if (projectName != null && projectName.length() > 0) {
            String baseEARName;
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (proj.exists()) {
                IVirtualComponent[] ears = J2EEUtils.getReferencingEARComponents((IProject)proj);
                if (ears != null && ears.length > 0) {
                    return ears[0].getName();
                }
                IVirtualComponent[] allEarComps = J2EEUtils.getAllEARComponents();
                if (allEarComps.length > 0) {
                    int i = 0;
                    while (i < allEarComps.length) {
                        IProject earProject = allEarComps[i].getProject();
                        IStatus associationStatus = J2EEUtils.canAssociateProjectToEAR((IProject)proj, (IProject)earProject);
                        if (associationStatus.getSeverity() == 0) {
                            return allEarComps[i].getName();
                        }
                        ++i;
                    }
                }
            }
            String earName = baseEARName = String.valueOf(projectName) + ResourceUtils.getDefaultEARExtension();
            boolean foundEAR = false;
            int i = 1;
            while (!foundEAR) {
                IStatus canCreateEARStatus = J2EEUtils.canCreateEAR((IProject)ProjectUtilities.getProject((String)earName));
                if (canCreateEARStatus.isOK()) {
                    foundEAR = true;
                    continue;
                }
                earName = String.valueOf(baseEARName) + i;
                ++i;
            }
            return earName;
        }
        return ResourceUtils.getDefaultServiceEARProjectName();
    }
}

