/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jst.j2ee.client.internal.util.ClientAdapterFactory;
import org.eclipse.jst.j2ee.internal.provider.ApplicationClientItemProvider;

public class ClientItemProviderAdapterFactory
extends ClientAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection supportedTypes = new ArrayList();
    protected ApplicationClientItemProvider applicationClientItemProvider;
    protected Disposable disposable = new Disposable();

    public ClientItemProviderAdapterFactory() {
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(ITableItemLabelProvider.class);
    }

    public Adapter adapt(Notifier target, Object adapterKey) {
        return super.adapt(target, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (object instanceof EObject && ((EObject)object).eClass() == null) {
            return null;
        }
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public Adapter adaptNew(Notifier target, Object adapterType) {
        Adapter adapter = super.adaptNew(target, adapterType);
        this.disposable.add((Object)adapter);
        return adapter;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public Adapter createApplicationClientAdapter() {
        if (this.applicationClientItemProvider == null) {
            this.applicationClientItemProvider = new ApplicationClientItemProvider((AdapterFactory)this);
        }
        return this.applicationClientItemProvider;
    }

    public void dispose() {
        this.disposable.dispose();
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public boolean isFactoryForType(Object type) {
        return super.isFactoryForType(type) || this.supportedTypes.contains(type);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }
}

