/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.refactoring;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RenameContextRootChange
extends Change {
    private final IProject project;
    private final String newContextRoot;
    private final String oldContextRoot;
    private IDataModel model;

    public RenameContextRootChange(IProject project, String newContextRoot, String oldContextRoot) {
        this.project = project;
        this.oldContextRoot = oldContextRoot;
        this.newContextRoot = newContextRoot;
    }

    public Object getModifiedElement() {
        return this.project;
    }

    public String getName() {
        return J2EEUIMessages.getResourceString("RenameContextRootFromXtoY", new String[]{this.oldContextRoot, this.newContextRoot});
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public static IStatus validateContextRoot(String name) {
        IStatus status = Status.OK_STATUS;
        if (name == null || name.length() == 0) {
            status = new Status(4, "org.eclipse.jst.j2ee.ui", ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[0]));
        }
        if (name.indexOf(32) <= -1) {
            StringTokenizer stok = new StringTokenizer(name, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i)) && !Character.isWhitespace(token.charAt(i))) {
                        status = new Status(4, "org.eclipse.jst.j2ee.ui", ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])new Object[]{new Character(token.charAt(i)).toString()}));
                    }
                    ++i;
                }
            }
        } else {
            status = new Status(4, "org.eclipse.jst.j2ee.ui", ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_contain_whitespace_, (Object[])new Object[0]));
        }
        return status;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IStatus phase1 = RenameContextRootChange.validateContextRoot(this.newContextRoot);
        if (phase1.isOK()) {
            return new RefactoringStatus();
        }
        return RefactoringStatus.create((IStatus)phase1);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ComponentUtilities.setServerContextRoot((IProject)this.project, (String)this.newContextRoot);
        return new RenameContextRootChange(this.project, this.oldContextRoot, this.newContextRoot);
    }
}

