/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.jdt.internal.classpath.FlexibleProjectContainer;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainer;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ResourceTreeRootAdapter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class J2EEComponentClasspathUpdater
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static J2EEComponentClasspathUpdater instance = null;
    private static boolean updateDependencyGraph = true;
    private int pauseCount = 0;
    public static IPath WEB_APP_LIBS_PATH = new Path("org.eclipse.jst.j2ee.internal.web.container");
    private boolean forceUpdateOnNextRun = false;
    private static final int MODULE_UPDATE_DELAY = 30;
    public static final String MODULE_UPDATE_JOB_NAME = "EAR Libraries Update Job";
    private final ModuleUpdateJob moduleUpdateJob = new ModuleUpdateJob();
    private Set knownProjects = new HashSet();

    public static J2EEComponentClasspathUpdater getInstance() {
        if (instance == null) {
            J2EEComponentClasspathUpdater.init();
        }
        return instance;
    }

    private static void init() {
        if (instance == null) {
            instance = new J2EEComponentClasspathUpdater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseUpdates() {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            ++this.pauseCount;
        }
    }

    public void resumeUpdates() {
        this.resumeUpdates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeUpdates(boolean scheduleJob) {
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
            if (this.pauseCount > 0) {
                return;
            }
        }
        if (scheduleJob) {
            this.moduleUpdateJob.schedule(30L);
        }
    }

    public void forceUpdate(Collection projects) {
        this.forceUpdate(projects, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate(Collection projects, boolean runAsJob) {
        try {
            this.pauseUpdates();
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                this.queueUpdate((IProject)iterator.next());
            }
        }
        catch (Throwable throwable) {
            this.forceUpdateOnNextRun = true;
            J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
            synchronized (j2EEComponentClasspathUpdater) {
                if (this.pauseCount > 0) {
                    --this.pauseCount;
                }
            }
            if (runAsJob) {
                this.moduleUpdateJob.schedule(0L);
            } else {
                try {
                    updateDependencyGraph = false;
                    this.moduleUpdateJob.run((IProgressMonitor)new NullProgressMonitor());
                }
                finally {
                    updateDependencyGraph = true;
                }
            }
            throw throwable;
        }
        this.forceUpdateOnNextRun = true;
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
        }
        if (runAsJob) {
            this.moduleUpdateJob.schedule(0L);
        } else {
            try {
                updateDependencyGraph = false;
                this.moduleUpdateJob.run((IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                updateDependencyGraph = true;
            }
        }
    }

    public void queueUpdate(IProject project) {
        if (J2EEProjectUtilities.isEARProject(project)) {
            this.queueUpdateEAR(project);
        } else if (J2EEProjectUtilities.isApplicationClientProject(project) || J2EEProjectUtilities.isEJBProject(project) || J2EEProjectUtilities.isDynamicWebProject(project) || J2EEProjectUtilities.isJCAProject(project) || J2EEProjectUtilities.isUtilityProject(project)) {
            this.queueUpdateModule(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateModule(IProject project) {
        this.moduleUpdateJob.queueModule(project);
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.moduleUpdateJob.schedule(30L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdateEAR(IProject earProject) {
        this.moduleUpdateJob.queueEAR(earProject);
        J2EEComponentClasspathUpdater j2EEComponentClasspathUpdater = this;
        synchronized (j2EEComponentClasspathUpdater) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.moduleUpdateJob.schedule(30L);
    }

    public boolean projectsQueued() {
        return this.moduleUpdateJob.projectsQueued() || this.moduleUpdateJob.getState() != 0;
    }

    public IClasspathContainer getWebAppLibrariesContainer(IProject webProject, boolean create) {
        IClasspathEntry entry;
        IJavaProject jproj = JavaCore.create((IProject)webProject);
        IClasspathContainer container = null;
        IClasspathEntry iClasspathEntry = entry = create ? null : this.getExistingContainer(jproj, WEB_APP_LIBS_PATH);
        if (entry != null || create) {
            try {
                container = JavaCore.getClasspathContainer((IPath)WEB_APP_LIBS_PATH, (IJavaProject)jproj);
            }
            catch (JavaModelException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return container;
    }

    public IClasspathEntry getExistingContainer(IJavaProject jproj, IPath classpathContainerPath) {
        return J2EEComponentClasspathContainerUtils.getInstalledContainerEntry(jproj, classpathContainerPath);
    }

    private boolean isKnown(IProject project) {
        return !this.knownProjects.add(project.getName());
    }

    private void forgetProject(IProject project) {
        this.knownProjects.remove(project.getName());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean scheduleJob = false;
        try {
            try {
                this.pauseUpdates();
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        IResource resource = event.getResource();
                        if (resource.getType() != 4) break;
                        if (ModuleCoreNature.isFlexibleProject((IProject)((IProject)resource))) {
                            if (J2EEProjectUtilities.isEARProject((IProject)resource)) {
                                IProject earProject = (IProject)resource;
                                IVirtualReference[] refs = J2EEProjectUtilities.getComponentReferences(ComponentCore.createComponent((IProject)earProject));
                                IVirtualComponent comp = null;
                                int j = 0;
                                while (j < refs.length) {
                                    comp = refs[j].getReferencedComponent();
                                    if (!comp.isBinary()) {
                                        this.queueUpdateModule(comp.getProject());
                                    }
                                    ++j;
                                }
                            } else {
                                IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects((IProject)resource);
                                int i = 0;
                                while (i < earProjects.length) {
                                    this.queueUpdateEAR(earProjects[i]);
                                    ++i;
                                }
                            }
                            this.forgetProject((IProject)resource);
                        }
                        JavaEEBinaryComponentHelper.clearAllArchivesInProject((IProject)resource);
                        break;
                    }
                    case 1: {
                        scheduleJob = true;
                        event.getDelta().accept((IResourceDeltaVisitor)this);
                        IResourceDelta[] d = event.getDelta().getAffectedChildren();
                        this.findNode(d);
                    }
                }
            }
            catch (CoreException e) {
                J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
                this.resumeUpdates(scheduleJob);
            }
        }
        finally {
            this.resumeUpdates(scheduleJob);
        }
    }

    public static void clearResourceTreeRootCache(WorkbenchComponent aModule) {
        ResourceTreeRootAdapter resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.DEPLOY_ADAPTER_TYPE);
        if (resourceTreeAdapter != null) {
            resourceTreeAdapter.setResourceTreeRoot(null);
        }
        if ((resourceTreeAdapter = (ResourceTreeRootAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModule, (List)aModule.eAdapters(), (Object)ResourceTreeRootAdapter.SOURCE_ADAPTER_TYPE)) != null) {
            resourceTreeAdapter.setResourceTreeRoot(null);
        }
    }

    public boolean findNode(IResourceDelta[] delta) {
        int i = 0;
        while (i < delta.length) {
            if (delta[i].toString().indexOf(".component") != -1) {
                WorkbenchComponent component;
                StructureEdit core = StructureEdit.getStructureEditForRead((IProject)delta[i].getResource().getProject());
                if (core != null && (component = core.getComponent()) != null) {
                    J2EEComponentClasspathUpdater.clearResourceTreeRootCache(component);
                }
            } else {
                this.findNode(delta[i].getAffectedChildren());
            }
            ++i;
        }
        return true;
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getFlags() == 131072) {
            return false;
        }
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                return ModuleCoreNature.isFlexibleProject((IProject)((IProject)resource));
            }
            case 2: {
                if (resource.getName().equals(".settings")) {
                    return true;
                }
                IVirtualComponent comp = ComponentCore.createComponent((IProject)resource.getProject());
                if (comp instanceof J2EEModuleVirtualComponent || comp instanceof EARVirtualComponent) {
                    IVirtualFolder rootFolder = comp.getRootFolder();
                    if (comp instanceof EARVirtualComponent) {
                        return J2EEComponentClasspathUpdater.isRootAncester(resource, rootFolder) || this.isEARLibraryDirectory(resource, comp);
                    }
                    return J2EEComponentClasspathUpdater.isRootAncester(resource, rootFolder) || J2EEComponentClasspathUpdater.isFolder(resource, rootFolder.getFolder("META-INF"));
                }
                return false;
            }
            case 1: {
                String name = resource.getName();
                if (name.equals("org.eclipse.wst.common.component")) {
                    this.queueUpdate(resource.getProject());
                    break;
                }
                if (name.equals("MANIFEST.MF")) {
                    IFile manifestFile = J2EEProjectUtilities.getManifestFile(resource.getProject(), false);
                    if (manifestFile != null && !resource.equals((Object)manifestFile)) break;
                    this.queueUpdateModule(resource.getProject());
                    break;
                }
                if (!J2EEComponentClasspathUpdater.endsWithIgnoreCase(name, ".jar") && !J2EEComponentClasspathUpdater.endsWithIgnoreCase(name, ".zip")) break;
                try {
                    if (!FacetedProjectFramework.hasProjectFacet((IProject)resource.getProject(), (String)"jst.ear")) break;
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)resource.getProject());
                    if (!J2EEComponentClasspathUpdater.isFolder((IResource)resource.getParent(), comp.getRootFolder()) && !this.isEARLibraryDirectory(resource, comp)) break;
                    this.queueUpdateEAR(resource.getProject());
                    break;
                }
                catch (CoreException e) {
                    J2EEPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean isEARLibraryDirectory(IResource resource, IVirtualComponent earComponent) {
        IProject project = earComponent.getProject();
        if (!JavaEEProjectUtilities.isJEEComponent(earComponent, 1)) {
            return false;
        }
        IModelProvider modelProvider = ModelProviderManager.getModelProvider(project);
        if (modelProvider == null) {
            return false;
        }
        Application app = (Application)modelProvider.getModelObject();
        if (app == null) {
            return false;
        }
        String libDir = app.getLibraryDirectory();
        if (libDir == null) {
            return false;
        }
        IVirtualFolder libFolder = earComponent.getRootFolder().getFolder(libDir);
        if (resource.getType() == 1) {
            return J2EEComponentClasspathUpdater.isRootAncester((IResource)resource.getParent(), libFolder);
        }
        return J2EEComponentClasspathUpdater.isRootAncester(resource, libFolder);
    }

    public static boolean endsWithIgnoreCase(String str, String sfx) {
        return str.regionMatches(true, str.length() - sfx.length(), sfx, 0, sfx.length());
    }

    public static boolean isFolder(IResource resource, IVirtualFolder folder) {
        IContainer[] realFolders = folder.getUnderlyingFolders();
        int i = 0;
        while (i < realFolders.length) {
            if (realFolders[i].equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isRootAncester(IResource resource, IVirtualFolder rootFolder) {
        IContainer[] realRoots = rootFolder.getUnderlyingFolders();
        IPath currentResourcePath = resource.getFullPath();
        int i = 0;
        while (i < realRoots.length) {
            if (currentResourcePath.isPrefixOf(realRoots[i].getFullPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean shouldUpdateDependencyGraph() {
        return updateDependencyGraph;
    }

    public static void setUpdateDependencyGraph(boolean value) {
        updateDependencyGraph = value;
    }

    public class ModuleUpdateJob
    extends Job {
        private Queue moduleQueue;
        private Queue earQueue;
        private Queue earAddedModuleQueue;

        public boolean belongsTo(Object family) {
            if (family == J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME) {
                return true;
            }
            return super.belongsTo(family);
        }

        public ModuleUpdateJob() {
            super(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
            this.moduleQueue = new Queue();
            this.earQueue = new Queue();
            this.earAddedModuleQueue = new Queue();
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.setSystem(true);
        }

        public void queueEAR(IProject ear) {
            this.earQueue.add(ear);
        }

        public void queueModule(IProject project) {
            this.moduleQueue.add(project);
        }

        public boolean projectsQueued() {
            return !this.earQueue.isEmpty() || !this.moduleQueue.isEmpty();
        }

        private void queueReferencingEars(Object[] projects) {
            int p = 0;
            while (p < projects.length) {
                IProject project = (IProject)projects[p];
                if (!J2EEComponentClasspathUpdater.this.isKnown(project)) {
                    IProject[] earProjects = J2EEProjectUtilities.getReferencingEARProjects(project);
                    int i = 0;
                    while (i < earProjects.length) {
                        this.queueEAR(earProjects[i]);
                        ++i;
                    }
                }
                ++p;
            }
        }

        private void processEars() {
            Object[] earProjects = this.earQueue.getListeners();
            int i = 0;
            while (i < earProjects.length) {
                IProject earProject = (IProject)earProjects[i];
                if (J2EEProjectUtilities.isEARProject(earProject)) {
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                    IVirtualReference[] refs = J2EEProjectUtilities.getComponentReferences(earComponent);
                    IVirtualComponent comp = null;
                    int j = 0;
                    while (j < refs.length) {
                        comp = refs[j].getReferencedComponent();
                        if (!comp.isBinary()) {
                            this.earAddedModuleQueue.add(comp.getProject());
                        }
                        ++j;
                    }
                    if (earComponent != null) {
                        JavaEEBinaryComponentHelper.clearDisconnectedArchivesInEAR(earComponent);
                    }
                }
                ++i;
            }
        }

        private void processModules(Object[] projects) {
            int i = 0;
            while (i < projects.length) {
                J2EEComponentClasspathContainer earLibrariesContainer;
                FlexibleProjectContainer webAppLibrariesContainer;
                IProject project = (IProject)projects[i];
                if (J2EEProjectUtilities.isDynamicWebProject(project) && (webAppLibrariesContainer = J2EEComponentClasspathContainerUtils.getInstalledWebAppLibrariesContainer(project)) != null) {
                    webAppLibrariesContainer.refresh();
                }
                if ((earLibrariesContainer = J2EEComponentClasspathContainerUtils.getInstalledEARLibrariesContainer(project)) != null) {
                    earLibrariesContainer.refresh(J2EEComponentClasspathUpdater.this.forceUpdateOnNextRun);
                }
                ++i;
            }
            updateDependencyGraph = true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    J2EEPlugin.getDefault().getLogger().logError(e);
                }

                public void run() throws Exception {
                    try {
                        Object[] moduleProjects = ModuleUpdateJob.this.moduleQueue.getListeners();
                        ModuleUpdateJob.this.queueReferencingEars(moduleProjects);
                        ModuleUpdateJob.this.processEars();
                        Object[] earQueuedModuleProjects = ModuleUpdateJob.this.earAddedModuleQueue.getListeners();
                        HashSet modulesSet = new HashSet();
                        modulesSet.addAll(Arrays.asList(moduleProjects));
                        modulesSet.addAll(Arrays.asList(earQueuedModuleProjects));
                        Object[] modulesArray = modulesSet.toArray();
                        ModuleUpdateJob.this.processModules(modulesArray);
                    }
                    finally {
                        J2EEComponentClasspathUpdater.this.forceUpdateOnNextRun = false;
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private class Queue
        extends ListenerList {
            private Queue() {
            }

            public synchronized Object[] getListeners() {
                Object[] data = super.getListeners();
                this.clear();
                return data;
            }
        }
    }
}

