/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.templates.TemplateContextTypeIdsXML;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class NewXMLTemplatesWizardPage
extends WizardPage {
    private String fLastSelectedTemplateName;
    private SourceViewer fPatternViewer;
    private TableViewer fTableViewer;
    private TemplateStore fTemplateStore;
    private Button fUseTemplateButton;

    public NewXMLTemplatesWizardPage() {
        super("NewXMLTemplatesWizardPage", XMLWizardsMessages.NewXMLTemplatesWizardPage_0, null);
        this.setDescription(XMLWizardsMessages.NewXMLTemplatesWizardPage_1);
    }

    private void configureTableResizing(final Composite parent, final Table table, final TableColumn column1, final TableColumn column2) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                }
            }
        });
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.fUseTemplateButton = new Button(parent, 32);
        this.fUseTemplateButton.setText(XMLWizardsMessages.NewXMLTemplatesWizardPage_4);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fUseTemplateButton.setLayoutData((Object)data);
        this.fUseTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewXMLTemplatesWizardPage.this.enableTemplates();
            }
        });
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        innerParent.setLayoutData((Object)gd);
        Link link = new Link(innerParent, 0);
        link.setText(XMLWizardsMessages.NewXMLTemplatesWizardPage_6);
        data = new GridData(4, 4, true, false, 2, 1);
        link.setLayoutData((Object)data);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewXMLTemplatesWizardPage.this.linkClicked();
            }
        });
        Table table = new Table(innerParent, 67584);
        data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(2);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(XMLWizardsMessages.NewXMLTemplatesWizardPage_2);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(XMLWizardsMessages.NewXMLTemplatesWizardPage_3);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Template && object2 instanceof Template) {
                    Template left = (Template)object1;
                    Template right = (Template)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NewXMLTemplatesWizardPage.this.updateViewerInput();
            }
        });
        this.fPatternViewer = this.doCreateViewer(parent);
        this.fTemplateStore = XMLUIPlugin.getDefault().getTemplateStore();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.configureTableResizing(innerParent, table, column1, column2);
        this.loadLastSavedPreferences();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.xml.ui.xmlw0010");
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXML();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(XMLWizardsMessages.NewXMLTemplatesWizardPage_5);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    void enableTemplates() {
        boolean enabled = this.fUseTemplateButton.getSelection();
        if (!enabled) {
            Template template = this.getSelectedTemplate();
            this.fLastSelectedTemplateName = template != null ? template.getName() : "";
            this.fTableViewer.setSelection(null);
        } else {
            this.setSelectedTemplate(this.fLastSelectedTemplateName);
        }
        this.fTableViewer.getControl().setEnabled(enabled);
        this.fPatternViewer.getControl().setEnabled(enabled);
    }

    private String getPreferencePageId() {
        return "org.eclipse.wst.sse.ui.preferences.xml.templates";
    }

    private Template getSelectedTemplate() {
        Template template = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            template = (Template)selection.getFirstElement();
        }
        return template;
    }

    String getTemplateString() {
        String templateString = null;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            TemplateContextType contextType = XMLUIPlugin.getDefault().getTemplateContextRegistry().getContextType(TemplateContextTypeIdsXML.NEW);
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
            }
            catch (Exception e) {
                Logger.log(202, "Could not create template for new xml", e);
            }
        }
        return templateString;
    }

    void linkClicked() {
        String pageId = this.getPreferencePageId();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
        this.fTableViewer.refresh();
    }

    private void loadLastSavedPreferences() {
        String templateName = XMLUIPlugin.getDefault().getPreferenceStore().getString("newFileTemplateName");
        if (templateName == null || templateName.length() == 0) {
            this.fLastSelectedTemplateName = "";
            this.fUseTemplateButton.setSelection(false);
        } else {
            this.fLastSelectedTemplateName = templateName;
            this.fUseTemplateButton.setSelection(true);
        }
        this.enableTemplates();
    }

    void saveLastSavedPreferences() {
        String templateName = "";
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        XMLUIPlugin.getDefault().getPreferenceStore().setValue("newFileTemplateName", templateName);
        XMLUIPlugin.getDefault().savePluginPreferences();
    }

    private void setSelectedTemplate(String templateName) {
        Object template = null;
        if (templateName != null && templateName.length() > 0) {
            template = this.fTemplateStore.findTemplate(templateName, TemplateContextTypeIdsXML.NEW);
        }
        if (template == null) {
            template = this.fTableViewer.getElementAt(0);
        }
        if (template != null) {
            StructuredSelection selection = new StructuredSelection(template);
            this.fTableViewer.setSelection((ISelection)selection, true);
        }
    }

    void updateViewerInput() {
        Template template = this.getSelectedTemplate();
        if (template != null) {
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    private class TemplateContentProvider
    implements IStructuredContentProvider {
        private TemplateStore fStore;

        private TemplateContentProvider() {
        }

        public void dispose() {
            this.fStore = null;
        }

        public Object[] getElements(Object input) {
            return this.fStore.getTemplates(TemplateContextTypeIdsXML.NEW);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fStore = (TemplateStore)newInput;
        }
    }

    private class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Template template = (Template)element;
            switch (columnIndex) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    return template.getDescription();
                }
            }
            return "";
        }
    }
}

