/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;

public class JavaTokenComparator
implements ITokenComparator {
    private static final boolean DEBUG = false;
    private final String fText;
    private final ITokenComparatorFactory fTextTokenComparatorFactory;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;

    public JavaTokenComparator(String text) {
        this(text, null);
    }

    public JavaTokenComparator(String text, ITokenComparatorFactory textTokenComparatorFactory) {
        this.fTextTokenComparatorFactory = textTokenComparatorFactory;
        Assert.isLegal((text != null ? 1 : 0) != 0);
        this.fText = text;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fCount = 0;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        scanner.setSource(this.fText.toCharArray());
        int endPos = 0;
        try {
            int tokenType;
            while ((tokenType = scanner.getNextToken()) != 158) {
                int start = scanner.getCurrentTokenStartPosition();
                int end = scanner.getCurrentTokenEndPosition() + 1;
                if (TokenScanner.isComment(tokenType) || tokenType == 45) {
                    int dl = this.fTextTokenComparatorFactory == null ? JavaTokenComparator.getCommentStartTokenLength(tokenType) : 0;
                    this.recordTokenRange(start, dl);
                    this.parseText(start + dl, text.substring(start + dl, end));
                } else {
                    this.recordTokenRange(start, end - start);
                }
                endPos = end;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        if (endPos < length) {
            this.recordTokenRange(endPos, length - endPos);
        }
    }

    private void recordTokenRange(int start, int length) {
        this.fStarts[this.fCount] = start;
        this.fLengths[this.fCount] = length;
        ++this.fCount;
    }

    private void parseText(int start, String text) {
        JavaTokenComparator subTokenizer = this.fTextTokenComparatorFactory == null ? new JavaTokenComparator(text) : this.fTextTokenComparatorFactory.createTokenComparator(text);
        int count = subTokenizer.getRangeCount();
        int i = 0;
        while (i < count) {
            int subStart = subTokenizer.getTokenStart(i);
            int subLength = subTokenizer.getTokenLength(i);
            this.recordTokenRange(start + subStart, subLength);
            ++i;
        }
    }

    private static int getCommentStartTokenLength(int tokenType) {
        if (tokenType == 1003) {
            return 3;
        }
        if (tokenType == 45) {
            return 1;
        }
        return 2;
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public int getTokenStart(int index) {
        if (index >= 0 && index < this.fCount) {
            return this.fStarts[index];
        }
        if (this.fCount > 0) {
            return this.fStarts[this.fCount - 1] + this.fLengths[this.fCount - 1];
        }
        return 0;
    }

    public int getTokenLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            JavaTokenComparator tc = (JavaTokenComparator)other;
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = tc.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), tc.fText, tc.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (maxLength < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (maxLength > 800) {
            return true;
        }
        return length >= maxLength / 4;
    }

    public static interface ITokenComparatorFactory {
        public ITokenComparator createTokenComparator(String var1);
    }
}

