/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentproperties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSPFContentProperties {
    static final String JSPCORE_ID = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
    private static final String PROJECT_KEY = "<project>";
    public static final String JSPLANGUAGE = "jsp-language";
    public static final String JSPCONTENTTYPE = "jsp-content-type";
    public static final String VALIDATE_FRAGMENTS = "validateFragments";

    static String getKeyFor(IPath resourcePath) {
        String key = PROJECT_KEY;
        if (resourcePath != null && resourcePath.segmentCount() > 1) {
            key = resourcePath.removeFirstSegments(1).toString();
        }
        return key;
    }

    static Preferences getPreferences(IProject project, String preferenceKey, boolean create) {
        Preferences node;
        block8: {
            block7: {
                block6: {
                    if (create) {
                        return new ProjectScope(project).getNode(JSPCORE_ID).node(preferenceKey);
                    }
                    node = Platform.getPreferencesService().getRootNode().node("project");
                    try {
                        if (node.nodeExists(project.getName())) break block6;
                        return null;
                    }
                    catch (BackingStoreException e) {
                        Logger.log(202, "Could not retrieve preference node", e);
                        return null;
                    }
                }
                node = node.node(project.getName());
                if (node.nodeExists(JSPCORE_ID)) break block7;
                return null;
            }
            node = node.node(JSPCORE_ID);
            if (node.nodeExists(preferenceKey)) break block8;
            return null;
        }
        return node.node(preferenceKey);
    }

    public static String getProperty(String key, IResource resource, boolean recurse) {
        Preferences preferences;
        IProject project;
        String val = null;
        if (resource != null && (project = resource.getProject()) != null && (preferences = JSPFContentProperties.getPreferences(project, key, false)) != null) {
            val = JSPFContentProperties.internalGetProperty(resource, recurse, preferences);
        }
        if (val == null && recurse) {
            val = JSPFContentProperties.getWorkbenchPreference(key);
        }
        return val;
    }

    private static String getWorkbenchPreference(String key) {
        return Platform.getPreferencesService().getString(JSPCORE_ID, key, null, null);
    }

    private static String internalGetProperty(IResource resource, boolean recurse, Preferences preferences) {
        String value = preferences.get(JSPFContentProperties.getKeyFor(resource.getFullPath()), null);
        if (value == null && resource != resource.getProject() && recurse) {
            value = preferences.get(JSPFContentProperties.getKeyFor(null), null);
        }
        return value;
    }

    public static void setProperty(String key, IResource resource, String value) throws CoreException {
        IProject project;
        if (resource != null && (project = resource.getProject()) != null) {
            Preferences preferences = JSPFContentProperties.getPreferences(project, key, true);
            if (value == null || value.trim().length() == 0) {
                preferences.remove(JSPFContentProperties.getKeyFor(resource.getFullPath()));
            } else {
                preferences.put(JSPFContentProperties.getKeyFor(resource.getFullPath()), value);
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, JSPCORE_ID, 4, "Unable to set property", (Throwable)e));
            }
        }
    }
}

