/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

public class IDUtil {
    public static void assignID(EObject object) {
        Resource aResource = object.eResource();
        if (aResource instanceof XMLResource) {
            IDUtil.assignID(object, (XMLResource)aResource);
        }
    }

    public static String getOrAssignID(EObject object) {
        Resource aResource = object.eResource();
        if (aResource instanceof XMLResource) {
            return IDUtil.getOrAssignID(object, (XMLResource)aResource);
        }
        return null;
    }

    public static String getOrAssignID(EObject object, XMLResource aResource) {
        String id = aResource.getID(object);
        if (id == null) {
            return IDUtil.assignID(object, aResource);
        }
        return id;
    }

    public static String assignID(EObject object, XMLResource aResource) {
        String name = IDUtil.getBaseIDForAssignment(object);
        if (name == null) {
            return null;
        }
        String id = IDUtil.ensureUniqueID(aResource, name);
        aResource.setID(object, id);
        return id;
    }

    protected static String ensureUniqueID(XMLResource aResource, String baseIDName) {
        baseIDName = String.valueOf(baseIDName) + "_";
        long currentTime = System.currentTimeMillis();
        String id = String.valueOf(baseIDName) + currentTime;
        while (aResource.getEObject(id) != null) {
            id = String.valueOf(baseIDName) + ++currentTime;
        }
        return id;
    }

    protected static String getBaseIDForAssignment(EObject object) {
        EClass metaO = object.eClass();
        return metaO.getName();
    }
}

