/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.common.uriresolver.internal.URI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CatalogReader {
    public static void read(Catalog xmlCatalog, InputStream input) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(input), (DefaultHandler)new CatalogContentHandler(xmlCatalog));
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        catch (SAXException e) {
            Logger.logException(e);
        }
    }

    protected static class CatalogContentHandler
    extends DefaultHandler {
        protected Catalog catalog;
        protected Stack baseURIStack = new Stack();

        public CatalogContentHandler(Catalog xmlCatalog) {
            this.catalog = xmlCatalog;
            String base = xmlCatalog.getBase();
            if (base == null || base == "") {
                base = xmlCatalog.getLocation();
            }
            this.baseURIStack.push(base);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String base = attributes.getValue("xml:base");
            if (base != null && !base.equals("")) {
                this.baseURIStack.push(base);
            } else {
                this.baseURIStack.push(this.baseURIStack.peek());
            }
            if (localName.equals("UserEntry")) {
                ICatalogElement catalogElement;
                int type = 2;
                String typeName = attributes.getValue("", "TYPE");
                if (typeName != null && typeName.compareToIgnoreCase("SYSTEM") == 0) {
                    type = 3;
                }
                if ((catalogElement = this.catalog.createCatalogElement(type)) instanceof CatalogEntry) {
                    CatalogEntry catalogEntry = (CatalogEntry)catalogElement;
                    String key = attributes.getValue("", "ID");
                    catalogEntry.setKey(key);
                    String entryUri = attributes.getValue("", "URI");
                    if (URI.createURI((String)entryUri).isRelative()) {
                        entryUri = URI.resolveRelativeURI((String)entryUri, (String)this.baseURIStack.peek().toString());
                    }
                    catalogEntry.setURI(URIHelper.ensureURIProtocolFormat((String)entryUri));
                    String webURL = attributes.getValue("", "WEB_URL");
                    if (webURL != null) {
                        catalogEntry.setAttributeValue("webURL", webURL);
                    }
                }
                this.catalog.addCatalogElement(catalogElement);
                return;
            }
            int type = 2;
            String key = null;
            if ("public".equals(localName)) {
                key = attributes.getValue("", "publicId");
            } else if ("system".equals(localName)) {
                key = attributes.getValue("", "systemId");
                type = 3;
            } else if ("uri".equals(localName)) {
                key = attributes.getValue("", "name");
                type = 4;
            } else {
                if ("nextCatalog".equals(localName)) {
                    String nextCatalogId = attributes.getValue("", "id");
                    String location = attributes.getValue("", "catalog");
                    NextCatalog delegate = new NextCatalog();
                    delegate.setCatalogLocation(location);
                    delegate.setId(nextCatalogId);
                    this.catalog.addCatalogElement(delegate);
                    return;
                }
                return;
            }
            if (key == null || key.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_key_not_set);
                return;
            }
            String entryURI = attributes.getValue("", "uri");
            if (entryURI == null || entryURI.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_uri_not_set);
                return;
            }
            ICatalogElement catalogElement = this.catalog.createCatalogElement(type);
            if (catalogElement instanceof CatalogEntry) {
                CatalogEntry catalogEntry = (CatalogEntry)catalogElement;
                catalogEntry.setKey(key);
                if (URI.createURI((String)entryURI).isRelative()) {
                    entryURI = URI.resolveRelativeURI((String)entryURI, (String)this.baseURIStack.peek().toString());
                }
                catalogEntry.setURI(URIHelper.ensureURIProtocolFormat((String)entryURI));
            }
            int j = 0;
            while (j < attributes.getLength()) {
                String attrValue;
                String attrName = attributes.getLocalName(j);
                if (!(attrName.equals("uri") || attrName.equals("name") || attrName.equals("publicId") || attrName.equals("systemId") || attrName.equals("catalog") || attrName.equals("id") || attrName.equals("xml:base") || (attrValue = attributes.getValue(attrName)) == null || attrValue.equals(""))) {
                    catalogElement.setAttributeValue(attrName, attrValue);
                }
                ++j;
            }
            this.catalog.addCatalogElement(catalogElement);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.baseURIStack.size() > 0) {
                this.baseURIStack.pop();
            }
        }
    }

    static interface CompatabilityConstants {
        public static final String TAG_ID_XML_CATALOG_SETTINGS = "XMLCatalogSettings";
        public static final String TAG_ID_USER_ENTRIES = "UserEntries";
        public static final String TAG_USER_ENTRY = "UserEntry";
        public static final String ATT_TYPE = "TYPE";
        public static final String ATT_ID = "ID";
        public static final String ATT_URI = "URI";
        public static final String ATT_WEB_URL = "WEB_URL";
    }
}

