/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.io.CharConversionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExtractInterfaceAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ExtractInterfaceAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ExtractInterfaceAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ExtractInterfaceAction_Extract_Interface);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.extract_interface_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractInterfaceAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (!(e.getException() instanceof CharConversionException) && JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isExtractInterfaceAvailable(selection)) {
                IType singleSelectedType = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (!ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)singleSelectedType)) {
                    return;
                }
                RefactoringExecutionStarter.startExtractInterfaceRefactoring(singleSelectedType, this.getShell());
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractInterfaceAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IType type = RefactoringActions.getEnclosingOrPrimaryType(this.fEditor);
            if (RefactoringAvailabilityTester.isExtractInterfaceAvailable(type)) {
                if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)type)) {
                    return;
                }
                RefactoringExecutionStarter.startExtractInterfaceRefactoring(type, this.getShell());
            } else {
                String unavailable = RefactoringMessages.ExtractInterfaceAction_To_activate;
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)unavailable);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

