/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class BufferedLimitedReader
extends BufferedReader {
    private int limitedCount;
    private int nRead;

    public BufferedLimitedReader(Reader reader, int size) {
        super(reader, size);
        if (reader.markSupported()) {
            try {
                this.mark(size);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.limitedCount = size;
    }

    public int read() throws IOException {
        int result = 0;
        ++this.nRead;
        result = this.nRead > this.limitedCount ? -1 : super.read();
        return result;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        if (this.nRead + len > this.limitedCount) {
            result = -1;
        } else {
            result = super.read(cbuf, off, len);
            this.nRead += result;
        }
        return result;
    }
}

