/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.cleanup;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.jsdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CommentFormatCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public final class CodeFormatingTabPage
extends CleanUpTabPage {
    private final Map fValues;
    private CleanUpPreview fPreview;

    public CodeFormatingTabPage(ModifyDialog dialog, Map values) {
        this(dialog, values, false);
    }

    public CodeFormatingTabPage(ModifyDialogTabPage.IModificationListener listener, Map values, boolean isSaveParticipantConfiguration) {
        super(listener, values, isSaveParticipantConfiguration);
        this.fValues = values;
    }

    protected ICleanUp[] createPreviewCleanUps(Map values) {
        return new ICleanUp[]{new ImportsCleanUp(values), new CommentFormatCleanUp(values), new CodeFormatCleanUp(values), new SortMembersCleanUp(values)};
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = (CleanUpPreview)super.doCreateJavaPreview(parent);
        this.fPreview.showInvisibleCharacters(true);
        this.fPreview.setFormat("true".equals(this.fValues.get("cleanup.format_source_code")));
        return this.fPreview;
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group group = this.createGroup(numColumns, composite, CleanUpMessages.CodeFormatingTabPage_GroupName_Formatter);
        if (!this.isSaveAction()) {
            final ModifyDialogTabPage.CheckboxPreference format = this.createCheckboxPref((Composite)group, numColumns, CleanUpMessages.CodeFormatingTabPage_CheckboxName_FormatSourceCode, "cleanup.format_source_code", CleanUpModifyDialog.FALSE_TRUE);
            this.registerPreference(format);
            format.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    CodeFormatingTabPage.this.fPreview.setFormat(format.getChecked());
                    CodeFormatingTabPage.this.fPreview.update();
                }
            });
        }
        ModifyDialogTabPage.CheckboxPreference whiteSpace = this.createCheckboxPref((Composite)group, numColumns, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_checkbox_text, "cleanup.remove_trailing_whitespaces", CleanUpModifyDialog.FALSE_TRUE);
        this.intent((Composite)group);
        ModifyDialogTabPage.RadioPreference allPref = this.createRadioPref((Composite)group, 1, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_all_radio, "cleanup.remove_trailing_whitespaces_all", CleanUpModifyDialog.FALSE_TRUE);
        ModifyDialogTabPage.RadioPreference ignoreEmptyPref = this.createRadioPref((Composite)group, 1, CleanUpMessages.CodeFormatingTabPage_RemoveTrailingWhitespace_ignoreEmpty_radio, "cleanup.remove_trailing_whitespaces_ignore_empty", CleanUpModifyDialog.FALSE_TRUE);
        this.registerSlavePreference(whiteSpace, new ModifyDialogTabPage.RadioPreference[]{allPref, ignoreEmptyPref});
        if (!this.isSaveAction()) {
            CodeFormatingTabPage.createLabel(numColumns, (Composite)group, CleanUpMessages.CodeFormatingTabPage_FormatterSettings_Description).setFont(composite.getFont());
        }
        Group sortMembersGroup = this.createGroup(numColumns, composite, CleanUpMessages.CodeFormatingTabPage_SortMembers_GroupName);
        CodeFormatingTabPage.createLabel(numColumns, (Composite)sortMembersGroup, CleanUpMessages.CodeFormatingTabPage_SortMembers_Description);
    }
}

