/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.archive.AppClientComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.ConnectorComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EARComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.EJBComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEEMFArchiveAdapterHelper;
import org.eclipse.jst.j2ee.internal.archive.WebComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentLoadAdapter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveFactoryImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.archive.internal.ZipFileArchiveLoadAdapterImpl;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEEArchiveUtilities
extends ArchiveFactoryImpl
implements IArchiveFactory {
    public static final String DISCRIMINATE_JAVA_EE = "DISCRIMINATE_EJB";
    public static final String DISCRIMINATE_EJB_ANNOTATIONS = "DISCRIMINATE_EJB_ANNOTATIONS";
    public static final String WRAPPED_LOAD_ADAPTER = "WRAPPED_LOAD_ADAPTER";
    public static JavaEEArchiveUtilities INSTANCE = new JavaEEArchiveUtilities();
    public static final String DOT_JAVA = ".java";
    public static final String DOT_CLASS = ".class";
    private Map<IArchive, JavaEEQuickPeek> archiveToJavaEEQuickPeek = new WeakHashMap<IArchive, JavaEEQuickPeek>();
    private static final String DOT_EAR = ".ear";
    private static final String DOT_WAR = ".war";
    private static final String DOT_JAR = ".jar";
    private static final char[] RUNTIME_VISIBLE = "RuntimeVisibleAnnotations".toCharArray();
    private static final char[] STATELESS = "Ljavax/ejb/Stateless;".toCharArray();
    private static final char[] STATEFUL = "Ljavax/ejb/Stateful;".toCharArray();
    private static final char[] MESSAGEDRIVEN = "Ljavax/ejb/MessageDriven;".toCharArray();

    private JavaEEArchiveUtilities() {
    }

    public static boolean isJava(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_JAVA);
    }

    public static boolean isClass(IFile iFile) {
        return JavaEEArchiveUtilities.hasExtension(iFile, DOT_CLASS);
    }

    public static boolean hasExtension(IFile iFile, String ext) {
        String name = iFile.getName();
        return JavaEEArchiveUtilities.hasExtension(name, ext);
    }

    public static boolean hasExtension(String name, String ext) {
        int offset = ext.length();
        return name.regionMatches(true, name.length() - offset, ext, 0, offset);
    }

    public IArchive openArchive(IVirtualComponent virtualComponent) throws ArchiveOpenFailureException {
        if (virtualComponent.isBinary()) {
            J2EEModuleVirtualArchiveComponent archiveComponent = (J2EEModuleVirtualArchiveComponent)virtualComponent;
            JavaEEBinaryComponentLoadAdapter loadAdapter = new JavaEEBinaryComponentLoadAdapter(archiveComponent);
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setOption((Object)"LOAD_ADAPTER", (Object)loadAdapter);
            archiveOptions.setOption((Object)"ARCHIVE_PATH", (Object)loadAdapter.getArchivePath());
            IArchive parentEARArchive = null;
            try {
                if (archiveComponent.isLinkedToEAR()) {
                    try {
                        IVirtualComponent earComponent;
                        IProject earProject = virtualComponent.getProject();
                        if (earProject != null && EarUtilities.isEARProject(earProject) && (earComponent = ComponentCore.createComponent((IProject)virtualComponent.getProject())) != null && (parentEARArchive = this.openArchive(earComponent)) != null) {
                            archiveOptions.setOption((Object)"PARENT_ARCHIVE", (Object)parentEARArchive);
                        }
                    }
                    catch (ArchiveOpenFailureException e) {
                        J2EEPlugin.logError(e);
                    }
                }
                IArchive iArchive = this.openArchive(archiveOptions);
                return iArchive;
            }
            finally {
                if (parentEARArchive != null) {
                    archiveOptions.removeOption((Object)"PARENT_ARCHIVE");
                    this.closeArchive(parentEARArchive);
                }
            }
        }
        int type = -1;
        ComponentArchiveLoadAdapter archiveLoadAdapter = null;
        if (J2EEProjectUtilities.isEARProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new EARComponentArchiveLoadAdapter(virtualComponent);
            type = 1;
        } else if (J2EEProjectUtilities.isEJBComponent(virtualComponent)) {
            archiveLoadAdapter = new EJBComponentArchiveLoadAdapter(virtualComponent);
            type = 0;
        } else if (J2EEProjectUtilities.isApplicationClientComponent(virtualComponent)) {
            archiveLoadAdapter = new AppClientComponentArchiveLoadAdapter(virtualComponent);
            type = 3;
        } else if (J2EEProjectUtilities.isJCAComponent(virtualComponent)) {
            archiveLoadAdapter = new ConnectorComponentArchiveLoadAdapter(virtualComponent);
            type = 2;
        } else if (J2EEProjectUtilities.isDynamicWebComponent(virtualComponent)) {
            archiveLoadAdapter = new WebComponentArchiveLoadAdapter(virtualComponent);
            type = 4;
        } else if (J2EEProjectUtilities.isUtilityProject(virtualComponent.getProject())) {
            archiveLoadAdapter = new JavaComponentArchiveLoadAdapter(virtualComponent);
        }
        if (archiveLoadAdapter != null) {
            ArchiveOptions options = new ArchiveOptions();
            options.setOption((Object)"LOAD_ADAPTER", (Object)archiveLoadAdapter);
            IArchive archive = super.openArchive(options);
            if (type != -1) {
                int version = -1;
                String versionStr = JavaEEProjectUtilities.getJ2EEDDProjectVersion(virtualComponent.getProject());
                if (versionStr == null) {
                    versionStr = J2EEProjectUtilities.getJ2EEProjectVersion(virtualComponent.getProject());
                }
                switch (type) {
                    case 1: 
                    case 3: {
                        if (versionStr.equals("1.2")) {
                            version = 12;
                            break;
                        }
                        if (versionStr.equals("1.3")) {
                            version = 13;
                            break;
                        }
                        if (versionStr.equals("1.4")) {
                            version = 14;
                            break;
                        }
                        if (!versionStr.equals("5.0")) break;
                        version = 50;
                        break;
                    }
                    case 2: {
                        if (versionStr.equals("1.0")) {
                            version = 10;
                            break;
                        }
                        if (!versionStr.equals("1.5")) break;
                        version = 15;
                        break;
                    }
                    case 0: {
                        if (versionStr.equals("1.1")) {
                            version = 11;
                            break;
                        }
                        if (versionStr.equals("2.0")) {
                            version = 20;
                            break;
                        }
                        if (versionStr.equals("2.1")) {
                            version = 21;
                            break;
                        }
                        if (!versionStr.equals("3.0")) break;
                        version = 30;
                        break;
                    }
                    case 4: {
                        if (versionStr.equals("2.2")) {
                            version = 22;
                            break;
                        }
                        if (versionStr.equals("2.3")) {
                            version = 23;
                            break;
                        }
                        if (versionStr.equals("2.4")) {
                            version = 24;
                            break;
                        }
                        if (!versionStr.equals("2.5")) break;
                        version = 25;
                    }
                }
                if (version != -1) {
                    this.archiveToJavaEEQuickPeek.put(archive, new JavaEEQuickPeek(type, version));
                }
            }
            return archive;
        }
        return null;
    }

    public JavaEEQuickPeek getJavaEEQuickPeek(IArchive archive) {
        if (this.archiveToJavaEEQuickPeek.containsKey(archive)) {
            return this.archiveToJavaEEQuickPeek.get(archive);
        }
        String[] deploymentDescriptorsToCheck = new String[]{"META-INF/application.xml", "META-INF/application-client.xml", "META-INF/ejb-jar.xml", "WEB-INF/web.xml", "META-INF/ra.xml"};
        int i = 0;
        while (i < deploymentDescriptorsToCheck.length) {
            Path deploymentDescriptorPath = new Path(deploymentDescriptorsToCheck[i]);
            if (archive.containsArchiveResource((IPath)deploymentDescriptorPath)) {
                InputStream in = null;
                try {
                    IArchiveResource dd = archive.getArchiveResource((IPath)deploymentDescriptorPath);
                    in = dd.getInputStream();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    this.archiveToJavaEEQuickPeek.put(archive, quickPeek);
                    return quickPeek;
                }
                catch (FileNotFoundException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
            }
            ++i;
        }
        JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(null);
        this.archiveToJavaEEQuickPeek.put(archive, quickPeek);
        return quickPeek;
    }

    public IArchive openArchive(ArchiveOptions archiveOptions) throws ArchiveOpenFailureException {
        IArchive simpleArchive = super.openArchive(archiveOptions);
        Object discriminateJavaEE = archiveOptions.getOption((Object)DISCRIMINATE_JAVA_EE);
        if (discriminateJavaEE != null && !((Boolean)discriminateJavaEE).booleanValue()) {
            return simpleArchive;
        }
        return this.refineForJavaEE(simpleArchive);
    }

    private IArchive refineForJavaEE(IArchive simpleArchive) {
        Object obj;
        Path ddPath;
        IArchive parent;
        JavaEEQuickPeek qp;
        if (simpleArchive.getArchiveOptions().hasOption((Object)"PARENT_ARCHIVE") && (qp = this.getJavaEEQuickPeek(parent = (IArchive)simpleArchive.getArchiveOptions().getOption((Object)"PARENT_ARCHIVE"))).getType() == 1 && parent.containsArchiveResource((IPath)(ddPath = new Path("META-INF/application.xml")))) {
            try {
                JavaEEQuickPeek quickPeek;
                String stringPath;
                int i;
                IPath noDevicePath;
                Module module;
                org.eclipse.jst.javaee.application.Application app;
                Object obj2;
                Object ddObj = parent.getModelObject((IPath)ddPath);
                IPath archivePath = simpleArchive.getPath();
                if (archivePath == null && (obj2 = simpleArchive.getArchiveOptions().getOption((Object)"ARCHIVE_PATH")) != null) {
                    archivePath = (IPath)obj2;
                }
                int definedType = -1;
                if (qp.getVersion() == 50) {
                    app = (org.eclipse.jst.javaee.application.Application)ddObj;
                    module = app.getFirstModule(archivePath.toString());
                    if (module == null) {
                        noDevicePath = archivePath.setDevice(null);
                        i = 1;
                        while (i < noDevicePath.segmentCount() && module == null) {
                            stringPath = noDevicePath.removeFirstSegments(i).toString();
                            module = app.getFirstModule(stringPath);
                            ++i;
                        }
                    }
                    if (module != null) {
                        if (module.getEjb() != null) {
                            definedType = 0;
                        } else if (module.getConnector() != null) {
                            definedType = 2;
                        } else if (module.getJava() != null) {
                            definedType = 3;
                        } else if (module.getWeb() != null) {
                            definedType = 4;
                        }
                    }
                } else {
                    app = (Application)ddObj;
                    module = app.getFirstModule(archivePath.toString());
                    if (module == null) {
                        noDevicePath = archivePath.setDevice(null);
                        i = 1;
                        while (i < noDevicePath.segmentCount() && module == null) {
                            stringPath = noDevicePath.removeFirstSegments(i).toString();
                            module = app.getFirstModule(stringPath);
                            ++i;
                        }
                    }
                    if (module != null) {
                        if (module.isEjbModule()) {
                            definedType = 0;
                        } else if (module.isConnectorModule()) {
                            definedType = 2;
                        } else if (module.isJavaModule()) {
                            definedType = 3;
                        } else if (module.isWebModule()) {
                            definedType = 4;
                        }
                    } else {
                        quickPeek = new JavaEEQuickPeek(null);
                        this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                        return simpleArchive;
                    }
                }
                if (definedType != -1) {
                    String ddToCheck = null;
                    switch (definedType) {
                        case 0: {
                            ddToCheck = "META-INF/ejb-jar.xml";
                            break;
                        }
                        case 2: {
                            ddToCheck = "META-INF/ra.xml";
                            break;
                        }
                        case 3: {
                            ddToCheck = "META-INF/application-client.xml";
                            break;
                        }
                        case 4: {
                            ddToCheck = "WEB-INF/web.xml";
                        }
                    }
                    IArchive wrappedForDD = this.wrapForDD(simpleArchive, definedType, (IPath)new Path(ddToCheck));
                    if (wrappedForDD != null) {
                        return wrappedForDD;
                    }
                    switch (definedType) {
                        case 0: {
                            quickPeek = new JavaEEQuickPeek(0, 30, 50);
                            this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                            JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("META-INF/ejb-jar.xml"));
                            return simpleArchive;
                        }
                        case 3: {
                            quickPeek = new JavaEEQuickPeek(3, 50, 50);
                            this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                            JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("META-INF/application.xml"));
                            return simpleArchive;
                        }
                        case 4: {
                            quickPeek = new JavaEEQuickPeek(4, 25, 50);
                            this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                            JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("WEB-INF/web.xml"));
                            return simpleArchive;
                        }
                    }
                }
            }
            catch (ArchiveModelLoadException e) {
                J2EEPlugin.logError(e);
            }
        }
        String[] deploymentDescriptorsToCheck = new String[]{"META-INF/application.xml", "META-INF/application-client.xml", "META-INF/ejb-jar.xml", "WEB-INF/web.xml", "META-INF/ra.xml"};
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 3;
        nArray[3] = 4;
        nArray[4] = 2;
        int[] typeToVerify = nArray;
        int i = 0;
        while (i < deploymentDescriptorsToCheck.length) {
            int currentType = typeToVerify[i];
            Path deploymentDescriptorPath = new Path(deploymentDescriptorsToCheck[i]);
            IArchive wrappedForDD = this.wrapForDD(simpleArchive, currentType, (IPath)deploymentDescriptorPath);
            if (wrappedForDD != null) {
                return wrappedForDD;
            }
            ++i;
        }
        IPath archivePath = simpleArchive.getPath();
        if (archivePath == null && (obj = simpleArchive.getArchiveOptions().getOption((Object)"ARCHIVE_PATH")) != null) {
            archivePath = (IPath)obj;
        }
        if (archivePath != null) {
            JavaEEQuickPeek quickPeek;
            String lastSegment = archivePath.lastSegment().toLowerCase();
            if (lastSegment.endsWith(DOT_EAR)) {
                quickPeek = new JavaEEQuickPeek(1, 50, 50);
                this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("META-INF/application.xml"));
                return simpleArchive;
            }
            if (lastSegment.endsWith(DOT_WAR)) {
                quickPeek = new JavaEEQuickPeek(4, 25, 50);
                this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("WEB-INF/web.xml"));
                return simpleArchive;
            }
            if (lastSegment.endsWith(DOT_JAR)) {
                Object discriminateEJB30;
                Path manifestPath = new Path("META-INF/MANIFEST.MF");
                if (simpleArchive.containsArchiveResource((IPath)manifestPath)) {
                    InputStream in = null;
                    try {
                        IArchiveResource manifestResource = simpleArchive.getArchiveResource((IPath)manifestPath);
                        in = manifestResource.getInputStream();
                        Manifest manifest = new Manifest(in);
                        Attributes attributes = manifest.getMainAttributes();
                        String mainClassName = attributes.getValue("Main-Class");
                        if (mainClassName != null) {
                            JavaEEQuickPeek quickPeek2 = new JavaEEQuickPeek(3, 50, 50);
                            this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek2);
                            JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("META-INF/application.xml"));
                            IArchive iArchive = simpleArchive;
                            return iArchive;
                        }
                    }
                    catch (FileNotFoundException e) {
                        ArchiveUtil.warn((Throwable)e);
                    }
                    catch (IOException e) {
                        ArchiveUtil.warn((Throwable)e);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                        }
                    }
                }
                if (((discriminateEJB30 = simpleArchive.getArchiveOptions().getOption((Object)DISCRIMINATE_EJB_ANNOTATIONS)) == null || ((Boolean)discriminateEJB30).booleanValue()) && this.isEJBArchive(simpleArchive)) {
                    JavaEEQuickPeek quickPeek3 = new JavaEEQuickPeek(0, 30, 50);
                    this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek3);
                    JavaEEArchiveUtilities.wrapArchive(simpleArchive, (IPath)new Path("META-INF/ejb-jar.xml"));
                    return simpleArchive;
                }
            }
        }
        return simpleArchive;
    }

    private IArchive wrapForDD(IArchive simpleArchive, int currentType, IPath deploymentDescriptorPath) {
        if (simpleArchive.containsArchiveResource(deploymentDescriptorPath)) {
            InputStream in = null;
            try {
                IArchiveResource dd = simpleArchive.getArchiveResource(deploymentDescriptorPath);
                in = dd.getInputStream();
                JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                if (quickPeek.getType() == currentType && quickPeek.getVersion() != -1 && (JavaEEArchiveUtilities.isBinary(simpleArchive) || !simpleArchive.containsModelObject(deploymentDescriptorPath))) {
                    this.archiveToJavaEEQuickPeek.put(simpleArchive, quickPeek);
                    JavaEEArchiveUtilities.wrapArchive(simpleArchive, deploymentDescriptorPath);
                    IArchive iArchive = simpleArchive;
                    return iArchive;
                }
            }
            catch (FileNotFoundException e) {
                ArchiveUtil.warn((Throwable)e);
            }
            catch (IOException e) {
                ArchiveUtil.warn((Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        ArchiveUtil.warn((Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isBinary(IArchive anArchive) {
        IArchiveLoadAdapter loadAdapter = null;
        loadAdapter = anArchive.getArchiveOptions().hasOption((Object)WRAPPED_LOAD_ADAPTER) ? (IArchiveLoadAdapter)anArchive.getArchiveOptions().getOption((Object)WRAPPED_LOAD_ADAPTER) : (IArchiveLoadAdapter)anArchive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER");
        if (loadAdapter instanceof JavaEEBinaryComponentLoadAdapter) {
            return true;
        }
        return loadAdapter instanceof ZipFileArchiveLoadAdapterImpl;
    }

    public static IArchive findArchive(Object modelObject) {
        if (modelObject instanceof EObject) {
            EObject eObject = (EObject)modelObject;
            return JavaEEEMFArchiveAdapterHelper.findArchive(eObject);
        }
        return null;
    }

    public static IVirtualComponent findComponent(IArchive anArchive) {
        IArchiveLoadAdapter loadAdapter = null;
        loadAdapter = anArchive.getArchiveOptions().hasOption((Object)WRAPPED_LOAD_ADAPTER) ? (IArchiveLoadAdapter)anArchive.getArchiveOptions().getOption((Object)WRAPPED_LOAD_ADAPTER) : (IArchiveLoadAdapter)anArchive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER");
        if (loadAdapter instanceof JavaEEBinaryComponentLoadAdapter) {
            return ((JavaEEBinaryComponentLoadAdapter)loadAdapter).getArchiveComponent();
        }
        return null;
    }

    private static void wrapArchive(IArchive simpleArchive, IPath deploymentDescriptorPath) {
        JavaEEWrappingLoadAdapter wrappingEMFLoadAdapter = new JavaEEWrappingLoadAdapter(simpleArchive, deploymentDescriptorPath);
        simpleArchive.getArchiveOptions().setOption((Object)"LOAD_ADAPTER", (Object)wrappingEMFLoadAdapter);
        simpleArchive.getArchiveOptions().setOption((Object)WRAPPED_LOAD_ADAPTER, (Object)simpleArchive.getLoadAdapter());
        ((ArchiveImpl)simpleArchive).setLoadAdapter((IArchiveLoadAdapter)wrappingEMFLoadAdapter);
    }

    /*
     * Exception decompiling
     */
    public boolean isEJBArchive(IArchive archive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Manifest getManifest(IArchive archive) {
        Manifest manifest = null;
        Path manifestPath = new Path("META-INF/MANIFEST.MF");
        if (!archive.containsArchiveResource((IPath)manifestPath)) return manifest;
        InputStream in = null;
        try {
            try {
                IArchiveResource manifestResource = archive.getArchiveResource((IPath)manifestPath);
                in = manifestResource.getInputStream();
                manifest = new Manifest(in);
                return manifest;
            }
            catch (FileNotFoundException e) {
                ArchiveUtil.warn((Throwable)e);
                if (in == null) return manifest;
                try {
                    in.close();
                    return manifest;
                }
                catch (IOException e2) {
                    ArchiveUtil.warn((Throwable)e2);
                }
                return manifest;
            }
            catch (IOException e) {
                ArchiveUtil.warn((Throwable)e);
                if (in == null) return manifest;
                try {
                    in.close();
                    return manifest;
                }
                catch (IOException e3) {
                    ArchiveUtil.warn((Throwable)e3);
                }
                return manifest;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaEEWrappingLoadAdapter
    implements IArchiveLoadAdapter {
        private IArchive simpleArchive;
        private IArchiveLoadAdapter simpleLoadAdapter;
        private IPath deploymentDescriptorPath;
        private JavaEEEMFArchiveAdapterHelper emfHelper;

        public JavaEEWrappingLoadAdapter(IArchive simpleArchive, IPath deploymentDescriptorPath) {
            this.simpleArchive = simpleArchive;
            this.simpleLoadAdapter = this.simpleArchive.getLoadAdapter();
            this.deploymentDescriptorPath = deploymentDescriptorPath;
            this.emfHelper = new JavaEEEMFArchiveAdapterHelper(this.simpleArchive);
        }

        public void close() {
            this.simpleLoadAdapter.close();
        }

        public boolean containsArchiveResource(IPath resourcePath) {
            return this.simpleLoadAdapter.containsArchiveResource(resourcePath);
        }

        public boolean containsModelObject(IPath modelObjectPath) {
            if (this.simpleLoadAdapter.containsArchiveResource(modelObjectPath)) {
                return true;
            }
            if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
                modelObjectPath = this.deploymentDescriptorPath;
            }
            return this.emfHelper.containsModelObject(modelObjectPath);
        }

        public IArchiveResource getArchiveResource(IPath resourcePath) throws FileNotFoundException {
            return this.simpleLoadAdapter.getArchiveResource(resourcePath);
        }

        public List<IArchiveResource> getArchiveResources() {
            return this.simpleLoadAdapter.getArchiveResources();
        }

        public InputStream getInputStream(IArchiveResource archiveResource) throws IOException, FileNotFoundException {
            return this.simpleLoadAdapter.getInputStream(archiveResource);
        }

        public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
            if (this.simpleLoadAdapter.containsModelObject(modelObjectPath)) {
                return this.simpleLoadAdapter.getModelObject(modelObjectPath);
            }
            if (IArchive.EMPTY_MODEL_PATH == modelObjectPath) {
                modelObjectPath = this.deploymentDescriptorPath;
            }
            return this.emfHelper.getModelObject(modelObjectPath);
        }

        public IArchive getArchive() {
            return this.simpleLoadAdapter.getArchive();
        }

        public void setArchive(IArchive archive) {
            this.simpleLoadAdapter.setArchive(archive);
        }

        public IArchiveLoadAdapter getWrappedLoadAdatper() {
            return this.simpleLoadAdapter;
        }

        public String toString() {
            return this.simpleLoadAdapter.toString();
        }
    }
}

